/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy.ern;

import com.eucalyptus.auth.policy.ern.Ern;
import com.eucalyptus.auth.policy.ern.EuareResourceName;
import com.eucalyptus.auth.policy.ern.ServiceErnBuilder;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONException;

public class EuareErnBuilder
extends ServiceErnBuilder {
    public static final Pattern ARN_PATTERN = Pattern.compile("arn:aws:iam::([0-9]{12}|eucalyptus):(?:(user|group|role|instance-profile|server-certificate)((?:/[^/\\s]+)+)|\\*)");
    public static final int ARN_PATTERNGROUP_IAM_NAMESPACE = 1;
    public static final int ARN_PATTERNGROUP_IAM_TYPE = 2;
    public static final int ARN_PATTERNGROUP_IAM_ID = 3;

    public EuareErnBuilder() {
        super(Collections.singleton("iam"));
    }

    @Override
    public Ern build(String ern, String service, String region, String account, String resource) throws JSONException {
        Matcher matcher = ARN_PATTERN.matcher(ern);
        if (matcher.matches()) {
            String name;
            String path;
            int lastSlash;
            Optional pathName = Optional.fromNullable((Object)matcher.group(3));
            int n = lastSlash = pathName.isPresent() ? ((String)pathName.get()).lastIndexOf(47) : 0;
            if (lastSlash == 0) {
                path = "/";
                name = pathName.isPresent() ? ((String)pathName.get()).substring(1) : "*";
            } else {
                path = ((String)pathName.get()).substring(0, lastSlash);
                name = ((String)pathName.get()).substring(lastSlash + 1);
            }
            String accountId = matcher.group(1);
            String type = (String)Objects.firstNonNull((Object)matcher.group(2), (Object)"*");
            return new EuareResourceName(accountId, type, path, name);
        }
        throw new JSONException("'" + ern + "' is not a valid ARN");
    }
}

