/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy.ern;

import com.eucalyptus.auth.policy.ern.ServiceErnBuilder;
import com.eucalyptus.auth.policy.ern.WildcardResourceName;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONException;

public abstract class Ern {
    public static final String ARN_PREFIX = "arn:aws:";
    public static final String ARN_WILDCARD = "*";
    public static final Pattern ARN_PATTERN = Pattern.compile("arn:aws:([a-z][a-z0-9-]*):(\\*)?:([0-9]{12}|eucalyptus)?:(.*)");
    private static List<ServiceErnBuilder> ernBuilders = new CopyOnWriteArrayList<ServiceErnBuilder>();
    public static final int ARN_PATTERNGROUP_SERVICE = 1;
    public static final int ARN_PATTERNGROUP_REGION = 2;
    public static final int ARN_PATTERNGROUP_ACCOUNT = 3;
    public static final int ARN_PATTERNGROUP_RESOURCE = 4;
    protected String vendor;
    protected String region = "";
    protected String namespace = "";

    public static Ern parse(String ern) throws JSONException {
        if (ARN_WILDCARD.equals(ern)) {
            return new WildcardResourceName();
        }
        Matcher matcher = ARN_PATTERN.matcher(ern);
        if (matcher.matches()) {
            String service = matcher.group(1);
            String region = matcher.group(2);
            String account = matcher.group(3);
            String resource = matcher.group(4);
            for (ServiceErnBuilder builder : ernBuilders) {
                if (!builder.supports(service)) continue;
                return builder.build(ern, service, region, account, resource);
            }
        }
        throw new JSONException("'" + ern + "' is not a valid ARN");
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getRegion() {
        return this.region;
    }

    public abstract String getResourceType();

    public abstract String getResourceName();

    public static void registerServiceErnBuilder(ServiceErnBuilder builder) {
        if (!ernBuilders.contains(builder)) {
            ernBuilders.add(builder);
        }
    }
}

