/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy.ern;

import com.eucalyptus.auth.policy.PolicySpec;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONException;

public class AddressUtil {
    private static final Pattern IPV4_ADDRESS_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");

    public static boolean addressRangeMatch(String pattern, String address) {
        if ("*".equals(address)) {
            return true;
        }
        Matcher patternMatcher = PolicySpec.IPV4_ADDRESS_RANGE_PATTERN.matcher(pattern);
        if (!patternMatcher.matches()) {
            return false;
        }
        if (patternMatcher.group(5) == null) {
            return pattern.equals(address);
        }
        Matcher addressMatcher = IPV4_ADDRESS_PATTERN.matcher(address);
        if (!addressMatcher.matches()) {
            return false;
        }
        try {
            long addressValue = AddressUtil.addressNumerical(addressMatcher.group(1), addressMatcher.group(2), addressMatcher.group(3), addressMatcher.group(4));
            long addressStart = AddressUtil.addressNumerical(patternMatcher.group(1), patternMatcher.group(2), patternMatcher.group(3), patternMatcher.group(4));
            long addressEnd = AddressUtil.addressNumerical(patternMatcher.group(5), patternMatcher.group(6), patternMatcher.group(7), patternMatcher.group(8));
            return addressValue >= addressStart && addressValue <= addressEnd;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void validateAddressRange(String pattern) throws JSONException {
        long endAddress;
        if (Strings.isNullOrEmpty((String)pattern)) {
            throw new JSONException("Empty address pattern");
        }
        Matcher matcher = PolicySpec.IPV4_ADDRESS_RANGE_PATTERN.matcher(pattern);
        if (!matcher.matches()) {
            throw new JSONException("Invalid IPv4 address range: " + pattern);
        }
        long startAddress = AddressUtil.addressNumerical(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4));
        if (matcher.group(5) != null && (endAddress = AddressUtil.addressNumerical(matcher.group(5), matcher.group(6), matcher.group(7), matcher.group(8))) < startAddress) {
            throw new JSONException("End address is smaller than start address in address range: " + pattern);
        }
    }

    private static long addressNumerical(String o1, String o2, String o3, String o4) throws JSONException {
        long value = 0L;
        int octet = Integer.parseInt(o1);
        if (octet > 255) {
            throw new JSONException("Address component value larger than 255: " + o1 + "." + o2 + "." + o3 + "." + o4);
        }
        value = (value << 8) + (long)octet;
        octet = Integer.parseInt(o2);
        if (octet > 255) {
            throw new JSONException("Address component value larger than 255: " + o1 + "." + o2 + "." + o3 + "." + o4);
        }
        value = (value << 8) + (long)octet;
        octet = Integer.parseInt(o3);
        if (octet > 255) {
            throw new JSONException("Address component value larger than 255: " + o1 + "." + o2 + "." + o3 + "." + o4);
        }
        value = (value << 8) + (long)octet;
        octet = Integer.parseInt(o4);
        if (octet > 255) {
            throw new JSONException("Address component value larger than 255: " + o1 + "." + o2 + "." + o3 + "." + o4);
        }
        value = (value << 8) + (long)octet;
        return value;
    }

    public static void main(String[] args) {
        AddressUtil.validateAddressRange("192.168.7.1");
        AddressUtil.validateAddressRange("192.168.7.1-192.168.7.10");
        try {
            AddressUtil.validateAddressRange("192.169.255.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            AddressUtil.validateAddressRange("192.169.256.1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            AddressUtil.validateAddressRange("192.169.255.1-");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            AddressUtil.validateAddressRange("192.169.255.1-192.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(AddressUtil.addressRangeMatch("192.168.7.10-192.168.7.122", "192.168.7.16"));
        System.out.println(AddressUtil.addressRangeMatch("192.168.7.10-192.168.7.122", "192.168.7.133"));
        System.out.println(AddressUtil.addressRangeMatch("192.168.7.10-192.168.7.122", "192.168.7.1"));
        System.out.println(AddressUtil.addressRangeMatch("192.168.7.10-192.168.7.122", "192.168.7"));
    }
}

