/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy;

import com.eucalyptus.auth.policy.PolicyAction;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.system.Ats;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class PolicySpec {
    public static final String VERSION = "Version";
    public static final String STATEMENT = "Statement";
    public static final String SID = "Sid";
    public static final String EFFECT = "Effect";
    public static final String ACTION = "Action";
    public static final String NOTACTION = "NotAction";
    public static final String RESOURCE = "Resource";
    public static final String NOTRESOURCE = "NotResource";
    public static final String PRINCIPAL = "Principal";
    public static final String NOTPRINCIPAL = "NotPrincipal";
    public static final String CONDITION = "Condition";
    public static final Set<String> EFFECTS = ImmutableSet.copyOf((Iterator)Iterators.transform((Iterator)Iterators.forArray((Object[])Authorization.EffectType.values()), (Function)new Function<Authorization.EffectType, String>(){

        public String apply(Authorization.EffectType effect) {
            return effect.name();
        }
    }));
    public static final String VENDOR_IAM = "iam";
    public static final String VENDOR_EC2 = "ec2";
    public static final String VENDOR_S3 = "s3";
    public static final String VENDOR_STS = "sts";
    public static final String VENDOR_AUTOSCALING = "autoscaling";
    public static final String VENDOR_CLOUDWATCH = "cloudwatch";
    public static final String VENDOR_IMAGINGSERVICE = "eucaimaging";
    public static final String ALL_ACTION = "*";
    public static final String IAM_ADDROLETOINSTANCEPROFILE = "addroletoinstanceprofile";
    public static final String IAM_ADDUSERTOGROUP = "addusertogroup";
    public static final String IAM_CHANGEPASSWORD = "changepassword";
    public static final String IAM_CREATEACCESSKEY = "createaccesskey";
    public static final String IAM_CREATEACCOUNT = "createaccount";
    public static final String IAM_CREATEACCOUNTALIAS = "createaccountalias";
    public static final String IAM_CREATEGROUP = "creategroup";
    public static final String IAM_CREATEINSTANCEPROFILE = "createinstanceprofile";
    public static final String IAM_CREATELOGINPROFILE = "createloginprofile";
    public static final String IAM_CREATEROLE = "createrole";
    public static final String IAM_CREATEUSER = "createuser";
    public static final String IAM_CREATEVIRTUALMFADEVICE = "createvirtualmfadevice";
    public static final String IAM_DEACTIVATEMFADEVICE = "deactivatemfadevice";
    public static final String IAM_DELETEACCESSKEY = "deleteaccesskey";
    public static final String IAM_DELETEACCOUNT = "deleteaccount";
    public static final String IAM_DELETEACCOUNTALIAS = "deleteaccountalias";
    public static final String IAM_DELETEACCOUNTPASSWORDPOLICY = "deleteaccountpasswordpolicy";
    public static final String IAM_DELETEACCOUNTPOLICY = "deleteaccountpolicy";
    public static final String IAM_DELETEGROUP = "deletegroup";
    public static final String IAM_DELETEGROUPPOLICY = "deletegrouppolicy";
    public static final String IAM_DELETEINSTANCEPROFILE = "deleteinstanceprofile";
    public static final String IAM_DELETELOGINPROFILE = "deleteloginprofile";
    public static final String IAM_DELETEROLE = "deleterole";
    public static final String IAM_DELETEROLEPOLICY = "deleterolepolicy";
    public static final String IAM_DELETESERVERCERTIFICATE = "deleteservercertificate";
    public static final String IAM_DELETESIGNINGCERTIFICATE = "deletesigningcertificate";
    public static final String IAM_DELETEUSER = "deleteuser";
    public static final String IAM_DELETEUSERPOLICY = "deleteuserpolicy";
    public static final String IAM_DELETEVIRTUALMFADEVICE = "deletevirtualmfadevice";
    public static final String IAM_ENABLEMFADEVICE = "enablemfadevice";
    public static final String IAM_GETACCOUNTPASSWORDPOLICY = "getaccountpasswordpolicy";
    public static final String IAM_GETACCOUNTPOLICY = "getaccountpolicy";
    public static final String IAM_GETACCOUNTSUMMARY = "getaccountsummary";
    public static final String IAM_GETGROUP = "getgroup";
    public static final String IAM_GETGROUPPOLICY = "getgrouppolicy";
    public static final String IAM_GETINSTANCEPROFILE = "getinstanceprofile";
    public static final String IAM_GETLOGINPROFILE = "getloginprofile";
    public static final String IAM_GETROLE = "getrole";
    public static final String IAM_GETROLEPOLICY = "getrolepolicy";
    public static final String IAM_GETSERVERCERTIFICATE = "getservercertificate";
    public static final String IAM_GETUSER = "getuser";
    public static final String IAM_GETUSERPOLICY = "getuserpolicy";
    public static final String IAM_LISTACCESSKEYS = "listaccesskeys";
    public static final String IAM_LISTACCOUNTS = "listaccounts";
    public static final String IAM_LISTACCOUNTALIASES = "listaccountaliases";
    public static final String IAM_LISTACCOUNTPOLICIES = "listaccountpolicies";
    public static final String IAM_LISTGROUPPOLICIES = "listgrouppolicies";
    public static final String IAM_LISTGROUPS = "listgroups";
    public static final String IAM_LISTGROUPSFORUSER = "listgroupsforuser";
    public static final String IAM_LISTINSTANCEPROFILES = "listinstanceprofiles";
    public static final String IAM_LISTINSTANCEPROFILESFORROLE = "listinstanceprofilesforrole";
    public static final String IAM_LISTMFADEVICES = "listmfadevices";
    public static final String IAM_LISTROLEPOLICIES = "listrolepolicies";
    public static final String IAM_LISTROLES = "listroles";
    public static final String IAM_LISTSERVERCERTIFICATES = "listservercertificates";
    public static final String IAM_LISTSIGNINGCERTIFICATES = "listsigningcertificates";
    public static final String IAM_LISTUSERPOLICIES = "listuserpolicies";
    public static final String IAM_LISTUSERS = "listusers";
    public static final String IAM_LISTVIRTUALMFADEVICES = "listvirtualmfadevices";
    public static final String IAM_PASSROLE = "passrole";
    public static final String IAM_PUTACCOUNTPOLICY = "putaccountpolicy";
    public static final String IAM_PUTGROUPPOLICY = "putgrouppolicy";
    public static final String IAM_PUTROLEPOLICY = "putrolepolicy";
    public static final String IAM_PUTUSERPOLICY = "putuserpolicy";
    public static final String IAM_REMOVEROLEFROMINSTANCEPROFILE = "removerolefrominstanceprofile";
    public static final String IAM_REMOVEUSERFROMGROUP = "removeuserfromgroup";
    public static final String IAM_RESYNCMFADEVICE = "resyncmfadevice";
    public static final String IAM_UPDATEACCESSKEY = "updateaccesskey";
    public static final String IAM_UPDATEACCOUNTPASSWORDPOLICY = "updateaccountpasswordpolicy";
    public static final String IAM_UPDATEASSUMEROLEPOLICY = "updateassumerolepolicy";
    public static final String IAM_UPDATEGROUP = "updategroup";
    public static final String IAM_UPDATELOGINPROFILE = "updateloginprofile";
    public static final String IAM_UPDATESERVERCERTIFICATE = "updateservercertificate";
    public static final String IAM_UPDATESIGNINGCERTIFICATE = "updatesigningcertificate";
    public static final String IAM_UPDATEUSER = "updateuser";
    public static final String IAM_UPLOADSERVERCERTIFICATE = "uploadservercertificate";
    public static final String IAM_UPLOADSIGNINGCERTIFICATE = "uploadsigningcertificate";
    public static final String IAM_DOWNLOADSERVERCERTIFICATE = "downloadservercertificate";
    public static final String IAM_DOWNLOADCLOUDCERTIFICATE = "downloadcloudcertificate";
    public static final String EC2_ALLOCATEADDRESS = "allocateaddress";
    public static final String EC2_ASSIGNPRIVATEIPADDRESSES = "assignprivateipaddresses";
    public static final String EC2_ASSOCIATEADDRESS = "associateaddress";
    public static final String EC2_ASSOCIATEDHCPOPTIONS = "associatedhcpoptions";
    public static final String EC2_ASSOCIATEROUTETABLE = "associateroutetable";
    public static final String EC2_ATTACHINTERNETGATEWAY = "attachinternetgateway";
    public static final String EC2_ATTACHNETWORKINTERFACE = "attachnetworkinterface";
    public static final String EC2_ATTACHVOLUME = "attachvolume";
    public static final String EC2_ATTACHVPNGATEWAY = "attachvpngateway";
    public static final String EC2_AUTHORIZESECURITYGROUPEGRESS = "authorizesecuritygroupegress";
    public static final String EC2_AUTHORIZESECURITYGROUPINGRESS = "authorizesecuritygroupingress";
    public static final String EC2_BUNDLEINSTANCE = "bundleinstance";
    public static final String EC2_CANCELBUNDLETASK = "cancelbundletask";
    public static final String EC2_CANCELCONVERSIONTASK = "cancelconversiontask";
    public static final String EC2_CANCELEXPORTTASK = "cancelexporttask";
    public static final String EC2_CANCELRESERVEDINSTANCESLISTING = "cancelreservedinstanceslisting";
    public static final String EC2_CANCELSPOTINSTANCEREQUESTS = "cancelspotinstancerequests";
    public static final String EC2_CONFIRMPRODUCTINSTANCE = "confirmproductinstance";
    public static final String EC2_COPYIMAGE = "copyimage";
    public static final String EC2_COPYSNAPSHOT = "copysnapshot";
    public static final String EC2_CREATECUSTOMERGATEWAY = "createcustomergateway";
    public static final String EC2_CREATEDHCPOPTIONS = "createdhcpoptions";
    public static final String EC2_CREATEIMAGE = "createimage";
    public static final String EC2_CREATEINSTANCEEXPORTTASK = "createinstanceexporttask";
    public static final String EC2_CREATEINTERNETGATEWAY = "createinternetgateway";
    public static final String EC2_CREATEKEYPAIR = "createkeypair";
    public static final String EC2_CREATENETWORKACL = "createnetworkacl";
    public static final String EC2_CREATENETWORKACLENTRY = "createnetworkaclentry";
    public static final String EC2_CREATENETWORKINTERFACE = "createnetworkinterface";
    public static final String EC2_CREATEPLACEMENTGROUP = "createplacementgroup";
    public static final String EC2_CREATERESERVEDINSTANCESLISTING = "createreservedinstanceslisting";
    public static final String EC2_CREATEROUTE = "createroute";
    public static final String EC2_CREATEROUTETABLE = "createroutetable";
    public static final String EC2_CREATESECURITYGROUP = "createsecuritygroup";
    public static final String EC2_CREATESNAPSHOT = "createsnapshot";
    public static final String EC2_CREATESPOTDATAFEEDSUBSCRIPTION = "createspotdatafeedsubscription";
    public static final String EC2_CREATESUBNET = "createsubnet";
    public static final String EC2_CREATETAGS = "createtags";
    public static final String EC2_CREATEVOLUME = "createvolume";
    public static final String EC2_CREATEVPC = "createvpc";
    public static final String EC2_CREATEVPNCONNECTION = "createvpnconnection";
    public static final String EC2_CREATEVPNCONNECTIONROUTE = "createvpnconnectionroute";
    public static final String EC2_CREATEVPNGATEWAY = "createvpngateway";
    public static final String EC2_DELETECUSTOMERGATEWAY = "deletecustomergateway";
    public static final String EC2_DELETEDHCPOPTIONS = "deletedhcpoptions";
    public static final String EC2_DELETEINTERNETGATEWAY = "deleteinternetgateway";
    public static final String EC2_DELETEKEYPAIR = "deletekeypair";
    public static final String EC2_DELETENETWORKACL = "deletenetworkacl";
    public static final String EC2_DELETENETWORKACLENTRY = "deletenetworkaclentry";
    public static final String EC2_DELETENETWORKINTERFACE = "deletenetworkinterface";
    public static final String EC2_DELETEPLACEMENTGROUP = "deleteplacementgroup";
    public static final String EC2_DELETEROUTE = "deleteroute";
    public static final String EC2_DELETEROUTETABLE = "deleteroutetable";
    public static final String EC2_DELETESECURITYGROUP = "deletesecuritygroup";
    public static final String EC2_DELETESNAPSHOT = "deletesnapshot";
    public static final String EC2_DELETESPOTDATAFEEDSUBSCRIPTION = "deletespotdatafeedsubscription";
    public static final String EC2_DELETESUBNET = "deletesubnet";
    public static final String EC2_DELETETAGS = "deletetags";
    public static final String EC2_DELETEVOLUME = "deletevolume";
    public static final String EC2_DELETEVPC = "deletevpc";
    public static final String EC2_DELETEVPNCONNECTION = "deletevpnconnection";
    public static final String EC2_DELETEVPNCONNECTIONROUTE = "deletevpnconnectionroute";
    public static final String EC2_DELETEVPNGATEWAY = "deletevpngateway";
    public static final String EC2_DEREGISTERIMAGE = "deregisterimage";
    public static final String EC2_DESCRIBEACCOUNTATTRIBUTES = "describeaccountattributes";
    public static final String EC2_DESCRIBEADDRESSES = "describeaddresses";
    public static final String EC2_DESCRIBEAVAILABILITYZONES = "describeavailabilityzones";
    public static final String EC2_DESCRIBEBUNDLETASKS = "describebundletasks";
    public static final String EC2_DESCRIBECONVERSIONTASKS = "describeconversiontasks";
    public static final String EC2_DESCRIBECUSTOMERGATEWAYS = "describecustomergateways";
    public static final String EC2_DESCRIBEDHCPOPTIONS = "describedhcpoptions";
    public static final String EC2_DESCRIBEEXPORTTASKS = "describeexporttasks";
    public static final String EC2_DESCRIBEIMAGEATTRIBUTE = "describeimageattribute";
    public static final String EC2_DESCRIBEIMAGES = "describeimages";
    public static final String EC2_DESCRIBEINSTANCEATTRIBUTE = "describeinstanceattribute";
    public static final String EC2_DESCRIBEINSTANCES = "describeinstances";
    public static final String EC2_DESCRIBEINSTANCESTATUS = "describeinstancestatus";
    public static final String EC2_DESCRIBEINSTANCETYPES = "describeinstancetypes";
    public static final String EC2_DESCRIBEINTERNETGATEWAYS = "describeinternetgateways";
    public static final String EC2_DESCRIBEKEYPAIRS = "describekeypairs";
    public static final String EC2_DESCRIBENETWORKACLS = "describenetworkacls";
    public static final String EC2_DESCRIBENETWORKINTERFACEATTRIBUTE = "describenetworkinterfaceattribute";
    public static final String EC2_DESCRIBENETWORKINTERFACES = "describenetworkinterfaces";
    public static final String EC2_DESCRIBEPLACEMENTGROUPS = "describeplacementgroups";
    public static final String EC2_DESCRIBEREGIONS = "describeregions";
    public static final String EC2_DESCRIBERESERVEDINSTANCES = "describereservedinstances";
    public static final String EC2_DESCRIBERESERVEDINSTANCESLISTINGS = "describereservedinstanceslistings";
    public static final String EC2_DESCRIBERESERVEDINSTANCESMODIFICATIONS = "describereservedinstancesmodifications";
    public static final String EC2_DESCRIBERESERVEDINSTANCESOFFERINGS = "describereservedinstancesofferings";
    public static final String EC2_DESCRIBEROUTETABLES = "describeroutetables";
    public static final String EC2_DESCRIBESECURITYGROUPS = "describesecuritygroups";
    public static final String EC2_DESCRIBESNAPSHOTATTRIBUTE = "describesnapshotattribute";
    public static final String EC2_DESCRIBESNAPSHOTS = "describesnapshots";
    public static final String EC2_DESCRIBESPOTDATAFEEDSUBSCRIPTION = "describespotdatafeedsubscription";
    public static final String EC2_DESCRIBESPOTINSTANCEREQUESTS = "describespotinstancerequests";
    public static final String EC2_DESCRIBESPOTPRICEHISTORY = "describespotpricehistory";
    public static final String EC2_DESCRIBESUBNETS = "describesubnets";
    public static final String EC2_DESCRIBETAGS = "describetags";
    public static final String EC2_DESCRIBEVOLUMEATTRIBUTE = "describevolumeattribute";
    public static final String EC2_DESCRIBEVOLUMES = "describevolumes";
    public static final String EC2_DESCRIBEVOLUMESTATUS = "describevolumestatus";
    public static final String EC2_DESCRIBEVPCATTRIBUTE = "describevpcattribute";
    public static final String EC2_DESCRIBEVPCS = "describevpcs";
    public static final String EC2_DESCRIBEVPNCONNECTIONS = "describevpnconnections";
    public static final String EC2_DESCRIBEVPNGATEWAYS = "describevpngateways";
    public static final String EC2_DETACHINTERNETGATEWAY = "detachinternetgateway";
    public static final String EC2_DETACHNETWORKINTERFACE = "detachnetworkinterface";
    public static final String EC2_DETACHVOLUME = "detachvolume";
    public static final String EC2_DETACHVPNGATEWAY = "detachvpngateway";
    public static final String EC2_DISABLEVGWROUTEPROPAGATION = "disablevgwroutepropagation";
    public static final String EC2_DISASSOCIATEADDRESS = "disassociateaddress";
    public static final String EC2_DISASSOCIATEROUTETABLE = "disassociateroutetable";
    public static final String EC2_ENABLEVGWROUTEPROPAGATION = "enablevgwroutepropagation";
    public static final String EC2_ENABLEVOLUMEIO = "enablevolumeio";
    public static final String EC2_GETCONSOLEOUTPUT = "getconsoleoutput";
    public static final String EC2_GETPASSWORDDATA = "getpassworddata";
    public static final String EC2_IMPORTINSTANCE = "importinstance";
    public static final String EC2_IMPORTKEYPAIR = "importkeypair";
    public static final String EC2_IMPORTVOLUME = "importvolume";
    public static final String EC2_MIGRATEINSTANCES = "migrateinstances";
    public static final String EC2_MODIFYIMAGEATTRIBUTE = "modifyimageattribute";
    public static final String EC2_MODIFYINSTANCEATTRIBUTE = "modifyinstanceattribute";
    public static final String EC2_MODIFYNETWORKINTERFACEATTRIBUTE = "modifynetworkinterfaceattribute";
    public static final String EC2_MODIFYRESERVEDINSTANCES = "modifyreservedinstances";
    public static final String EC2_MODIFYSNAPSHOTATTRIBUTE = "modifysnapshotattribute";
    public static final String EC2_MODIFYVOLUMEATTRIBUTE = "modifyvolumeattribute";
    public static final String EC2_MODIFYVMTYPE = "modifyvmtype";
    public static final String EC2_MODIFYVPCATTRIBUTE = "modifyvpcattribute";
    public static final String EC2_MONITORINSTANCES = "monitorinstances";
    public static final String EC2_PURCHASERESERVEDINSTANCESOFFERING = "purchasereservedinstancesoffering";
    public static final String EC2_REBOOTINSTANCES = "rebootinstances";
    public static final String EC2_REGISTERIMAGE = "registerimage";
    public static final String EC2_RELEASEADDRESS = "releaseaddress";
    public static final String EC2_REPLACENETWORKACLASSOCIATION = "replacenetworkaclassociation";
    public static final String EC2_REPLACENETWORKACLENTRY = "replacenetworkaclentry";
    public static final String EC2_REPLACEROUTE = "replaceroute";
    public static final String EC2_REPLACEROUTETABLEASSOCIATION = "replaceroutetableassociation";
    public static final String EC2_REPORTINSTANCESTATUS = "reportinstancestatus";
    public static final String EC2_REQUESTSPOTINSTANCES = "requestspotinstances";
    public static final String EC2_RESETIMAGEATTRIBUTE = "resetimageattribute";
    public static final String EC2_RESETINSTANCEATTRIBUTE = "resetinstanceattribute";
    public static final String EC2_RESETNETWORKINTERFACEATTRIBUTE = "resetnetworkinterfaceattribute";
    public static final String EC2_RESETSNAPSHOTATTRIBUTE = "resetsnapshotattribute";
    public static final String EC2_REVOKESECURITYGROUPEGRESS = "revokesecuritygroupegress";
    public static final String EC2_REVOKESECURITYGROUPINGRESS = "revokesecuritygroupingress";
    public static final String EC2_RUNINSTANCES = "runinstances";
    public static final String EC2_STARTINSTANCES = "startinstances";
    public static final String EC2_STOPINSTANCES = "stopinstances";
    public static final String EC2_TERMINATEINSTANCES = "terminateinstances";
    public static final String EC2_UNASSIGNPRIVATEIPADDRESSES = "unassignprivateipaddresses";
    public static final String EC2_UNMONITORINSTANCES = "unmonitorinstances";
    public static final String EC2_ACTIVATELICENSE = "activatelicense";
    public static final String EC2_DEACTIVATELICENSE = "deactivatelicense";
    public static final String EC2_DESCRIBELICENSES = "describelicenses";
    public static final String S3_ABORTMULTIPARTUPLOAD = "abortmultipartupload";
    public static final String S3_CREATEBUCKET = "createbucket";
    public static final String S3_DELETEBUCKET = "deletebucket";
    public static final String S3_DELETEBUCKETPOLICY = "deletebucketpolicy";
    public static final String S3_DELETEBUCKETWEBSITE = "deletebucketwebsite";
    public static final String S3_DELETEOBJECT = "deleteobject";
    public static final String S3_DELETEOBJECTVERSION = "deleteobjectversion";
    public static final String S3_GETBUCKETACL = "getbucketacl";
    public static final String S3_GETBUCKETCORS = "getbucketcors";
    public static final String S3_GETBUCKETLOCATION = "getbucketlocation";
    public static final String S3_GETBUCKETLOGGING = "getbucketlogging";
    public static final String S3_GETBUCKETNOTIFICATION = "getbucketnotification";
    public static final String S3_GETBUCKETPOLICY = "getbucketpolicy";
    public static final String S3_GETBUCKETREQUESTPAYMENT = "getbucketrequestpayment";
    public static final String S3_GETBUCKETVERSIONING = "getbucketversioning";
    public static final String S3_GETBUCKETWEBSITE = "getbucketwebsite";
    public static final String S3_GETBUCKETTAGGING = "getbuckettagging";
    public static final String S3_GETLIFECYCLECONFIGURATION = "getlifecycleconfiguration";
    public static final String S3_GETOBJECT = "getobject";
    public static final String S3_GETOBJECTACL = "getobjectacl";
    public static final String S3_GETOBJECTTORRENT = "getobjecttorrent";
    public static final String S3_GETOBJECTVERSION = "getobjectversion";
    public static final String S3_GETOBJECTVERSIONACL = "getobjectversionacl";
    public static final String S3_GETOBJECTVERSIONTORRENT = "getobjectversiontorrent";
    public static final String S3_HEADOBJECT = "headobject";
    public static final String S3_LISTALLMYBUCKETS = "listallmybuckets";
    public static final String S3_LISTBUCKET = "listbucket";
    public static final String S3_LISTBUCKETMULTIPARTUPLOADS = "listbucketmultipartuploads";
    public static final String S3_LISTBUCKETVERSIONS = "listbucketversions";
    public static final String S3_LISTMULTIPARTUPLOADPARTS = "listmultipartuploadparts";
    public static final String S3_PUTBUCKETACL = "putbucketacl";
    public static final String S3_PUTBUCKETCORS = "putbucketcors";
    public static final String S3_PUTBUCKETLOGGING = "putbucketlogging";
    public static final String S3_PUTBUCKETNOTIFICATION = "putbucketnotification";
    public static final String S3_PUTBUCKETPOLICY = "putbucketpolicy";
    public static final String S3_PUTBUCKETREQUESTPAYMENT = "putbucketrequestpayment";
    public static final String S3_PUTBUCKETVERSIONING = "putbucketversioning";
    public static final String S3_PUTBUCKETWEBSITE = "putbucketwebsite";
    public static final String S3_PUTBUCKETTAGGING = "putbuckettagging";
    public static final String S3_PUTLIFECYCLECONFIGURATION = "putlifecycleconfiguration";
    public static final String S3_PUTOBJECT = "putobject";
    public static final String S3_PUTOBJECTACL = "putobjectacl";
    public static final String S3_PUTOBJECTVERSIONACL = "putobjectversionacl";
    public static final String S3_RESTOREOBJECT = "restoreobject";
    public static final String STS_ASSUMEROLE = "assumerole";
    public static final String STS_ASSUMEROLEWITHWEBIDENTITY = "assumerolewithwebidentity";
    public static final String STS_DECODEAUTHORIZATIONMESSAGE = "decodeauthorizationmessage";
    public static final String STS_GETACCESSTOKEN = "getaccesstoken";
    public static final String STS_GETFEDERATIONTOKEN = "getfederationtoken";
    public static final String STS_GETIMPERSONATIONTOKEN = "getimpersonationtoken";
    public static final String STS_GETSESSIONTOKEN = "getsessiontoken";
    public static final String AUTOSCALING_CREATEAUTOSCALINGGROUP = "createautoscalinggroup";
    public static final String AUTOSCALING_CREATELAUNCHCONFIGURATION = "createlaunchconfiguration";
    public static final String AUTOSCALING_CREATEORUPDATESCALINGTRIGGER = "createorupdatescalingtrigger";
    public static final String AUTOSCALING_CREATEORUPDATETAGS = "createorupdatetags";
    public static final String AUTOSCALING_DELETEAUTOSCALINGGROUP = "deleteautoscalinggroup";
    public static final String AUTOSCALING_DELETELAUNCHCONFIGURATION = "deletelaunchconfiguration";
    public static final String AUTOSCALING_DELETENOTIFICATIONCONFIGURATION = "deletenotificationconfiguration";
    public static final String AUTOSCALING_DELETEPOLICY = "deletepolicy";
    public static final String AUTOSCALING_DELETESCHEDULEDACTION = "deletescheduledaction";
    public static final String AUTOSCALING_DELETETAGS = "deletetags";
    public static final String AUTOSCALING_DELETETRIGGER = "deletetrigger";
    public static final String AUTOSCALING_DESCRIBEADJUSTMENTTYPES = "describeadjustmenttypes";
    public static final String AUTOSCALING_DESCRIBEAUTOSCALINGGROUPS = "describeautoscalinggroups";
    public static final String AUTOSCALING_DESCRIBEAUTOSCALINGINSTANCES = "describeautoscalinginstances";
    public static final String AUTOSCALING_DESCRIBEAUTOSCALINGNOTIFICATIONTYPES = "describeautoscalingnotificationtypes";
    public static final String AUTOSCALING_DESCRIBELAUNCHCONFIGURATIONS = "describelaunchconfigurations";
    public static final String AUTOSCALING_DESCRIBEMETRICCOLLECTIONTYPES = "describemetriccollectiontypes";
    public static final String AUTOSCALING_DESCRIBENOTIFICATIONCONFIGURATIONS = "describenotificationconfigurations";
    public static final String AUTOSCALING_DESCRIBEPOLICIES = "describepolicies";
    public static final String AUTOSCALING_DESCRIBESCALINGACTIVITIES = "describescalingactivities";
    public static final String AUTOSCALING_DESCRIBESCALINGPROCESSTYPES = "describescalingprocesstypes";
    public static final String AUTOSCALING_DESCRIBESCHEDULEDACTIONS = "describescheduledactions";
    public static final String AUTOSCALING_DESCRIBETAGS = "describetags";
    public static final String AUTOSCALING_DESCRIBETERMINATIONPOLICYTYPES = "describeterminationpolicytypes";
    public static final String AUTOSCALING_DESCRIBETRIGGERS = "describetriggers";
    public static final String AUTOSCALING_DISABLEMETRICSCOLLECTION = "disablemetricscollection";
    public static final String AUTOSCALING_ENABLEMETRICSCOLLECTION = "enablemetricscollection";
    public static final String AUTOSCALING_EXECUTEPOLICY = "executepolicy";
    public static final String AUTOSCALING_PUTNOTIFICATIONCONFIGURATION = "putnotificationconfiguration";
    public static final String AUTOSCALING_PUTSCALINGPOLICY = "putscalingpolicy";
    public static final String AUTOSCALING_PUTSCHEDULEDUPDATEGROUPACTION = "putscheduledupdategroupaction";
    public static final String AUTOSCALING_RESUMEPROCESSES = "resumeprocesses";
    public static final String AUTOSCALING_SETDESIREDCAPACITY = "setdesiredcapacity";
    public static final String AUTOSCALING_SETINSTANCEHEALTH = "setinstancehealth";
    public static final String AUTOSCALING_SUSPENDPROCESSES = "suspendprocesses";
    public static final String AUTOSCALING_TERMINATEINSTANCEINAUTOSCALINGGROUP = "terminateinstanceinautoscalinggroup";
    public static final String AUTOSCALING_UPDATEAUTOSCALINGGROUP = "updateautoscalinggroup";
    public static final String CLOUDWATCH_DELETEALARMS = "deletealarms";
    public static final String CLOUDWATCH_DESCRIBEALARMHISTORY = "describealarmhistory";
    public static final String CLOUDWATCH_DESCRIBEALARMS = "describealarms";
    public static final String CLOUDWATCH_DESCRIBEALARMSFORMETRIC = "describealarmsformetric";
    public static final String CLOUDWATCH_DISABLEALARMACTIONS = "disablealarmactions";
    public static final String CLOUDWATCH_ENABLEALARMACTIONS = "enablealarmactions";
    public static final String CLOUDWATCH_GETMETRICSTATISTICS = "getmetricstatistics";
    public static final String CLOUDWATCH_LISTMETRICS = "listmetrics";
    public static final String CLOUDWATCH_PUTMETRICALARM = "putmetricalarm";
    public static final String CLOUDWATCH_PUTMETRICDATA = "putmetricdata";
    public static final String CLOUDWATCH_SETALARMSTATE = "setalarmstate";
    public static final String IMAGINGSERVICE_PUTINSTANCEIMPORTTASKSTATUS = "putinstanceimporttaskstatus";
    public static final String IMAGINGSERVICE_GETINSTANCEIMPORTTASK = "getinstanceimporttask";
    public static final Map<String, Set<String>> VENDOR_RESOURCE_VENDORS = new ImmutableMap.Builder().put((Object)"sts", (Object)ImmutableSet.of((Object)"iam")).build();
    public static final Set<String> VENDORS_CASE_INSENSITIVE_RESOURCES = new ImmutableSet.Builder().add((Object)"ec2").add((Object)"s3").build();
    public static final Pattern ACTION_PATTERN = Pattern.compile("\\*|(?:([a-z0-9]+):(\\S+))");
    public static final String ALL_RESOURCE = "*";
    public static final String IAM_RESOURCE_ACCOUNT = "account";
    public static final String IAM_RESOURCE_GROUP = "group";
    public static final String IAM_RESOURCE_USER = "user";
    public static final String IAM_RESOURCE_ROLE = "role";
    public static final String IAM_RESOURCE_INSTANCE_PROFILE = "instance-profile";
    public static final String IAM_RESOURCE_SERVER_CERTIFICATE = "server-certificate";
    public static final String IAM_RESOURCE_ACCESS_KEY = "access-key";
    public static final String IAM_RESOURCE_SIGNING_CERTIFICATE = "signing-certificate";
    public static final String EC2_RESOURCE_IMAGE = "image";
    public static final String EC2_RESOURCE_SECURITYGROUP = "security-group";
    public static final String EC2_RESOURCE_ADDRESS = "address";
    public static final String EC2_RESOURCE_AVAILABILITYZONE = "availabilityzone";
    public static final String EC2_RESOURCE_INSTANCE = "instance";
    public static final String EC2_RESOURCE_KEYPAIR = "key-pair";
    public static final String EC2_RESOURCE_VOLUME = "volume";
    public static final String EC2_RESOURCE_SNAPSHOT = "snapshot";
    public static final String EC2_RESOURCE_VMTYPE = "vmtype";
    public static final String EC2_RESOURCE_TAG = "tag";
    public static final String EC2_RESOURCE_PLACEMENTGROUP = "placement-group";
    public static final String EC2_RESOURCE_CUSTOMERGATEWAY = "customer-gateway";
    public static final String EC2_RESOURCE_DHCPOPTIONS = "dhcp-options";
    public static final String EC2_RESOURCE_INTERNETGATEWAY = "internet-gateway";
    public static final String EC2_RESOURCE_NETWORKACL = "network-acl";
    public static final String EC2_RESOURCE_NETWORKINTERFACE = "network-interface";
    public static final String EC2_RESOURCE_ROUTETABLE = "route-table";
    public static final String EC2_RESOURCE_SUBNET = "subnet";
    public static final String EC2_RESOURCE_VPCPEERINGCONNECTION = "vpc-peering-connection";
    public static final String EC2_RESOURCE_VPC = "vpc";
    public static final Set<String> EC2_RESOURCES = new ImmutableSet.Builder().add((Object)"image").add((Object)"security-group").add((Object)"security-group".replace("-", "")).add((Object)"address").add((Object)"availabilityzone").add((Object)"instance").add((Object)"key-pair").add((Object)"key-pair".replace("-", "")).add((Object)"volume").add((Object)"snapshot").add((Object)"vmtype").add((Object)"tag").add((Object)"placement-group").add((Object)"customer-gateway").add((Object)"dhcp-options").add((Object)"internet-gateway").add((Object)"network-acl").add((Object)"network-interface").add((Object)"route-table").add((Object)"subnet").add((Object)"vpc-peering-connection").add((Object)"vpc").build();
    public static final Pattern IPV4_ADDRESS_RANGE_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})(?:-(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3}))?");
    public static final String S3_RESOURCE_BUCKET = "bucket";
    public static final String S3_RESOURCE_OBJECT = "object";
    public static final String AUTOSCALING_RESOURCE_TAG = "tag";

    public static String qualifiedName(String vendor, String name) {
        return name == null ? null : vendor + ":" + name;
    }

    public static String vendor(String qualifiedName) {
        int index = qualifiedName.indexOf(58);
        if (index <= 0) {
            throw new IllegalArgumentException("Name not qualified: " + qualifiedName);
        }
        return qualifiedName.substring(0, index);
    }

    public static boolean isPermittedResourceVendor(String vendor, String resourceVendor) {
        Set<String> resourceVendors = VENDOR_RESOURCE_VENDORS.get(vendor);
        return resourceVendors == null ? vendor.equals(resourceVendor) : resourceVendors.contains(resourceVendor);
    }

    public static String requestToAction(BaseMessage request) {
        PolicyAction action;
        if (request != null && (action = Ats.from(request).get(PolicyAction.class)) != null) {
            return action.action();
        }
        return null;
    }

    public static String describeAction(String vendor, String resource) {
        return "describe" + resource + "s";
    }

    public static String canonicalizeResourceName(String type, String name) {
        return type == null || !VENDORS_CASE_INSENSITIVE_RESOURCES.contains(PolicySpec.vendor(type)) ? name : name.toLowerCase();
    }
}

