/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy;

import com.eucalyptus.auth.policy.PolicyResourceType;
import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.system.Ats;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class PolicyAnnotationRegistry
extends ServiceJarDiscovery {
    private static Logger LOG = Logger.getLogger(PolicyAnnotationRegistry.class);
    private static final Map<Class, PolicyResourceType> classToPolicyRscType = new HashMap<Class, PolicyResourceType>();

    public static PolicyResourceType extractResourceType(Object classOrInstance) throws NoSuchElementException {
        Class<?> type = classOrInstance instanceof Class ? (Class<?>)classOrInstance : classOrInstance.getClass();
        PolicyResourceType rscPolicy = PolicyAnnotationRegistry.extractPolicyResourceTypeFromSuperclass(type);
        if (rscPolicy != null) {
            classToPolicyRscType.put(type, rscPolicy);
            return rscPolicy;
        }
        throw new NoSuchElementException("The argument " + type.getName() + " does not itself have or inherit from an object with the required @PolicyResourceType annotation.");
    }

    private static PolicyResourceType extractPolicyResourceTypeFromSuperclass(Class type) {
        LOG.trace((Object)("PolicyAnnotationRegistry: looking for annotations starting at " + type));
        for (Class c = type; c != Object.class; c = c.getSuperclass()) {
            LOG.trace((Object)("PolicyAnnotationRegistry: check -> " + c));
            if (classToPolicyRscType.containsKey(c)) {
                LOG.trace((Object)("PolicyAnnotationRegistry: FOUND => " + c));
                return classToPolicyRscType.get(c);
            }
            PolicyResourceType rscPolicy = PolicyAnnotationRegistry.extractPolicyResourceTypeFromInterfaces(type.getInterfaces());
            if (rscPolicy == null) continue;
            return rscPolicy;
        }
        return null;
    }

    private static PolicyResourceType extractPolicyResourceTypeFromInterfaces(Class[] interfaces) {
        for (Class i : interfaces) {
            LOG.trace((Object)("PolicyAnnotationRegistry: check => " + i));
            if (!classToPolicyRscType.containsKey(i)) continue;
            LOG.trace((Object)("PolicyAnnotationRegistry: FOUND => " + i));
            return classToPolicyRscType.get(i);
        }
        return null;
    }

    @Override
    public boolean processClass(Class candidate) throws Exception {
        if (Ats.from(candidate).has(PolicyResourceType.class)) {
            PolicyResourceType policyRscType = Ats.from(candidate).get(PolicyResourceType.class);
            classToPolicyRscType.put(candidate, policyRscType);
            return true;
        }
        return false;
    }

    @Override
    public Double getPriority() {
        return 1.0;
    }
}

