/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.login;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.api.BaseLoginModule;
import com.eucalyptus.auth.login.SecurityContext;
import com.eucalyptus.auth.login.WsSecCredentials;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.binding.HoldMe;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.crypto.util.WSSecurity;
import java.security.cert.X509Certificate;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.apache.xml.security.signature.XMLSignature;
import org.w3c.dom.Element;

public class WsSecLoginModule
extends BaseLoginModule<WsSecCredentials> {
    private static Logger LOG = Logger.getLogger(WsSecLoginModule.class);

    @Override
    public boolean accepts() {
        return super.getCallbackHandler() instanceof WsSecCredentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticate(WsSecCredentials wrappedCredentials) throws Exception {
        HoldMe.canHas.lock();
        try {
            Element secNode = WSSecurity.getSecurityElement((SOAPEnvelope)wrappedCredentials.getLoginData());
            XMLSignature sig = WSSecurity.getXMLSignature(secNode);
            String sigValue = B64.standard.encString(sig.getSignatureValue());
            SecurityContext.enqueueSignature(sigValue);
            X509Certificate cert = WSSecurity.verifySignature(secNode, sig);
            try {
                User user = Accounts.lookupUserByCertificate(cert);
                super.setCredential(cert);
                super.setPrincipal(user);
            }
            catch (AuthException e) {
                try {
                    if (!Accounts.lookupCertificate(cert).isActive().booleanValue()) {
                        throw new AuthException("Certificate is inactive or revoked: " + e.getMessage(), e);
                    }
                    throw e;
                }
                catch (Exception ex) {
                    throw e;
                }
            }
        }
        finally {
            HoldMe.canHas.unlock();
        }
        return true;
    }
}

