/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.login;

import com.eucalyptus.auth.login.AuthenticationException;
import com.eucalyptus.auth.login.WrappedCredentials;
import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.util.TimedEvictionSet;
import com.eucalyptus.ws.StackConfiguration;
import com.google.common.collect.Lists;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.log4j.Logger;

public class SecurityContext
extends Configuration {
    private static SecurityContext singleton = new SecurityContext();
    private static Logger LOG = Logger.getLogger(SecurityContext.class);
    private static TimedEvictionSet<String> replayQueue = new TimedEvictionSet(TimeUnit.MILLISECONDS.convert(900 + StackConfiguration.CLOCK_SKEW_SEC, TimeUnit.SECONDS));
    private List<String> loginModules = Lists.newArrayList();
    private static Map emptyMap = new HashMap();

    private SecurityContext() {
    }

    public static void enqueueSignature(String signature) throws AuthenticationException {
        if (!replayQueue.add(signature)) {
            LOG.info((Object)("Replay detected for " + signature));
            throw new AuthenticationException("Message replay detected.  Same signature was used within the last 15 minutes");
        }
    }

    public static LoginContext getLoginContext(WrappedCredentials credentials) throws LoginException {
        return new LoginContext("eucalyptus", new Subject(), credentials, singleton);
    }

    public static boolean validateTimestampPeriod(Date expires) {
        Long nanoLimit = replayQueue.getEvictionNanos();
        Date currentDate = new Date();
        return currentDate.getTime() + nanoLimit / 1000000L >= expires.getTime();
    }

    public static void registerLoginModule(Class loginModuleClass) {
        SecurityContext.singleton.loginModules.add(loginModuleClass.getName());
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        AppConfigurationEntry[] entries = new AppConfigurationEntry[this.loginModules.size()];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = new AppConfigurationEntry(this.loginModules.get(i), AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, emptyMap);
        }
        return entries;
    }

    public static class LoginModuleDiscovery
    extends ServiceJarDiscovery {
        @Override
        public Double getPriority() {
            return 0.2;
        }

        @Override
        public boolean processClass(Class candidate) throws Exception {
            if (LoginModule.class.isAssignableFrom(candidate) && !Modifier.isAbstract(candidate.getModifiers()) && !Modifier.isPrivate(candidate.getModifiers())) {
                SecurityContext.registerLoginModule(candidate);
                return true;
            }
            return false;
        }
    }
}

