/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.login;

import com.eucalyptus.auth.AccessKeys;
import com.eucalyptus.auth.InvalidSignatureAuthException;
import com.eucalyptus.auth.login.AuthenticationException;
import com.eucalyptus.auth.login.HmacCredentials;
import com.eucalyptus.auth.login.HmacLoginModuleSupport;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.crypto.Digest;
import com.eucalyptus.crypto.Hmac;
import com.eucalyptus.crypto.util.SecurityHeader;
import com.eucalyptus.crypto.util.SecurityParameter;
import com.eucalyptus.crypto.util.Timestamps;
import com.eucalyptus.ws.util.HmacUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Hex;

public class Hmacv4LoginModule
extends HmacLoginModuleSupport {
    private static final Logger LOG = Logger.getLogger(Hmacv4LoginModule.class);
    private static final String V4_TERMINATOR = "aws4_request";

    public Hmacv4LoginModule() {
        super(4);
    }

    @Override
    public boolean authenticate(HmacCredentials credentials) throws Exception {
        String canonicalStringNoPath;
        byte[] computedSigNoPath;
        if (credentials.getSignatureMethod() != Hmac.HmacSHA256) {
            throw new AuthenticationException("Invalid signature method for v4: " + (Object)((Object)credentials.getSignatureMethod()));
        }
        String sig = credentials.getSignature();
        this.checkForReplay(sig);
        Function<String, List<String>> headerLookup = HmacUtils.headerLookup(credentials.getHeaders());
        Function<String, List<String>> parameterLookup = HmacUtils.parameterLookup(credentials.getParameters());
        Map<String, String> authorizationParameters = credentials.getVariant().getAuthorizationParameters(headerLookup, parameterLookup);
        HmacUtils.SignatureCredential signatureCredential = new HmacUtils.SignatureCredential(authorizationParameters.get("Credential"));
        AccessKey accessKey = this.lookupAccessKey(credentials);
        Date date = HmacUtils.getSignatureDate(EnumSet.of(HmacUtils.SignatureVersion.SignatureV4), headerLookup, parameterLookup);
        signatureCredential.verify(date, null, null, V4_TERMINATOR);
        User user = accessKey.getUser();
        String secretKey = accessKey.getSecretKey();
        byte[] signatureKey = this.getSignatureKey(secretKey, signatureCredential);
        String canonicalString = this.makeSubjectString(credentials, signatureCredential, authorizationParameters, date, false);
        byte[] computedSig = this.getHmacSHA256(signatureKey, canonicalString);
        byte[] providedSig = Hex.decode((String)sig);
        if (!MessageDigest.isEqual(computedSig, providedSig) && !MessageDigest.isEqual(computedSigNoPath = this.getHmacSHA256(signatureKey, canonicalStringNoPath = this.makeSubjectString(credentials, signatureCredential, authorizationParameters, date, true)), providedSig)) {
            throw new InvalidSignatureAuthException("Signature validation failed");
        }
        super.setCredential(credentials.getQueryIdCredential(AccessKeys.getKeyType(accessKey)));
        super.setPrincipal(user);
        return true;
    }

    private String makeSubjectString(@Nonnull HmacCredentials credentials, @Nonnull HmacUtils.SignatureCredential signatureCredential, @Nonnull Map<String, String> authorizationParameters, @Nonnull Date date, boolean skipPath) throws Exception {
        String timestamp = Timestamps.formatShortIso8601Timestamp(date);
        StringBuilder sb = new StringBuilder();
        sb.append(SecurityHeader.Value.AWS4_HMAC_SHA256.value()).append("\n");
        sb.append(timestamp).append("\n");
        sb.append(signatureCredential.getCredentialScope()).append("\n");
        sb.append(this.digestUTF8(this.makeCanonicalRequest(credentials, authorizationParameters, skipPath)));
        String subject = sb.toString();
        signatureLogger.trace((Object)("VERSION4: " + subject));
        return subject;
    }

    private String makeCanonicalRequest(@Nonnull HmacCredentials credentials, @Nonnull Map<String, String> authorizationParameters, boolean skipPath) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(credentials.getVerb());
        sb.append("\n");
        sb.append(skipPath ? "/" : this.canonicalizePath(credentials.getServicePath()));
        sb.append("\n");
        boolean addedParam = false;
        for (String parameter : Ordering.natural().sortedCopy(credentials.getParameters().keySet())) {
            if (credentials.getVariant() == HmacUtils.SignatureVariant.SignatureV4Query && SecurityParameter.X_Amz_Signature.parameter().equals(parameter)) continue;
            for (String value : Ordering.natural().sortedCopy((Iterable)credentials.getParameters().get(parameter))) {
                sb.append(this.urlencode(parameter));
                sb.append("=");
                sb.append(this.urlencode(value));
                sb.append("&");
                addedParam = true;
            }
        }
        if (addedParam) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("\n");
        for (String header : authorizationParameters.get("SignedHeaders").split(";")) {
            List values = Lists.transform(credentials.getHeaders().get(header), (Function)new Function<String, String>(){

                public String apply(String text) {
                    return text.trim();
                }
            });
            sb.append(header);
            sb.append(":");
            sb.append(Joiner.on((String)",").join((Iterable)Ordering.natural().sortedCopy((Iterable)values)));
            sb.append("\n");
        }
        sb.append("\n");
        sb.append(authorizationParameters.get("SignedHeaders"));
        sb.append("\n");
        sb.append(this.digestUTF8(credentials.getBody()));
        String request = sb.toString();
        signatureLogger.trace((Object)("VERSION4: " + request));
        return request;
    }

    private String digestUTF8(String text) {
        return Strings.padStart((String)new BigInteger(1, Digest.SHA256.get().digest(text.getBytes(Charsets.UTF_8))).toString(16), (int)64, (char)'0');
    }

    private String canonicalizePath(String servicePath) throws URISyntaxException {
        return servicePath.isEmpty() ? "/" : new URI("http", "0.0.0.0", servicePath, null).normalize().getPath();
    }

    private byte[] getHmacSHA256(byte[] signatureKey, String data) throws AuthenticationException {
        SecretKeySpec signingKey = new SecretKeySpec(signatureKey, Hmac.HmacSHA256.toString());
        try {
            Mac digest = Hmac.HmacSHA256.getInstance();
            digest.init(signingKey);
            return digest.doFinal(data.getBytes(Charsets.UTF_8));
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new AuthenticationException("Failed to compute signature");
        }
    }

    private byte[] getSignatureKey(String key, HmacUtils.SignatureCredential credential) throws Exception {
        return this.getHmacSHA256(this.getHmacSHA256(this.getHmacSHA256(this.getHmacSHA256(("AWS4" + key).getBytes(Charsets.UTF_8), credential.getDate()), credential.getRegion()), credential.getServiceName()), credential.getTerminator());
    }
}

