/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.login;

import com.eucalyptus.auth.AccessKeys;
import com.eucalyptus.auth.InvalidSignatureAuthException;
import com.eucalyptus.auth.login.AuthenticationException;
import com.eucalyptus.auth.login.HmacCredentials;
import com.eucalyptus.auth.login.HmacLoginModuleSupport;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.crypto.Hmac;
import com.eucalyptus.crypto.util.SecurityParameter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.apache.xml.security.utils.Base64;

public class Hmacv2LoginModule
extends HmacLoginModuleSupport {
    private static Logger LOG = Logger.getLogger(Hmacv2LoginModule.class);

    public Hmacv2LoginModule() {
        super(2);
    }

    @Override
    public boolean authenticate(HmacCredentials credentials) throws Exception {
        String sig = credentials.getSignature();
        this.checkForReplay(sig);
        AccessKey accessKey = this.lookupAccessKey(credentials);
        User user = accessKey.getUser();
        String secretKey = accessKey.getSecretKey();
        String canonicalString = this.makeSubjectString(credentials.getVerb(), credentials.getHeaderHost(), credentials.getServicePath(), credentials.getParameters());
        String canonicalStringWithPort = this.makeSubjectString(credentials.getVerb(), credentials.getHeaderHost() + ":" + credentials.getHeaderPort(), credentials.getServicePath(), credentials.getParameters());
        String canonicalStringWithAwsCliPath = this.makeSubjectString(credentials.getVerb(), credentials.getHeaderHost() + ":" + credentials.getHeaderPort(), this.convertForAwsCli(credentials.getServicePath()), credentials.getParameters());
        String computedSig = this.getSignature(secretKey, canonicalString, credentials.getSignatureMethod());
        String computedSigWithPort = this.getSignature(secretKey, canonicalStringWithPort, credentials.getSignatureMethod());
        String computedSigWithAwsCliPath = this.getSignature(secretKey, canonicalStringWithAwsCliPath, credentials.getSignatureMethod());
        if (!(computedSig.equals(sig) || computedSigWithPort.equals(sig) || computedSigWithAwsCliPath.equals(sig))) {
            sig = this.sanitize(this.urldecode(sig));
            computedSig = this.getSignature(secretKey, canonicalString.replaceAll("\\+", "%2B"), credentials.getSignatureMethod()).replaceAll("\\+", " ");
            computedSigWithPort = this.getSignature(secretKey, canonicalStringWithPort.replaceAll("\\+", "%2B"), credentials.getSignatureMethod()).replaceAll("\\+", " ");
            computedSigWithAwsCliPath = this.getSignature(secretKey, canonicalStringWithAwsCliPath.replaceAll("\\+", "%2B"), credentials.getSignatureMethod()).replaceAll("\\+", " ");
            if (!(computedSig.equals(sig) || computedSigWithPort.equals(sig) || computedSigWithAwsCliPath.equals(sig))) {
                computedSig = this.getSignature(secretKey, canonicalString.replaceAll("\\+", "%20"), credentials.getSignatureMethod()).replaceAll("\\+", " ");
                computedSigWithPort = this.getSignature(secretKey, canonicalStringWithPort.replaceAll("\\+", "%20"), credentials.getSignatureMethod()).replaceAll("\\+", " ");
                computedSigWithAwsCliPath = this.getSignature(secretKey, canonicalStringWithAwsCliPath.replaceAll("\\+", "%20"), credentials.getSignatureMethod()).replaceAll("\\+", " ");
                if (!(computedSig.equals(sig) || computedSigWithPort.equals(sig) || computedSigWithAwsCliPath.equals(sig))) {
                    computedSig = this.getSignature(secretKey, canonicalString.replaceAll("\\*", "%2A"), credentials.getSignatureMethod()).replaceAll("\\+", " ");
                    computedSigWithPort = this.getSignature(secretKey, canonicalStringWithPort.replaceAll("\\*", "%2A"), credentials.getSignatureMethod()).replaceAll("\\+", " ");
                    computedSigWithAwsCliPath = this.getSignature(secretKey, canonicalStringWithAwsCliPath.replaceAll("\\*", "%2A"), credentials.getSignatureMethod()).replaceAll("\\+", " ");
                    if (!(computedSig.equals(sig) || computedSigWithPort.equals(sig) || computedSigWithAwsCliPath.equals(sig))) {
                        throw new InvalidSignatureAuthException("Signature validation failed");
                    }
                }
            }
        }
        super.setCredential(credentials.getQueryIdCredential(AccessKeys.getKeyType(accessKey)));
        super.setPrincipal(user);
        return true;
    }

    private String makeSubjectString(String httpMethod, String host, String path, Map<String, List<String>> parameters) throws UnsupportedEncodingException {
        parameters.remove("");
        StringBuilder sb = new StringBuilder();
        sb.append(httpMethod);
        sb.append("\n");
        sb.append(host);
        sb.append("\n");
        sb.append(path);
        sb.append("\n");
        String prefix = sb.toString();
        sb = new StringBuilder();
        boolean addedParam = false;
        for (String paramName : Ordering.natural().sortedCopy(parameters.keySet())) {
            if (SecurityParameter.Signature.parameter().equals(paramName)) continue;
            ArrayList paramValues = parameters.get(paramName);
            if (paramValues.isEmpty()) {
                paramValues = Lists.newArrayList((Object[])new String[]{""});
            }
            for (String value : Ordering.natural().sortedCopy(paramValues)) {
                sb.append(this.urlencode(paramName)).append("=").append(this.urlencode(value)).append("&");
                addedParam = true;
            }
        }
        if (addedParam) {
            sb.setLength(sb.length() - 1);
        }
        String subject = prefix + sb.toString();
        signatureLogger.trace((Object)("VERSION2: " + subject));
        return subject;
    }

    public String getSignature(String queryKey, String subject, Hmac mac) throws AuthenticationException {
        SecretKeySpec signingKey = new SecretKeySpec(queryKey.getBytes(), mac.toString());
        try {
            Mac digest = mac.getInstance();
            digest.init(signingKey);
            byte[] rawHmac = digest.doFinal(subject.getBytes());
            return this.sanitize(Base64.encode((byte[])rawHmac));
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new AuthenticationException("Failed to compute signature");
        }
    }

    private String convertForAwsCli(String path) {
        String converted = Strings.nullToEmpty((String)path);
        if (converted.endsWith("/")) {
            converted = converted.substring(0, converted.length() - 1);
        }
        return converted.toLowerCase();
    }
}

