/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.login;

import com.eucalyptus.auth.AccessKeys;
import com.eucalyptus.auth.login.AuthenticationException;
import com.eucalyptus.auth.login.HmacCredentials;
import com.eucalyptus.auth.login.HmacLoginModuleSupport;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.crypto.Hmac;
import com.eucalyptus.crypto.util.SecurityParameter;
import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.log4j.Logger;
import org.apache.xml.security.utils.Base64;

public class Hmacv1LoginModule
extends HmacLoginModuleSupport {
    private static Logger LOG = Logger.getLogger(Hmacv1LoginModule.class);

    public Hmacv1LoginModule() {
        super(1);
    }

    @Override
    public boolean authenticate(HmacCredentials credentials) throws Exception {
        String sig = credentials.getSignature();
        this.checkForReplay(sig);
        AccessKey accessKey = this.lookupAccessKey(credentials);
        User user = accessKey.getUser();
        String secretKey = accessKey.getSecretKey();
        String canonicalString = this.makeSubjectString(credentials.getParameters());
        String computedSig = this.getSignature(secretKey, canonicalString, credentials.getSignatureMethod());
        String decodedSig = this.sanitize(this.urldecode(sig));
        if (!(computedSig.equals(this.sanitize(sig)) || computedSig.equals(decodedSig) || computedSig.equals(sig))) {
            return false;
        }
        super.setCredential(credentials.getQueryIdCredential(AccessKeys.getKeyType(accessKey)));
        super.setPrincipal(user);
        return true;
    }

    private String makeSubjectString(Map<String, List<String>> parameters) throws UnsupportedEncodingException {
        String paramString = "";
        TreeSet<String> sortedKeys = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        sortedKeys.addAll(parameters.keySet());
        sortedKeys.remove(SecurityParameter.Signature.parameter());
        for (String key : sortedKeys) {
            if (parameters.get(key).isEmpty()) {
                paramString = paramString.concat(key).replaceAll("\\+", " ");
                continue;
            }
            for (String value : Ordering.natural().sortedCopy((Iterable)parameters.get(key))) {
                paramString = paramString.concat(key).concat(Strings.nullToEmpty((String)value).replaceAll("\\+", " "));
            }
        }
        try {
            return new String(URLCodec.decodeUrl((byte[])paramString.getBytes()));
        }
        catch (DecoderException e) {
            return paramString;
        }
    }

    public String getSignature(String queryKey, String subject, Hmac mac) throws AuthenticationException {
        SecretKeySpec signingKey = new SecretKeySpec(queryKey.getBytes(), mac.toString());
        try {
            Mac digest = mac.getInstance();
            digest.init(signingKey);
            byte[] rawHmac = digest.doFinal(subject.getBytes());
            return this.sanitize(Base64.encode((byte[])rawHmac));
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new AuthenticationException("Failed to compute signature");
        }
    }
}

