/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.login;

import com.eucalyptus.auth.AccessKeys;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.InvalidAccessKeyAuthException;
import com.eucalyptus.auth.api.BaseLoginModule;
import com.eucalyptus.auth.login.AuthenticationException;
import com.eucalyptus.auth.login.HmacCredentials;
import com.eucalyptus.auth.login.SecurityContext;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.crypto.util.B64;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import java.net.URLDecoder;
import java.util.BitSet;
import org.apache.commons.codec.net.URLCodec;
import org.apache.log4j.Logger;

abstract class HmacLoginModuleSupport
extends BaseLoginModule<HmacCredentials> {
    protected static final Logger signatureLogger;
    private final int signatureVersion;
    protected static final BitSet URL_SAFE_CHARACTERS;

    protected HmacLoginModuleSupport(int signatureVersion) {
        this.signatureVersion = signatureVersion;
    }

    @Override
    public boolean accepts() {
        return super.getCallbackHandler() instanceof HmacCredentials && ((HmacCredentials)super.getCallbackHandler()).getSignatureVersion().equals(this.signatureVersion);
    }

    @Override
    public void reset() {
    }

    protected AccessKey lookupAccessKey(HmacCredentials credentials) throws AuthException {
        AccessKey key = AccessKeys.lookupAccessKey(credentials.getQueryId(), credentials.getSecurityToken());
        if (!key.isActive().booleanValue()) {
            throw new InvalidAccessKeyAuthException("Invalid access key or token");
        }
        return key;
    }

    protected void checkForReplay(String signature) throws AuthenticationException {
        SecurityContext.enqueueSignature(this.normalize(signature));
    }

    protected String urldecode(String text) {
        return URLDecoder.decode(text);
    }

    protected String urlencode(String text) {
        byte[] textBytes = Strings.nullToEmpty((String)text).getBytes(Charsets.UTF_8);
        return new String(URLCodec.encodeUrl((BitSet)URL_SAFE_CHARACTERS, (byte[])textBytes), Charsets.US_ASCII);
    }

    protected String sanitize(String b64text) {
        return b64text.replace("=", "");
    }

    protected String normalize(String signature) {
        String urldecoded = this.urldecode(signature);
        String decoded = urldecoded.replace(' ', '+');
        String sanitized = this.sanitize(decoded);
        int lastBlockLength = sanitized.length() % 4;
        String normalized = lastBlockLength > 0 ? sanitized + Strings.repeat((String)"=", (int)(4 - lastBlockLength)) : sanitized;
        return B64.standard.encString(B64.standard.dec(normalized));
    }

    static {
        int i;
        signatureLogger = Logger.getLogger((String)"com.eucalyptus.auth.login.HMAC");
        URL_SAFE_CHARACTERS = new BitSet(256);
        for (i = 65; i <= 90; ++i) {
            URL_SAFE_CHARACTERS.set(i);
        }
        for (i = 97; i <= 122; ++i) {
            URL_SAFE_CHARACTERS.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            URL_SAFE_CHARACTERS.set(i);
        }
        URL_SAFE_CHARACTERS.set(45);
        URL_SAFE_CHARACTERS.set(95);
        URL_SAFE_CHARACTERS.set(46);
        URL_SAFE_CHARACTERS.set(126);
    }
}

