/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.login;

import com.eucalyptus.auth.login.AuthenticationException;
import com.eucalyptus.auth.login.WrappedCredentials;
import com.eucalyptus.auth.principal.TemporaryAccessKey;
import com.eucalyptus.crypto.Hmac;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.ws.util.HmacUtils;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.text.IsEmptyString;

public class HmacCredentials
extends WrappedCredentials<String> {
    private final HmacUtils.SignatureVariant variant;
    private final String verb;
    private final String servicePath;
    private final Map<String, List<String>> parameters;
    private final Map<String, List<String>> headers;
    private final String body;
    private String headerHost;
    private String headerPort;
    private final String queryId;
    private final String securityToken;
    private Hmac signatureMethod;

    public HmacCredentials(String correlationId, HmacUtils.SignatureVariant variant, Map<String, List<String>> parameters, Map<String, List<String>> headers, String verb, String servicePath, String body) throws AuthenticationException {
        super(correlationId, variant.getSignature(HmacUtils.headerLookup(headers), HmacUtils.parameterLookup(parameters)));
        Function<String, List<String>> headerLookup = HmacUtils.headerLookup(headers);
        Function<String, List<String>> parameterLookup = HmacUtils.parameterLookup(parameters);
        this.variant = variant;
        this.parameters = parameters;
        this.headers = headers;
        this.verb = verb;
        this.servicePath = servicePath;
        this.body = body;
        this.headerHost = (String)Iterables.getFirst((Iterable)((Iterable)Objects.firstNonNull(headers.get("host"), Collections.emptyList())), null);
        this.headerPort = "8773";
        if (this.headerHost != null && this.headerHost.contains(":")) {
            String[] hostTokens = this.headerHost.split(":");
            this.headerHost = hostTokens[0];
            if (hostTokens.length > 1 && hostTokens[1] != null && !"".equals(hostTokens[1])) {
                this.headerPort = hostTokens[1];
            }
        }
        this.queryId = variant.getAccessKeyId(headerLookup, parameterLookup);
        this.securityToken = variant.getSecurityToken(headerLookup, parameterLookup);
        this.signatureMethod = variant.getSignatureMethod(headerLookup, parameterLookup);
    }

    public HmacUtils.SignatureVariant getVariant() {
        return this.variant;
    }

    public Integer getSignatureVersion() {
        return this.variant.getVersion().value();
    }

    public String getQueryId() {
        return this.queryId;
    }

    public QueryIdCredential getQueryIdCredential(@Nonnull Optional<TemporaryAccessKey.TemporaryKeyType> type) {
        return new QueryIdCredential(this.getQueryId(), type);
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public String getSignature() {
        return (String)this.getLoginData();
    }

    public String getVerb() {
        return this.verb;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public String getHeaderHost() {
        return this.headerHost;
    }

    public String getHeaderPort() {
        return this.headerPort;
    }

    public Hmac getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(Hmac hmac) {
        this.signatureMethod = hmac;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public static final class QueryIdCredential {
        private final String queryId;
        private final Optional<TemporaryAccessKey.TemporaryKeyType> type;

        private QueryIdCredential(@Nonnull String queryId, @Nonnull Optional<TemporaryAccessKey.TemporaryKeyType> type) {
            this.queryId = Parameters.checkParam("queryId", queryId, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
            this.type = Parameters.checkParam("type", type, Matchers.notNullValue());
        }

        @Nonnull
        public String getQueryId() {
            return this.queryId;
        }

        @Nonnull
        public Optional<TemporaryAccessKey.TemporaryKeyType> getType() {
            return this.type;
        }

        public String toString() {
            return this.getQueryId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryIdCredential that = (QueryIdCredential)o;
            return this.queryId.equals(that.queryId);
        }

        public int hashCode() {
            return this.queryId.hashCode();
        }
    }
}

