/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.api;

import com.eucalyptus.auth.login.WrappedCredentials;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.NoSuchContextException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.log4j.Logger;

public abstract class BaseLoginModule<CB extends WrappedCredentials>
implements LoginModule {
    private static Logger LOG = Logger.getLogger(BaseLoginModule.class);
    private boolean authenticated = false;
    private CallbackHandler callbackHandler;
    private Object credential;
    private User principal;
    private Subject subject;
    private CB wrappedCredentials;

    @Override
    public boolean abort() throws LoginException {
        this.reset();
        return true;
    }

    @Override
    public final boolean commit() throws LoginException {
        if (!this.isAuthenticated()) {
            return false;
        }
        this.getSubject().getPrincipals().add(this.getPrincipal());
        this.getSubject().getPublicCredentials().add(this.getCredential());
        try {
            Contexts.lookup(((WrappedCredentials)this.getWrappedCredentials()).getCorrelationId()).setUser(this.getPrincipal());
            Contexts.lookup(((WrappedCredentials)this.getWrappedCredentials()).getCorrelationId()).setSubject(this.getSubject());
        }
        catch (NoSuchContextException e) {
            LOG.debug((Object)e, (Throwable)e);
            this.authenticated = false;
        }
        return this.authenticated;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public Object getCredential() {
        return this.credential;
    }

    public User getPrincipal() {
        return this.principal;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public CB getWrappedCredentials() {
        return this.wrappedCredentials;
    }

    public abstract boolean accepts();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.wrappedCredentials = this.accepts() ? (WrappedCredentials)callbackHandler : null;
    }

    private boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.wrappedCredentials == null) {
            return false;
        }
        try {
            this.setAuthenticated(this.authenticate(this.wrappedCredentials));
        }
        catch (Exception e) {
            LOG.trace((Object)e, (Throwable)e);
            this.setAuthenticated(false);
            throw e instanceof LoginException ? (LoginException)e : (LoginException)new LoginException(e.getMessage()).initCause(e);
        }
        return this.isAuthenticated();
    }

    public abstract boolean authenticate(CB var1) throws Exception;

    @Override
    public boolean logout() throws LoginException {
        this.baseReset();
        this.reset();
        return true;
    }

    public void reset() {
    }

    private void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public void setCredential(Object credential) {
        this.credential = credential;
    }

    public void setPrincipal(User principal) {
        this.principal = principal;
    }

    public void setWrappedCredentials(CB wrappedCredentials) {
        this.wrappedCredentials = wrappedCredentials;
    }

    private void baseReset() {
        if (this.principal != null) {
            this.subject.getPrincipals().remove(this.principal);
            this.principal = null;
        }
        if (this.getCredential() != null) {
            this.getSubject().getPublicCredentials().remove(this.getCredential());
            this.credential = null;
        }
        this.wrappedCredentials = null;
        this.authenticated = false;
        this.callbackHandler = null;
    }
}

