/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.principal.Account;
import java.util.Date;
import org.apache.log4j.Logger;

public class ServerCertificate {
    private static Logger LOG = Logger.getLogger(ServerCertificate.class);
    private Account owningAccount = null;
    private String certName = null;
    private String certId = null;
    private String certPath = null;
    private String certBody = null;
    private String certChain = null;
    private String privateKey = null;
    private Date createdTime = null;

    public ServerCertificate(Account owningAcct, String certName, Date createdTime) {
        this.owningAccount = owningAcct;
        this.certName = certName;
        this.createdTime = createdTime;
    }

    public void setCertificateName(String name) {
        this.certName = name;
    }

    public String getCertificateName() {
        return this.certName;
    }

    public void setCertificatePath(String path) {
        this.certPath = path;
    }

    public String getCertificatePath() {
        return this.certPath;
    }

    public void setCertificateBody(String body) {
        this.certBody = body;
    }

    public String getCertificateBody() {
        return this.certBody;
    }

    public void setCertificateChain(String chain) {
        this.certChain = chain;
    }

    public String getCertificateChain() {
        return this.certChain;
    }

    public void setCertificateId(String id) {
        this.certId = id;
    }

    public String getCertificateId() {
        return this.certId;
    }

    public void setPrivateKey(String pk) {
        this.privateKey = pk;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getArn() {
        String path = this.certPath;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return String.format("arn:aws:iam::%s:server-certificate%s%s", this.owningAccount.getAccountNumber(), path, this.certName);
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }
}

