/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthContext;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.AuthenticationLimitProvider;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.auth.PolicyParseException;
import com.eucalyptus.auth.ServerCertificate;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Certificate;
import com.eucalyptus.auth.principal.Group;
import com.eucalyptus.auth.principal.InstanceProfile;
import com.eucalyptus.auth.principal.Policy;
import com.eucalyptus.auth.principal.Role;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.util.X509CertHelper;
import com.eucalyptus.crypto.Certs;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.RestrictedTypes;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Privileged {
    public static Account createAccount(AuthContext requestUser, String accountName, String password, String email) throws AuthException {
        if (!requestUser.isSystemUser() || !Permissions.isAuthorized("iam", "account", "", null, "createaccount", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        Account newAccount = Accounts.addAccount(accountName);
        HashMap info = null;
        if (email != null) {
            info = Maps.newHashMap();
            info.put("email", email);
        }
        User admin = newAccount.addUser("admin", "/", true, info);
        admin.resetToken();
        admin.createConfirmationCode();
        if (password != null) {
            admin.setPassword(Crypto.generateEncryptedPassword(password));
            admin.setPasswordExpires(System.currentTimeMillis() + AuthenticationLimitProvider.Values.getDefaultPasswordExpiry());
        }
        return newAccount;
    }

    public static void deleteAccount(AuthContext requestUser, Account account, boolean recursive) throws AuthException {
        if (!requestUser.isSystemUser() || !RestrictedTypes.filterPrivileged().apply((Object)account)) {
            throw new AuthException("Access to the resource is denied");
        }
        Accounts.deleteAccount(account.getName(), false, recursive);
    }

    public static boolean allowListOrReadAccountPolicy(AuthContext requestUser, Account account) throws AuthException {
        return requestUser.isSystemUser() && RestrictedTypes.filterPrivileged().apply((Object)account) && Permissions.isAuthorized(requestUser.evaluationContext("iam", "account", "listaccountpolicies"), account.getAccountNumber(), Accounts.getAccountFullName(account)) && Permissions.isAuthorized(requestUser.evaluationContext("iam", "account", "getaccountpolicy"), account.getAccountNumber(), Accounts.getAccountFullName(account));
    }

    public static void modifyAccount(AuthContext requestUser, Account account, String newName) throws AuthException {
        if (Accounts.isSystemAccount(account.getName())) {
            throw new AuthException("Access to the resource is denied");
        }
        try {
            Accounts.lookupAccountByName(newName);
            throw new AuthException("Conflict");
        }
        catch (AuthException ae) {
            if (!Permissions.isAuthorized("iam", "account", Accounts.getAccountFullName(account), account, "createaccountalias", requestUser)) {
                throw new AuthException("Access to the resource is denied");
            }
            account.setName(newName);
            return;
        }
    }

    public static void deleteAccountAlias(AuthContext requestUser, Account account, String alias) throws AuthException {
        if (Accounts.isSystemAccount(account)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (!Permissions.isAuthorized("iam", "account", Accounts.getAccountFullName(account), account, "deleteaccountalias", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (Strings.isNullOrEmpty((String)alias)) {
            throw new AuthException("Empty account name");
        }
        if (account.getName().equals(alias)) {
            account.setName(account.getAccountNumber());
        }
    }

    public static List<String> listAccountAliases(AuthContext requestUser, Account account) throws AuthException {
        if (!Permissions.isAuthorized("iam", "account", Accounts.getAccountFullName(account), account, "listaccountaliases", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        ArrayList aliases = Lists.newArrayList();
        aliases.add(account.getName());
        return aliases;
    }

    public static Account getAccountSummary(AuthContext requestUser, Account account) throws AuthException {
        if (!Permissions.isAuthorized("iam", "account", Accounts.getAccountFullName(account), account, "getaccountsummary", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        return account;
    }

    public static Group createGroup(AuthContext requestUser, Account account, String groupName, String path) throws AuthException {
        if (!Permissions.isAuthorized("iam", "group", "", account, "creategroup", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (!Permissions.canAllocate("iam", "group", "", "creategroup", requestUser, (Long)1L)) {
            throw new AuthException("Resource quota is exceeded");
        }
        return account.addGroup(groupName, path);
    }

    public static boolean allowListGroup(AuthContext requestUser, Account account, Group group) throws AuthException {
        return Permissions.isAuthorized(requestUser.evaluationContext("iam", "group", "listgroups"), account.getAccountNumber(), Accounts.getGroupFullName(group));
    }

    public static boolean allowReadGroup(AuthContext requestUser, Account account, Group group) throws AuthException {
        return Permissions.isAuthorized("iam", "group", Accounts.getGroupFullName(group), account, "getgroup", requestUser);
    }

    public static void deleteGroup(AuthContext requestUser, Account account, Group group, boolean recursive) throws AuthException {
        if (!Permissions.isAuthorized("iam", "group", Accounts.getGroupFullName(group), account, "deletegroup", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        account.deleteGroup(group.getName(), recursive);
    }

    public static void modifyGroup(AuthContext requestUser, Account account, Group group, String newName, String newPath) throws AuthException {
        if (!Permissions.isAuthorized("iam", "group", Accounts.getGroupFullName(group), account, "updategroup", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (!Strings.isNullOrEmpty((String)newName)) {
            group.setName(newName);
        }
        if (!Strings.isNullOrEmpty((String)newPath)) {
            group.setPath(newPath);
        }
    }

    public static User createUser(AuthContext requestUser, Account account, String userName, String path) throws AuthException {
        if (!Permissions.isAuthorized("iam", "user", "", account, "createuser", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (!Permissions.canAllocate("iam", "user", "", "createuser", requestUser, (Long)1L)) {
            throw new AuthException("Resource quota is exceeded");
        }
        return account.addUser(userName, path, true, null);
    }

    public static boolean allowReadUser(AuthContext requestUser, Account account, User user) throws AuthException {
        return Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "getuser", requestUser);
    }

    public static boolean allowListUser(AuthContext requestUser, Account account, User user) throws AuthException {
        return Permissions.isAuthorized(requestUser.evaluationContext("iam", "user", "listusers"), account.getAccountNumber(), Accounts.getUserFullName(user));
    }

    public static void deleteUser(AuthContext requestUser, Account account, User user, boolean recursive) throws AuthException {
        if (!Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "deleteuser", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (user.isAccountAdmin()) {
            throw new AuthException("Access to the resource is denied");
        }
        account.deleteUser(user.getName(), false, recursive);
    }

    public static void modifyUser(AuthContext requestUser, Account account, User user, String newName, String newPath, Boolean enabled, Long passwordExpires, Map<String, String> info) throws AuthException {
        if (!Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "updateuser", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (!Strings.isNullOrEmpty((String)newName)) {
            if (user.isAccountAdmin()) {
                throw new AuthException("Access to the resource is denied");
            }
            user.setName(newName);
        }
        if (!Strings.isNullOrEmpty((String)newPath)) {
            if (user.isAccountAdmin()) {
                throw new AuthException("Access to the resource is denied");
            }
            user.setPath(newPath);
        }
        if (enabled != null) {
            if (user.isSystemAdmin() && user.isAccountAdmin()) {
                throw new AuthException("Access to the resource is denied");
            }
            if (user.isAccountAdmin() && !requestUser.isSystemUser()) {
                throw new AuthException("Access to the resource is denied");
            }
            user.setEnabled(enabled);
        }
        if (passwordExpires != null && passwordExpires > new Date().getTime()) {
            user.setPasswordExpires(passwordExpires);
        }
        if (info != null) {
            user.setInfo(info);
        }
    }

    public static void updateUserInfoItem(AuthContext requestUser, Account account, User user, String key, String value) throws AuthException {
        if (!Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "updateuser", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (value != null) {
            user.setInfo(key, value);
        } else {
            user.removeInfo(key);
        }
    }

    public static void addUserToGroup(AuthContext requestUser, Account account, User user, Group group) throws AuthException {
        if (!Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "addusertogroup", requestUser) || !Permissions.isAuthorized("iam", "group", Accounts.getGroupFullName(group), account, "addusertogroup", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (group.hasUser(user.getName())) {
            throw new AuthException("Conflict");
        }
        group.addUserByName(user.getName());
    }

    public static void removeUserFromGroup(AuthContext requestUser, Account account, User user, Group group) throws AuthException {
        if (!Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "removeuserfromgroup", requestUser) || !Permissions.isAuthorized("iam", "group", Accounts.getGroupFullName(group), account, "removeuserfromgroup", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (!group.hasUser(user.getName())) {
            throw new AuthException("No such user");
        }
        group.removeUserByName(user.getName());
    }

    public static List<Group> listGroupsForUser(AuthContext requestUser, Account account, User user) throws AuthException {
        if (!Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "listgroupsforuser", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        ArrayList groups = Lists.newArrayList();
        for (Group g : user.getGroups()) {
            if (g.isUserGroup().booleanValue()) continue;
            groups.add(g);
        }
        return groups;
    }

    public static Role createRole(AuthContext requestUser, Account account, String roleName, String path, String assumeRolePolicy) throws AuthException, PolicyParseException {
        if (!Permissions.isAuthorized("iam", "role", "", account, "createrole", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (!Permissions.canAllocate("iam", "role", "", "createrole", requestUser, (Long)1L)) {
            throw new AuthException("Resource quota is exceeded");
        }
        return account.addRole(roleName, path, assumeRolePolicy);
    }

    public static boolean allowListRole(AuthContext requestUser, Account account, Role role) throws AuthException {
        return Permissions.isAuthorized(requestUser.evaluationContext("iam", "role", "listroles"), account.getAccountNumber(), Accounts.getRoleFullName(role));
    }

    public static boolean allowReadRole(AuthContext requestUser, Account account, Role role) throws AuthException {
        return Permissions.isAuthorized("iam", "role", Accounts.getRoleFullName(role), account, "getrole", requestUser);
    }

    public static void deleteRole(AuthContext requestUser, Account account, Role role) throws AuthException {
        if (!Permissions.isAuthorized("iam", "role", Accounts.getRoleFullName(role), account, "deleterole", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        account.deleteRole(role.getName());
    }

    public static void updateAssumeRolePolicy(AuthContext requestUser, Account account, Role role, String assumeRolePolicy) throws AuthException, PolicyParseException {
        if (!Permissions.isAuthorized("iam", "role", Accounts.getRoleFullName(role), account, "updateassumerolepolicy", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        role.setAssumeRolePolicy(assumeRolePolicy);
    }

    public static InstanceProfile createInstanceProfile(AuthContext requestUser, Account account, String instanceProfileName, String path) throws AuthException {
        if (!Permissions.isAuthorized("iam", "instance-profile", "", account, "createinstanceprofile", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (!Permissions.canAllocate("iam", "instance-profile", "", "createinstanceprofile", requestUser, (Long)1L)) {
            throw new AuthException("Resource quota is exceeded");
        }
        return account.addInstanceProfile(instanceProfileName, path);
    }

    public static boolean allowListInstanceProfile(AuthContext requestUser, Account account, InstanceProfile instanceProfile) throws AuthException {
        return Permissions.isAuthorized(requestUser.evaluationContext("iam", "instance-profile", "listinstanceprofiles"), account.getAccountNumber(), Accounts.getInstanceProfileFullName(instanceProfile));
    }

    public static boolean allowReadInstanceProfile(AuthContext requestUser, Account account, InstanceProfile instanceProfile) throws AuthException {
        return Permissions.isAuthorized("iam", "instance-profile", Accounts.getInstanceProfileFullName(instanceProfile), account, "getinstanceprofile", requestUser);
    }

    public static void deleteInstanceProfile(AuthContext requestUser, Account account, InstanceProfile instanceProfile) throws AuthException {
        if (!Permissions.isAuthorized("iam", "instance-profile", Accounts.getInstanceProfileFullName(instanceProfile), account, "deleteinstanceprofile", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        account.deleteInstanceProfile(instanceProfile.getName());
    }

    public static void addRoleToInstanceProfile(AuthContext requestUser, Account account, InstanceProfile instanceProfile, Role role) throws AuthException {
        if (!Permissions.isAuthorized("iam", "instance-profile", Accounts.getInstanceProfileFullName(instanceProfile), account, "addroletoinstanceprofile", requestUser) || !Permissions.isAuthorized("iam", "role", Accounts.getRoleFullName(role), account, "addroletoinstanceprofile", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        Role currentRole = instanceProfile.getRole();
        if (currentRole != null && currentRole.getName().equals(role.getName())) {
            throw new AuthException("Conflict");
        }
        instanceProfile.setRole(role);
    }

    public static void removeRoleFromInstanceProfile(AuthContext requestUser, Account account, InstanceProfile instanceProfile, Role role) throws AuthException {
        if (!Permissions.isAuthorized("iam", "instance-profile", Accounts.getInstanceProfileFullName(instanceProfile), account, "removerolefrominstanceprofile", requestUser) || !Permissions.isAuthorized("iam", "role", Accounts.getRoleFullName(role), account, "removerolefrominstanceprofile", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        instanceProfile.setRole(null);
    }

    public static List<InstanceProfile> listInstanceProfilesForRole(AuthContext requestUser, Account account, Role role) throws AuthException {
        if (!Permissions.isAuthorized("iam", "role", Accounts.getRoleFullName(role), account, "listinstanceprofilesforrole", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        return role.getInstanceProfiles();
    }

    public static boolean allowListInstanceProfileForRole(AuthContext requestUser, Account account, InstanceProfile instanceProfile) throws AuthException {
        return Permissions.isAuthorized(requestUser.evaluationContext("iam", "instance-profile", "listinstanceprofilesforrole"), account.getAccountNumber(), Accounts.getInstanceProfileFullName(instanceProfile));
    }

    public static void putAccountPolicy(AuthContext requestUser, Account account, String name, String policy) throws AuthException, PolicyParseException {
        if (!requestUser.isSystemUser() || !RestrictedTypes.filterPrivileged().apply((Object)account)) {
            throw new AuthException("Access to the resource is denied");
        }
        if ("eucalyptus".equals(account.getName())) {
            throw new AuthException("Access to the resource is denied");
        }
        User admin = account.lookupAdmin();
        admin.putPolicy(name, policy);
    }

    public static void putGroupPolicy(AuthContext requestUser, Account account, Group group, String name, String policy) throws AuthException, PolicyParseException {
        if (!Permissions.isAuthorized("iam", "group", Accounts.getGroupFullName(group), account, "putgrouppolicy", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        group.putPolicy(name, policy);
    }

    public static void putUserPolicy(AuthContext requestUser, Account account, User user, String name, String policy) throws AuthException, PolicyParseException {
        if (user.isAccountAdmin() || !Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "putuserpolicy", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        user.putPolicy(name, policy);
    }

    public static void putRolePolicy(AuthContext requestUser, Account account, Role role, String name, String policy) throws AuthException, PolicyParseException {
        if (!Permissions.isAuthorized("iam", "role", Accounts.getRoleFullName(role), account, "putrolepolicy", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        role.putPolicy(name, policy);
    }

    public static void deleteAccountPolicy(AuthContext requestUser, Account account, String name) throws AuthException {
        if (!requestUser.isSystemUser() || !RestrictedTypes.filterPrivileged().apply((Object)account)) {
            throw new AuthException("Access to the resource is denied");
        }
        User admin = account.lookupAdmin();
        admin.removePolicy(name);
    }

    public static void deleteGroupPolicy(AuthContext requestUser, Account account, Group group, String name) throws AuthException {
        if (!Permissions.isAuthorized("iam", "group", Accounts.getGroupFullName(group), account, "deletegrouppolicy", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        group.removePolicy(name);
    }

    public static void deleteUserPolicy(AuthContext requestUser, Account account, User user, String name) throws AuthException {
        if (user.isAccountAdmin() || !Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "deleteuserpolicy", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        user.removePolicy(name);
    }

    public static void deleteRolePolicy(AuthContext requestUser, Account account, Role role, String name) throws AuthException {
        if (!Permissions.isAuthorized("iam", "role", Accounts.getRoleFullName(role), account, "deleterolepolicy", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        role.removePolicy(name);
    }

    public static List<Policy> listAccountPolicies(AuthContext requestUser, Account account) throws AuthException {
        if (!Privileged.allowListOrReadAccountPolicy(requestUser, account)) {
            throw new AuthException("Access to the resource is denied");
        }
        User admin = account.lookupAdmin();
        return admin.getPolicies();
    }

    public static List<Policy> listGroupPolicies(AuthContext requestUser, Account account, Group group) throws AuthException {
        if (!Permissions.isAuthorized("iam", "group", Accounts.getGroupFullName(group), account, "listgrouppolicies", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        return group.getPolicies();
    }

    public static List<Policy> listUserPolicies(AuthContext requestUser, Account account, User user) throws AuthException {
        if (!Privileged.allowListUserPolicy(requestUser, account, user)) {
            throw new AuthException("Access to the resource is denied");
        }
        return user.getPolicies();
    }

    public static List<Policy> listRolePolicies(AuthContext requestUser, Account account, Role role) throws AuthException {
        if (!Permissions.isAuthorized("iam", "role", Accounts.getRoleFullName(role), account, "listrolepolicies", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        return role.getPolicies();
    }

    public static Policy getAccountPolicy(AuthContext requestUser, Account account, String policyName) throws AuthException {
        if (!Privileged.allowListOrReadAccountPolicy(requestUser, account)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (Strings.isNullOrEmpty((String)policyName)) {
            throw new AuthException("Empty policy name");
        }
        User admin = account.lookupAdmin();
        Policy policy = null;
        for (Policy p : admin.getPolicies()) {
            if (!p.getName().equals(policyName)) continue;
            policy = p;
            break;
        }
        return policy;
    }

    public static Policy getGroupPolicy(AuthContext requestUser, Account account, Group group, String policyName) throws AuthException {
        if (!Privileged.allowReadGroupPolicy(requestUser, account, group)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (Strings.isNullOrEmpty((String)policyName)) {
            throw new AuthException("Empty policy name");
        }
        Policy policy = null;
        for (Policy p : group.getPolicies()) {
            if (!p.getName().equals(policyName)) continue;
            policy = p;
            break;
        }
        return policy;
    }

    public static Policy getUserPolicy(AuthContext requestUser, Account account, User user, String policyName) throws AuthException {
        if (!Privileged.allowReadUserPolicy(requestUser, account, user)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (Strings.isNullOrEmpty((String)policyName)) {
            throw new AuthException("Empty policy name");
        }
        Policy policy = null;
        for (Policy p : user.getPolicies()) {
            if (!p.getName().equals(policyName)) continue;
            policy = p;
            break;
        }
        return policy;
    }

    public static Policy getRolePolicy(AuthContext requestUser, Account account, Role role, String policyName) throws AuthException {
        if (!Privileged.allowReadRolePolicy(requestUser, account, role)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (Strings.isNullOrEmpty((String)policyName)) {
            throw new AuthException("Empty policy name");
        }
        Policy policy = null;
        for (Policy p : role.getPolicies()) {
            if (!p.getName().equals(policyName)) continue;
            policy = p;
            break;
        }
        return policy;
    }

    public static boolean allowReadGroupPolicy(AuthContext requestUser, Account account, Group group) throws AuthException {
        return Permissions.isAuthorized(requestUser.evaluationContext("iam", "group", "getgrouppolicy"), account.getAccountNumber(), Accounts.getGroupFullName(group));
    }

    public static boolean allowReadRolePolicy(AuthContext requestUser, Account account, Role role) throws AuthException {
        return Permissions.isAuthorized("iam", "role", Accounts.getRoleFullName(role), account, "getrolepolicy", requestUser);
    }

    public static boolean allowListUserPolicy(AuthContext requestUser, Account account, User user) throws AuthException {
        return !user.isAccountAdmin() && Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "listuserpolicies", requestUser);
    }

    public static boolean allowReadUserPolicy(AuthContext requestUser, Account account, User user) throws AuthException {
        return !user.isAccountAdmin() && Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "getuserpolicy", requestUser);
    }

    public static boolean allowListAccessKeys(AuthContext requestUser, Account account, User user) {
        return Permissions.isAuthorized(requestUser.evaluationContext("iam", "user", "listaccesskeys"), account.getAccountNumber(), Accounts.getUserFullName(user)) && Privileged.accountAdminActionPermittedIfAuthorized(requestUser, user);
    }

    public static boolean allowListSigningCertificates(AuthContext requestUser, Account account, User user) throws AuthException {
        return Permissions.isAuthorized(requestUser.evaluationContext("iam", "user", "listsigningcertificates"), account.getAccountNumber(), Accounts.getUserFullName(user)) && Privileged.accountAdminActionPermittedIfAuthorized(requestUser, user);
    }

    public static AccessKey createAccessKey(AuthContext requestUser, Account account, User user) throws AuthException {
        if (!Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "createaccesskey", requestUser) || !Privileged.accountAdminActionPermittedIfAuthorized(requestUser, user)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (user.getKeys().size() >= AuthenticationLimitProvider.Values.getAccessKeyLimit()) {
            throw new AuthException("Resource quota is exceeded");
        }
        return user.createKey();
    }

    public static void deleteAccessKey(AuthContext requestUser, Account account, User user, String keyId) throws AuthException {
        if (!Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "deleteaccesskey", requestUser) || !Privileged.accountAdminActionPermittedIfAuthorized(requestUser, user)) {
            throw new AuthException("Access to the resource is denied");
        }
        user.removeKey(keyId);
    }

    public static List<AccessKey> listAccessKeys(AuthContext requestUser, Account account, User user) throws AuthException {
        if (!Privileged.allowListAccessKeys(requestUser, account, user)) {
            throw new AuthException("Access to the resource is denied");
        }
        return user.getKeys();
    }

    public static void modifyAccessKey(AuthContext requestUser, Account account, User user, String keyId, String status) throws AuthException {
        if (!Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "updateaccesskey", requestUser) || !Privileged.accountAdminActionPermittedIfAuthorized(requestUser, user)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (Strings.isNullOrEmpty((String)keyId)) {
            throw new AuthException("Empty access key id");
        }
        if (Strings.isNullOrEmpty((String)status)) {
            throw new AuthException("Empty status");
        }
        AccessKey key = user.getKey(keyId);
        key.setActive("Active".equalsIgnoreCase(status));
    }

    public static Certificate createSigningCertificate(AuthContext requestUser, Account account, User user, KeyPair keyPair) throws AuthException {
        if (!Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "uploadsigningcertificate", requestUser) || !Privileged.accountAdminActionPermittedIfAuthorized(requestUser, user)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (Privileged.countUnrevokedCertificates(user.getCertificates()) >= AuthenticationLimitProvider.Values.getSigningCertificateLimit()) {
            throw new AuthException("Resource quota is exceeded");
        }
        X509Certificate x509 = Certs.generateCertificate(keyPair, user.getName());
        try {
            x509.checkValidity();
        }
        catch (Exception e) {
            throw new AuthException("Invalid X509 Certificate", e);
        }
        return user.addCertificate(x509);
    }

    public static Certificate uploadSigningCertificate(AuthContext requestUser, Account account, User user, String certBody) throws AuthException {
        if (!Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "uploadsigningcertificate", requestUser) || !Privileged.accountAdminActionPermittedIfAuthorized(requestUser, user)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (Privileged.countUnrevokedCertificates(user.getCertificates()) >= AuthenticationLimitProvider.Values.getSigningCertificateLimit()) {
            throw new AuthException("Resource quota is exceeded");
        }
        if (Strings.isNullOrEmpty((String)certBody)) {
            throw new AuthException("Empty certificate");
        }
        String encodedPem = B64.url.encString(certBody);
        for (Certificate c : user.getCertificates()) {
            if (!c.getPem().equals(encodedPem)) continue;
            if (!c.isRevoked().booleanValue()) {
                throw new AuthException("Conflict");
            }
            user.removeCertificate(c.getCertificateId());
        }
        X509Certificate x509 = X509CertHelper.toCertificate(encodedPem);
        if (x509 == null) {
            throw new AuthException("Invalid cert");
        }
        return user.addCertificate(x509);
    }

    public static List<Certificate> listSigningCertificates(AuthContext requestUser, Account account, User user) throws AuthException {
        if (!Privileged.allowListSigningCertificates(requestUser, account, user)) {
            throw new AuthException("Access to the resource is denied");
        }
        ArrayList certs = Lists.newArrayList();
        for (Certificate cert : user.getCertificates()) {
            if (cert.isRevoked().booleanValue()) continue;
            certs.add(cert);
        }
        return certs;
    }

    public static void deleteSigningCertificate(AuthContext requestUser, Account account, User user, String certId) throws AuthException {
        if (!Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "deletesigningcertificate", requestUser) || !Privileged.accountAdminActionPermittedIfAuthorized(requestUser, user)) {
            throw new AuthException("Access to the resource is denied");
        }
        user.removeCertificate(certId);
    }

    public static void modifySigningCertificate(AuthContext requestUser, Account account, User user, String certId, String status) throws AuthException {
        if (!Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "updatesigningcertificate", requestUser) || !Privileged.accountAdminActionPermittedIfAuthorized(requestUser, user)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (Strings.isNullOrEmpty((String)status)) {
            throw new AuthException("Empty status");
        }
        if (Strings.isNullOrEmpty((String)certId)) {
            throw new AuthException("Empty certificate id");
        }
        Certificate cert = user.getCertificate(certId);
        if (cert.isRevoked().booleanValue()) {
            throw new AuthException("No such certificate");
        }
        cert.setActive("Active".equalsIgnoreCase(status));
    }

    private static boolean accountAdminActionPermittedIfAuthorized(AuthContext requestUser, User user) {
        return !user.isAccountAdmin() || requestUser.isAccountAdmin() || requestUser.isSystemUser();
    }

    public static void createLoginProfile(AuthContext requestUser, Account account, User user, String password) throws AuthException {
        if (!Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "createloginprofile", requestUser) || !Privileged.accountAdminActionPermittedIfAuthorized(requestUser, user)) {
            throw new AuthException("Access to the resource is denied");
        }
        Privileged.setUserPassword(user, password);
    }

    public static void deleteLoginProfile(AuthContext requestUser, Account account, User user) throws AuthException {
        if (!Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "deleteloginprofile", requestUser) || !Privileged.accountAdminActionPermittedIfAuthorized(requestUser, user)) {
            throw new AuthException("Access to the resource is denied");
        }
        user.setPassword(null);
    }

    public static boolean allowReadLoginProfile(AuthContext requestUser, Account account, User user) throws AuthException {
        return Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "getloginprofile", requestUser) && Privileged.accountAdminActionPermittedIfAuthorized(requestUser, user);
    }

    public static void updateLoginProfile(AuthContext requestUser, Account account, User user, String newPass) throws AuthException {
        if (!Permissions.isAuthorized("iam", "user", Accounts.getUserFullName(user), account, "updateloginprofile", requestUser) || !Privileged.accountAdminActionPermittedIfAuthorized(requestUser, user)) {
            throw new AuthException("Access to the resource is denied");
        }
        Privileged.setUserPassword(user, newPass);
    }

    private static void setUserPassword(User user, String newPass) throws AuthException {
        if (Strings.isNullOrEmpty((String)newPass) || user.getName().equals(newPass)) {
            throw new AuthException("Invalid password");
        }
        String newEncrypted = Crypto.generateEncryptedPassword(newPass);
        user.setPassword(newEncrypted);
        user.setPasswordExpires(System.currentTimeMillis() + AuthenticationLimitProvider.Values.getDefaultPasswordExpiry());
    }

    public static void createServerCertificate(AuthContext requestUser, Account account, String pemCertBody, String pemCertChain, String path, String certName, String pemPk) throws AuthException {
        if (!Permissions.isAuthorized("iam", "server-certificate", certName, account, "uploadservercertificate", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        if (!Permissions.canAllocate("iam", "server-certificate", "", "uploadservercertificate", requestUser, (Long)1L)) {
            throw new AuthException("Resource quota is exceeded");
        }
        account.addServerCertificate(certName, pemCertBody, pemCertChain, path, pemPk);
    }

    public static List<ServerCertificate> listServerCertificate(AuthContext requestUser, Account account, String pathPrefix) throws AuthException {
        if (!Permissions.isAuthorized("iam", "server-certificate", pathPrefix, account, "listservercertificates", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        return account.listServerCertificates(pathPrefix);
    }

    public static ServerCertificate getServerCertificate(AuthContext requestUser, Account account, String certName) throws AuthException {
        if (!Permissions.isAuthorized("iam", "server-certificate", certName, account, "getservercertificate", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        return account.lookupServerCertificate(certName);
    }

    public static void deleteServerCertificate(AuthContext requestUser, Account account, String certName) throws AuthException {
        if (!Permissions.isAuthorized("iam", "server-certificate", certName, account, "deleteservercertificate", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        account.deleteServerCertificate(certName);
    }

    public static void updateServerCertificate(AuthContext requestUser, Account account, String certName, String newCertName, String newPath) throws AuthException {
        if (!Permissions.isAuthorized("iam", "server-certificate", certName, account, "updateservercertificate", requestUser) || !Permissions.isAuthorized("iam", "server-certificate", newCertName, account, "updateservercertificate", requestUser)) {
            throw new AuthException("Access to the resource is denied");
        }
        account.updateServerCeritificate(certName, newCertName, newPath);
    }

    private static int countUnrevokedCertificates(List<Certificate> certificates) {
        return Iterables.size((Iterable)Iterables.filter(certificates, CollectionUtils.propertyPredicate(false, Certificate.Util.revoked())));
    }
}

