/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class PolicyResourceContext
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(PolicyResourceContext.class);
    private static final List<PolicyResourceInterceptor> resourceInterceptors = Lists.newCopyOnWriteArrayList();

    private PolicyResourceContext() {
    }

    public static PolicyResourceContext of(Object resource, String action) {
        PolicyResourceContext.notifyResourceInterceptors(resource instanceof PolicyResourceInfo ? (PolicyResourceInfo)resource : TypeMappers.transform(resource, PolicyResourceInfo.class), action);
        return new PolicyResourceContext();
    }

    public static PolicyResourceInfo resourceInfo(@Nullable String accountNumber, @Nonnull Object resourceObject) {
        return PolicyResourceContext.resourceInfo(accountNumber, resourceObject, resourceObject.getClass());
    }

    public static PolicyResourceInfo resourceInfo(final @Nullable String accountNumber, final @Nonnull Object resourceObject, final @Nonnull Class resourceClass) {
        return new PolicyResourceInfo(){

            @Override
            @Nullable
            public String getResourceAccountNumber() {
                return accountNumber;
            }

            @Override
            @Nonnull
            public Class getResourceClass() {
                return resourceClass;
            }

            @Override
            @Nonnull
            public Object getResourceObject() {
                return resourceObject;
            }
        };
    }

    @Override
    public void close() {
        PolicyResourceContext.notifyResourceInterceptors(null, null);
    }

    private static void notifyResourceInterceptors(PolicyResourceInfo policyResourceInfo, String action) {
        for (PolicyResourceInterceptor interceptor : resourceInterceptors) {
            interceptor.onResource(policyResourceInfo, action);
        }
    }

    public static class PolicyResourceInterceptorDiscovery
    extends ServiceJarDiscovery {
        @Override
        public boolean processClass(Class candidate) throws Exception {
            if (PolicyResourceInterceptor.class.isAssignableFrom(candidate) && !Modifier.isAbstract(candidate.getModifiers())) {
                logger.info((Object)("Registered PolicyResourceInterceptor:    " + candidate));
                resourceInterceptors.add((PolicyResourceInterceptor)Classes.newInstance(candidate, new Object[0]));
                return true;
            }
            return false;
        }

        @Override
        public Double getPriority() {
            return 0.3;
        }
    }

    public static class AccountNumberPolicyResourceInterceptor
    implements PolicyResourceInterceptor {
        private static final ThreadLocal<String> accountNumberThreadLocal = new ThreadLocal();

        @Override
        public void onResource(PolicyResourceInfo resource, String action) {
            accountNumberThreadLocal.set(resource == null ? null : resource.getResourceAccountNumber());
        }

        public static Optional<String> getCurrentResourceAccountNumber() {
            return Optional.fromNullable((Object)accountNumberThreadLocal.get());
        }
    }

    public static interface PolicyResourceInterceptor {
        public void onResource(@Nullable PolicyResourceInfo var1, @Nullable String var2);
    }

    public static interface PolicyResourceInfo {
        @Nullable
        public String getResourceAccountNumber();

        @Nonnull
        public Class getResourceClass();

        @Nonnull
        public Object getResourceObject();
    }
}

