/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.AuthContext;
import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.AuthEvaluationContext;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.Contract;
import com.eucalyptus.auth.api.PolicyEngine;
import com.eucalyptus.auth.policy.PolicySpec;
import com.eucalyptus.auth.policy.key.Key;
import com.eucalyptus.auth.policy.key.Keys;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Policy;
import com.eucalyptus.auth.principal.Principal;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.IllegalContextAccessException;
import com.eucalyptus.util.Exceptions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class Permissions {
    private static Logger LOG = Logger.getLogger(Permissions.class);
    private static PolicyEngine policyEngine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPolicyEngine(PolicyEngine engine) {
        Class<Permissions> clazz = Permissions.class;
        synchronized (Permissions.class) {
            LOG.info((Object)("Setting the policy engine to: " + engine.getClass()));
            policyEngine = engine;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static AuthContext createAuthContext(User requestUser, Map<String, String> evaluatedKeys) throws AuthException {
        return new AuthContext(requestUser, evaluatedKeys);
    }

    public static AuthContextSupplier createAuthContextSupplier(final User requestUser, final Map<String, String> evaluatedKeys) {
        return new AuthContextSupplier(){

            @Override
            public AuthContext get() throws AuthException {
                return Permissions.createAuthContext(requestUser, evaluatedKeys);
            }
        };
    }

    public static AuthEvaluationContext createEvaluationContext(String vendor, String resourceType, String action, User requestUser, Map<String, String> evaluatedKeys) {
        return policyEngine.createEvaluationContext(PolicySpec.qualifiedName(vendor, resourceType), PolicySpec.qualifiedName(vendor, action), requestUser, evaluatedKeys);
    }

    public static boolean isAuthorized(@Nonnull String vendor, @Nonnull String resourceType, @Nonnull String resourceName, @Nullable Account resourceAccount, @Nonnull String action, @Nonnull AuthContextSupplier requestUser) {
        String resourceAccountNumber = resourceAccount == null ? null : resourceAccount.getAccountNumber();
        try {
            return Permissions.isAuthorized(requestUser.get().evaluationContext(vendor, resourceType, action), resourceAccountNumber, resourceName);
        }
        catch (AuthException e) {
            LOG.error((Object)("Exception in resource access to " + resourceType + ":" + resourceName), (Throwable)e);
            return false;
        }
    }

    public static boolean isAuthorized(@Nonnull String vendor, @Nonnull String resourceType, @Nonnull String resourceName, @Nullable Account resourceAccount, @Nonnull String action, @Nonnull AuthContext requestUser) {
        String resourceAccountNumber = resourceAccount == null ? null : resourceAccount.getAccountNumber();
        return Permissions.isAuthorized(requestUser.evaluationContext(vendor, resourceType, action), resourceAccountNumber, resourceName);
    }

    public static boolean isAuthorized(@Nonnull AuthEvaluationContext context, @Nullable String resourceAccountNumber, @Nonnull String resourceName) {
        try {
            HashMap contracts = Maps.newHashMap();
            policyEngine.evaluateAuthorization(context, PolicyEngine.AuthorizationMatch.All, resourceAccountNumber, resourceName, (Map<Contract.Type, Contract>)contracts);
            Permissions.pushToContext(contracts);
            return true;
        }
        catch (AuthException e) {
            LOG.debug((Object)("Denied resource access to " + context.describe(resourceAccountNumber, resourceName) + ": " + e.getMessage()));
        }
        catch (Exception e) {
            LOG.error((Object)("Exception in resource access to " + context.describe(resourceAccountNumber, resourceName)), (Throwable)e);
        }
        return false;
    }

    public static boolean isAuthorized(Principal.PrincipalType principalType, String principalName, Policy resourcePolicy, String resourceType, String resourceName, Account resourceAccount, String action, User requestUser, Map<String, String> evaluatedKeys) {
        String resourceAccountNumber = resourceAccount == null ? null : resourceAccount.getAccountNumber();
        AuthEvaluationContext context = policyEngine.createEvaluationContext(resourceType, action, requestUser, evaluatedKeys, principalType, principalName);
        try {
            HashMap contracts = Maps.newHashMap();
            policyEngine.evaluateAuthorization(context, resourcePolicy, resourceAccountNumber, resourceName, (Map<Contract.Type, Contract>)contracts);
            Permissions.pushToContext(contracts);
            return true;
        }
        catch (AuthException e) {
            LOG.debug((Object)("Denied resource access to " + context.describe(resourceAccountNumber, resourceName) + ": " + e.getMessage()));
        }
        catch (Exception e) {
            LOG.error((Object)("Exception in resource access to " + context.describe(resourceAccountNumber, resourceName)), (Throwable)e);
        }
        return false;
    }

    public static boolean perhapsAuthorized(@Nonnull String vendor, @Nonnull String action, @Nonnull AuthContextSupplier requestUser) {
        try {
            HashMap contracts = Maps.newHashMap();
            policyEngine.evaluateAuthorization(requestUser.get().evaluationContext(vendor, null, action), PolicyEngine.AuthorizationMatch.Unconditional, null, "", (Map<Contract.Type, Contract>)contracts);
            return true;
        }
        catch (AuthException e) {
            LOG.debug((Object)("Denied access for action " + action + ": " + e.getMessage()));
        }
        catch (Exception e) {
            LOG.error((Object)("Exception in access for action " + action), (Throwable)e);
        }
        return false;
    }

    public static boolean canAllocate(String vendor, String resourceType, String resourceName, String action, User requestUser, Long quantity) {
        return Permissions.canAllocate(Permissions.createEvaluationContext(vendor, resourceType, action, requestUser, Collections.emptyMap()), resourceName, quantity);
    }

    public static boolean canAllocate(String vendor, String resourceType, String resourceName, String action, AuthContext requestUser, Long quantity) {
        return Permissions.canAllocate(requestUser.evaluationContext(vendor, resourceType, action), resourceName, quantity);
    }

    public static boolean canAllocate(String vendor, String resourceType, String resourceName, String action, AuthContextSupplier requestUser, Long quantity) {
        try {
            return Permissions.canAllocate(requestUser.get().evaluationContext(vendor, resourceType, action), resourceName, quantity);
        }
        catch (AuthException e) {
            LOG.error((Object)("Exception in resource allocation for " + resourceType + ":" + resourceName), (Throwable)e);
            return false;
        }
    }

    public static boolean canAllocate(AuthEvaluationContext context, String resourceName, Long quantity) {
        try {
            policyEngine.evaluateQuota(context, resourceName, quantity);
            return true;
        }
        catch (AuthException e) {
            LOG.debug((Object)("Denied resource allocation of " + context.describe(resourceName, quantity)), (Throwable)e);
            return false;
        }
    }

    public static Map<String, String> evaluateHostKeys() throws AuthException {
        try {
            return Maps.transformValues(Keys.getKeyInstances(Key.EvaluationConstraint.ReceivingHost), Keys.value());
        }
        catch (RuntimeException e) {
            throw Exceptions.rethrow(e, AuthException.class);
        }
    }

    private static void pushToContext(Map<Contract.Type, Contract> contracts) {
        try {
            Contexts.lookup().setContracts(contracts);
        }
        catch (IllegalContextAccessException e) {
            LOG.debug((Object)"Not in a request context", (Throwable)e);
        }
    }
}

