/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.NonNullFunction;
import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;

public interface AuthenticationLimitProvider {
    public long getDefaultPasswordExpirySpi();

    public int getAccessKeyLimitSpi();

    public int getSigningCertificateLimitSpi();

    public static enum AuthenticationLongProperties implements NonNullFunction<AuthenticationLimitProvider, Long>
    {
        DEFAULT_PASSWORD_EXPIRY{

            @Override
            @Nonnull
            public Long apply(AuthenticationLimitProvider authenticationLimitProvider) {
                return authenticationLimitProvider.getDefaultPasswordExpirySpi();
            }
        };

    }

    public static enum AuthenticationLimit implements NonNullFunction<AuthenticationLimitProvider, Integer>
    {
        ACCESS_KEY{

            @Override
            @Nonnull
            public Integer apply(AuthenticationLimitProvider authenticationLimitProvider) {
                return authenticationLimitProvider.getAccessKeyLimitSpi();
            }
        }
        ,
        SIGNING_CERTIFICATE{

            @Override
            @Nonnull
            public Integer apply(AuthenticationLimitProvider authenticationLimitProvider) {
                return authenticationLimitProvider.getSigningCertificateLimitSpi();
            }
        };

    }

    public static class Values {
        static long getDefaultPasswordExpiry() {
            return Values.getLongValue(AuthenticationLongProperties.DEFAULT_PASSWORD_EXPIRY);
        }

        static int getAccessKeyLimit() {
            return Values.getIntValue(AuthenticationLimit.ACCESS_KEY);
        }

        static int getSigningCertificateLimit() {
            return Values.getIntValue(AuthenticationLimit.SIGNING_CERTIFICATE);
        }

        static int getIntValue(NonNullFunction<AuthenticationLimitProvider, Integer> valueFunction) {
            return Values.getValue(valueFunction, Integer.MAX_VALUE, CollectionUtils.min());
        }

        static long getLongValue(NonNullFunction<AuthenticationLimitProvider, Long> valueFunction) {
            return Values.getValue(valueFunction, Long.MAX_VALUE, CollectionUtils.lmin());
        }

        static <VT> VT getValue(NonNullFunction<AuthenticationLimitProvider, VT> valueFunction, VT initial, Function<VT, Function<VT, VT>> reducer) {
            return CollectionUtils.reduce(Lists.newArrayList((Iterator)Iterators.transform(ServiceLoader.load(AuthenticationLimitProvider.class).iterator(), valueFunction)), initial, reducer);
        }
    }
}

