/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.AuthEvaluationContext;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.auth.principal.User;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuthContext {
    private final String userId;
    private final String accountNumber;
    private final boolean accountAdmin;
    private final boolean systemAdmin;
    private final boolean systemUser;
    private final User user;
    private final Map<String, String> evaluatedKeys;
    private Map<AuthEvaluationContextKey, AuthEvaluationContext> contexts = Maps.newHashMap();

    AuthContext(User requestUser, Map<String, String> evaluatedKeys) throws AuthException {
        this.userId = requestUser.getUserId();
        this.systemAdmin = requestUser.isSystemAdmin();
        this.systemUser = requestUser.isSystemUser();
        this.accountAdmin = requestUser.isAccountAdmin();
        this.accountNumber = requestUser.getAccountNumber();
        this.user = requestUser;
        this.evaluatedKeys = evaluatedKeys;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public boolean isAccountAdmin() {
        return this.accountAdmin;
    }

    public boolean isSystemAdmin() {
        return this.systemAdmin;
    }

    public boolean isSystemUser() {
        return this.systemUser;
    }

    public AuthEvaluationContext evaluationContext(@Nonnull String vendor, @Nullable String resource, @Nonnull String action) {
        AuthEvaluationContextKey key = new AuthEvaluationContextKey(vendor, resource, action);
        AuthEvaluationContext context = this.contexts.get(key);
        if (context == null) {
            context = Permissions.createEvaluationContext(vendor, resource, action, this.user, this.evaluatedKeys);
            this.contexts.put(key, context);
        }
        return context;
    }

    private static final class AuthEvaluationContextKey {
        @Nonnull
        private final String vendor;
        @Nullable
        private final String resource;
        @Nonnull
        private final String action;

        private AuthEvaluationContextKey(@Nonnull String vendor, @Nullable String resource, @Nonnull String action) {
            this.vendor = vendor;
            this.resource = resource;
            this.action = action;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuthEvaluationContextKey that = (AuthEvaluationContextKey)o;
            if (!this.action.equals(that.action)) {
                return false;
            }
            if (this.resource != null ? !this.resource.equals(that.resource) : that.resource != null) {
                return false;
            }
            return this.vendor.equals(that.vendor);
        }

        public int hashCode() {
            int result = this.vendor.hashCode();
            result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
            result = 31 * result + this.action.hashCode();
            return result;
        }
    }
}

