/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.api.AccountProvider;
import com.eucalyptus.auth.policy.ern.EuareResourceName;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Certificate;
import com.eucalyptus.auth.principal.Group;
import com.eucalyptus.auth.principal.InstanceProfile;
import com.eucalyptus.auth.principal.Role;
import com.eucalyptus.auth.principal.RoleUser;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Function;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.log4j.Logger;

public class Accounts {
    private static final Logger LOG = Logger.getLogger(Accounts.class);
    private static AccountProvider accounts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAccountProvider(AccountProvider provider) {
        Class<Accounts> clazz = Accounts.class;
        synchronized (Accounts.class) {
            LOG.info((Object)("Setting the account provider to: " + provider.getClass()));
            accounts = provider;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static AccountProvider getAccountProvider() {
        return accounts;
    }

    public static Account lookupAccountByName(String accountName) throws AuthException {
        return Accounts.getAccountProvider().lookupAccountByName(accountName);
    }

    public static Account lookupAccountById(String accountId) throws AuthException {
        return Accounts.getAccountProvider().lookupAccountById(accountId);
    }

    public static Account lookupAccountByCanonicalId(String canonicalId) throws AuthException {
        return Accounts.getAccountProvider().lookupAccountByCanonicalId(canonicalId);
    }

    public static Account addAccount(String accountName) throws AuthException {
        return Accounts.getAccountProvider().addAccount(accountName);
    }

    public static void deleteAccount(String accountName, boolean forceDeleteSystem, boolean recursive) throws AuthException {
        Accounts.getAccountProvider().deleteAccount(accountName, forceDeleteSystem, recursive);
    }

    public static List<Account> listAllAccounts() throws AuthException {
        return Accounts.getAccountProvider().listAllAccounts();
    }

    public static boolean isSystemAccount(String accountName) {
        return "eucalyptus".equals(accountName) || Objects.toString(accountName, "").startsWith("(eucalyptus)");
    }

    public static boolean isSystemAccount(Account account) {
        return Accounts.isSystemAccount(account == null ? null : account.getName());
    }

    public static Account addSystemAccount() throws AuthException {
        return Accounts.getAccountProvider().addAccount("eucalyptus");
    }

    public static Account addSystemAccount(String accountName) throws AuthException {
        return Accounts.getAccountProvider().addSystemAccount(accountName);
    }

    public static Account addSystemAccountWithAdmin(String accountName) throws AuthException {
        Account account = Accounts.addSystemAccount(accountName);
        try {
            account.lookupUserByName("admin");
        }
        catch (AuthException e) {
            account.addUser("admin", "/", true, null);
        }
        return account;
    }

    public static Set<String> resolveAccountNumbersForName(String accountNameLike) throws AuthException {
        return Accounts.getAccountProvider().resolveAccountNumbersForName(accountNameLike);
    }

    public static List<User> listAllUsers() throws AuthException {
        return Accounts.getAccountProvider().listAllUsers();
    }

    public static boolean shareSameAccount(String userId1, String userId2) {
        return Accounts.getAccountProvider().shareSameAccount(userId1, userId2);
    }

    @Deprecated
    public static User lookupUserByName(String userName) throws AuthException {
        return Accounts.getAccountProvider().lookupUserByName(userName);
    }

    public static User lookupUserById(String userId) throws AuthException {
        return Accounts.getAccountProvider().lookupUserById(userId);
    }

    public static User lookupUserByAccessKeyId(String keyId) throws AuthException {
        return Accounts.getAccountProvider().lookupUserByAccessKeyId(keyId);
    }

    public static User lookupUserByCertificate(X509Certificate cert) throws AuthException {
        return Accounts.getAccountProvider().lookupUserByCertificate(cert);
    }

    public static Group lookupGroupById(String groupId) throws AuthException {
        return Accounts.getAccountProvider().lookupGroupById(groupId);
    }

    public static Role lookupRoleById(String roleId) throws AuthException {
        return Accounts.getAccountProvider().lookupRoleById(roleId);
    }

    public static Certificate lookupCertificate(X509Certificate cert) throws AuthException {
        return Accounts.getAccountProvider().lookupCertificate(cert);
    }

    public static AccessKey lookupAccessKeyById(String keyId) throws AuthException {
        return Accounts.getAccountProvider().lookupAccessKeyById(keyId);
    }

    public static User lookupSystemAdmin() throws AuthException {
        Account system = Accounts.getAccountProvider().lookupAccountByName("eucalyptus");
        return system.lookupAdmin();
    }

    public static User lookupAwsExecReadAdmin(boolean ensureActiveKey) throws AuthException {
        Account system = Accounts.getAccountProvider().lookupAccountByName("(eucalyptus)aws-exec-read");
        User user = system.lookupAdmin();
        if (ensureActiveKey) {
            boolean hasActiveKey = false;
            for (AccessKey k : user.getKeys()) {
                if (!k.isActive().booleanValue()) continue;
                hasActiveKey = true;
                break;
            }
            if (!hasActiveKey) {
                user.createKey();
                LOG.debug((Object)("Created new user key for " + user.getName()));
            }
        }
        return user;
    }

    public static String getFirstActiveAccessKeyId(User user) throws AuthException {
        for (AccessKey k : user.getKeys()) {
            if (!k.isActive().booleanValue()) continue;
            return k.getAccessKey();
        }
        throw new AuthException("No active access key for " + user);
    }

    public static User lookupUserByConfirmationCode(String code) throws AuthException {
        return Accounts.getAccountProvider().lookupUserByConfirmationCode(code);
    }

    public static User lookupUserByEmailAddress(String email) throws AuthException {
        return Accounts.getAccountProvider().lookupUserByEmailAddress(email);
    }

    public static User roleAsUser(Role role) throws AuthException {
        return new RoleUser(role, role.getAccount().lookupAdmin());
    }

    public static String getAccountFullName(Account account) {
        return "/" + account.getName();
    }

    public static String getUserFullName(User user) {
        if (user.getPath().endsWith("/")) {
            return user.getPath() + user.getName();
        }
        return user.getPath() + "/" + user.getName();
    }

    public static String getGroupFullName(Group group) {
        if (group.getPath().endsWith("/")) {
            return group.getPath() + group.getName();
        }
        return group.getPath() + "/" + group.getName();
    }

    public static String getRoleFullName(Role role) {
        if (role.getPath().endsWith("/")) {
            return role.getPath() + role.getName();
        }
        return role.getPath() + "/" + role.getName();
    }

    public static String getInstanceProfileFullName(InstanceProfile instanceProfile) {
        if (instanceProfile.getPath().endsWith("/")) {
            return instanceProfile.getPath() + instanceProfile.getName();
        }
        return instanceProfile.getPath() + "/" + instanceProfile.getName();
    }

    public static String getUserArn(User user) throws AuthException {
        return Accounts.buildArn(user.getAccount(), "user", user.getPath(), user.getName());
    }

    public static String getGroupArn(Group group) throws AuthException {
        return Accounts.buildArn(group.getAccount(), "group", group.getPath(), group.getName());
    }

    public static String getRoleArn(Role role) throws AuthException {
        return Accounts.buildArn(role.getAccount(), "role", role.getPath(), role.getName());
    }

    public static String getInstanceProfileArn(InstanceProfile instanceProfile) throws AuthException {
        return Accounts.buildArn(instanceProfile.getAccount(), "instance-profile", instanceProfile.getPath(), instanceProfile.getName());
    }

    private static String buildArn(Account account, String type, String path, String name) throws AuthException {
        return new EuareResourceName(account.getAccountNumber(), type, path, name).toString();
    }

    public static boolean isRoleIdentifier(String identifier) {
        return identifier.startsWith("ARO");
    }

    public static void normalizeUserInfo() throws AuthException {
        for (User user : Accounts.listAllUsers()) {
            try {
                user.setInfo(user.getInfo());
            }
            catch (AuthException e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
    }

    public static Function<Account, String> toAccountNumber() {
        return AccountStringProperties.ACCOUNT_NUMBER;
    }

    public static Function<User, String> toUserAccountNumber() {
        return UserStringProperties.ACCOUNT_NUMBER;
    }

    public static Function<User, String> toUserId() {
        return UserStringProperties.USER_ID;
    }

    public static Function<Group, String> toGroupAccountNumber() {
        return GroupStringProperties.ACCOUNT_NUMBER;
    }

    public static Function<Group, String> toGroupId() {
        return GroupStringProperties.GROUP_ID;
    }

    private static enum GroupStringProperties implements Function<Group, String>
    {
        ACCOUNT_NUMBER{

            public String apply(Group group) {
                try {
                    return group.getAccountNumber();
                }
                catch (AuthException e) {
                    throw Exceptions.toUndeclared(e);
                }
            }
        }
        ,
        GROUP_ID{

            public String apply(Group group) {
                return group.getGroupId();
            }
        };

    }

    private static enum UserStringProperties implements Function<User, String>
    {
        ACCOUNT_NUMBER{

            public String apply(User user) {
                try {
                    return user.getAccountNumber();
                }
                catch (AuthException e) {
                    throw Exceptions.toUndeclared(e);
                }
            }
        }
        ,
        USER_ID{

            public String apply(User user) {
                return user.getUserId();
            }
        };

    }

    private static enum AccountStringProperties implements Function<Account, String>
    {
        ACCOUNT_NUMBER{

            public String apply(Account account) {
                return account.getAccountNumber();
            }
        };

    }
}

