/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.TemporaryAccessKey;
import com.eucalyptus.auth.tokens.SecurityTokenManager;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AccessKeys {
    public static AccessKey lookupAccessKey(@Nonnull String accessKeyId, @Nullable String securityToken) throws AuthException {
        return securityToken == null ? Accounts.lookupAccessKeyById(accessKeyId) : SecurityTokenManager.lookupAccessKey(accessKeyId, securityToken);
    }

    public static Predicate<AccessKey> isActive() {
        return IS_ACTIVE.INSTANCE;
    }

    @Nonnull
    public static Optional<TemporaryAccessKey.TemporaryKeyType> getKeyType(@Nonnull AccessKey key) {
        Optional type = Optional.absent();
        if (key instanceof TemporaryAccessKey) {
            type = Optional.of((Object)((Object)((TemporaryAccessKey)key).getType()));
        }
        return type;
    }

    private static enum IS_ACTIVE implements Predicate<AccessKey>
    {
        INSTANCE;


        public boolean apply(AccessKey accessKey) {
            return Boolean.TRUE.equals(accessKey.isActive());
        }
    }
}

