/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.util;

import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Topology;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.system.BaseDirectory;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ObjectStorageProperties {
    private static Logger LOG = Logger.getLogger(ObjectStorageProperties.class);
    public static final long G = 0x40000000L;
    public static final long M = 0x100000L;
    public static final long K = 1024L;
    public static int IO_CHUNK_SIZE = 4096;
    public static boolean enableTorrents = false;
    public static final String NAMESPACE_VERSION = "2006-03-01";
    public static int MAX_KEYS = 1000;
    public static int MIN_PART_NUMBER = 1;
    public static int MAX_PART_NUMBER = 10000;
    public static final String AMZ_META_HEADER_PREFIX = "x-amz-meta-";
    public static final String AMZ_ACL = "x-amz-acl";
    public static final String AMZ_REQUEST_ID = "x-amz-request-id";
    public static final String LEGACY_WALRUS_SERVICE_PATH = "/services/Walrus";
    public static final long OBJECT_CREATION_EXPIRATION_INTERVAL_SEC = 30L;
    public static final String IGNORE_PREFIX = "x-ignore-";
    public static final String COPY_SOURCE = "x-amz-copy-source";
    public static final String METADATA_DIRECTIVE = "x-amz-metadata-directive";
    public static final String X_AMZ_VERSION_ID = "x-amz-version-id";
    public static final String NULL_VERSION_ID = "null";
    public static final String X_AMZ_DELETE_MARKER = "x-amz-delete-marker";
    public static final String X_AMZ_SECURITY_TOKEN = "x-amz-security-token";
    public static final String TRACKER_BINARY = "bttrack";
    public static final String TORRENT_CREATOR_BINARY = "btmakemetafile";
    public static final String TORRENT_CLIENT_BINARY = "btdownloadheadless";
    public static String TRACKER_DIR = BaseDirectory.VAR.toString() + "/bt";
    public static String TRACKER_URL = "http://localhost:6969/announce";
    public static String TRACKER_PORT = "6969";
    public static long MAX_INLINE_DATA_SIZE = 0xA00000L;
    public static long MPU_PART_MIN_SIZE = 0x500000L;
    public static final long EXPIRATION_LIMIT = 900000L;
    public static final Pattern RANGE_HEADER_PATTERN = Pattern.compile("^bytes=(\\d*)-(\\d*)$");
    public static final Map<X_AMZ_GRANT, Permission> HEADER_PERMISSION_MAP = ImmutableMap.builder().put((Object)X_AMZ_GRANT.READ, (Object)Permission.READ).put((Object)X_AMZ_GRANT.WRITE, (Object)Permission.WRITE).put((Object)X_AMZ_GRANT.READ_ACP, (Object)Permission.READ_ACP).put((Object)X_AMZ_GRANT.WRITE_ACP, (Object)Permission.WRITE_ACP).put((Object)X_AMZ_GRANT.FULL_CONTROL, (Object)Permission.FULL_CONTROL).build();
    public static final Map<String, String> RESPONSE_OVERRIDE_HTTP_HEADER_MAP = ImmutableMap.builder().put((Object)ResponseHeaderOverrides.response_content_type.toString(), (Object)"Content-Type").put((Object)ResponseHeaderOverrides.response_content_language.toString(), (Object)"Content-Language").put((Object)ResponseHeaderOverrides.response_expires.toString(), (Object)"Expires").put((Object)ResponseHeaderOverrides.response_cache_control.toString(), (Object)"Cache-Control").put((Object)ResponseHeaderOverrides.response_content_disposition.toString(), (Object)"Content-Disposition").put((Object)ResponseHeaderOverrides.response_content_encoding.toString(), (Object)"Content-Encoding").build();

    public static String getTrackerUrl() {
        try {
            TRACKER_URL = "http://" + Topology.lookup(ObjectStorage.class, (Partition[])new Partition[0]).getUri().getHost() + ":" + TRACKER_PORT + "/announce";
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return TRACKER_URL;
    }

    public static enum RequiredQueryParams {
        Date;

    }

    public static enum ObjectParameter {
        acl,
        torrent,
        versionId,
        uploads,
        partNumber,
        uploadId,
        maxParts,
        partNumberMarker;

    }

    public static enum BucketParameter {
        acl,
        location,
        prefix,
        maxkeys,
        delimiter,
        marker,
        torrent,
        logging,
        versioning,
        versions,
        versionidmarker,
        keymarker,
        cors,
        lifecycle,
        policy,
        notification,
        tagging,
        requestPayment,
        website,
        uploads,
        maxUploads,
        uploadIdMarker;

    }

    public static enum ServiceParameter {

    }

    public static enum HTTPVerb {
        GET,
        PUT,
        DELETE,
        POST,
        HEAD,
        OPTIONS;

    }

    public static enum ResponseHeaderOverrides {
        response_content_type{

            public String toString() {
                return "response-content-type";
            }
        }
        ,
        response_content_language{

            public String toString() {
                return "response-content-language";
            }
        }
        ,
        response_expires{

            public String toString() {
                return "response-expires";
            }
        }
        ,
        response_cache_control{

            public String toString() {
                return "response-cache-control";
            }
        }
        ,
        response_content_disposition{

            public String toString() {
                return "response-content-disposition";
            }
        }
        ,
        response_content_encoding{

            public String toString() {
                return "response-content-encoding";
            }
        };


        public static ResponseHeaderOverrides fromString(String value) {
            if (value != null && "response-content-type".equals(value)) {
                return response_content_type;
            }
            if (value != null && "response-content-language".equals(value)) {
                return response_content_language;
            }
            if (value != null && "response-expires".equals(value)) {
                return response_expires;
            }
            if (value != null && "response-cache-control".equals(value)) {
                return response_cache_control;
            }
            if (value != null && "response-content-disposition".equals(value)) {
                return response_content_disposition;
            }
            if (value != null && "response-content-encoding".equals(value)) {
                return response_content_encoding;
            }
            return null;
        }
    }

    public static enum SubResource {
        acl,
        lifecycle,
        location,
        logging,
        notification,
        partNumber,
        policy,
        requestPayment,
        torrent,
        uploadId,
        uploads,
        versionId,
        versioning,
        versions,
        website,
        cors,
        tagging;

    }

    public static enum MetadataDirective {
        COPY,
        REPLACE;

    }

    public static enum CopyHeaders {
        CopySourceIfMatch,
        CopySourceIfNoneMatch,
        CopySourceIfUnmodifiedSince,
        CopySourceIfModifiedSince;

    }

    public static enum PolicyHeaders {
        expiration,
        conditions;

    }

    public static enum IgnoredFields {
        AWSAccessKeyId,
        Signature,
        file,
        Policy,
        submit;

    }

    public static enum FormField {
        AWSAccessKeyId,
        key,
        bucket,
        acl,
        Policy,
        redirect,
        success_action_redirect,
        success_action_status,
        x_amz_security_token{

            public String toString() {
                return ObjectStorageProperties.X_AMZ_SECURITY_TOKEN;
            }
        }
        ,
        Signature,
        file,
        Cache_Control{

            public String toString() {
                return "Cache-Control";
            }
        }
        ,
        Content_Type{

            public String toString() {
                return "Content-Type";
            }
        }
        ,
        Content_Disposition{

            public String toString() {
                return "Content-Disposition";
            }
        }
        ,
        Content_Encoding{

            public String toString() {
                return "Content-Encoding";
            }
        }
        ,
        Expires,
        x_ignore_firstdatachunk{

            public String toString() {
                return "x-ignore-firstdatachunk";
            }
        }
        ,
        x_ignore_filecontentlength{

            public String toString() {
                return "x-ignore-filecontentlength";
            }
        }
        ,
        x_ignore_formboundary{

            public String toString() {
                return "x-ignore-formboundary";
            }
        };

        private static Set<FormField> HTTPHeaderFields;

        public static boolean isHttpField(String value) {
            try {
                return HTTPHeaderFields.contains((Object)FormField.valueOf(value.replace('-', '_')));
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        static {
            HTTPHeaderFields = Sets.newHashSet((Object[])new FormField[]{Content_Type, Cache_Control, Content_Disposition, Content_Encoding, Expires});
        }
    }

    public static enum GetOptionalParameters {
        IsCompressed;

    }

    public static enum ExtendedHeaderRangeTypes {
        ByteRangeStart,
        ByteRangeEnd;

    }

    public static enum ExtendedHeaderDateTypes {
        IfModifiedSince,
        IfUnmodifiedSince,
        CopySourceIfModifiedSince,
        CopySourceIfUnmodifiedSince;


        public static boolean contains(String value) {
            for (ExtendedHeaderDateTypes type : ExtendedHeaderDateTypes.values()) {
                if (!type.toString().equals(value)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum ExtendedGetHeaders {
        IfModifiedSince,
        IfUnmodifiedSince,
        IfMatch,
        IfNoneMatch,
        Range;

    }

    public static enum Headers {
        Bucket,
        Key,
        RandomKey,
        VolumeId,
        S3UploadPolicy,
        S3UploadPolicySignature;

    }

    public static enum VersioningStatus {
        Enabled,
        Disabled,
        Suspended;

    }

    public static enum X_AMZ_GRANT {
        READ("x-amz-grant-read"),
        WRITE("x-amz-grant-write"),
        READ_ACP("x-amz-grant-read-acp"),
        WRITE_ACP("x-amz-grant-write-acp"),
        FULL_CONTROL("x-amz-grant-full-control");

        private final String header;

        private X_AMZ_GRANT(String header) {
            this.header = header;
        }

        public String toString() {
            return this.header;
        }
    }

    public static enum Permission {
        READ,
        WRITE,
        READ_ACP,
        WRITE_ACP,
        FULL_CONTROL;

    }

    public static enum STORAGE_CLASS {
        STANDARD,
        REDUCED_REDUNDANCY;

    }

    public static enum CannedACL {
        private_only{

            public String toString() {
                return "private";
            }
        }
        ,
        public_read{

            public String toString() {
                return "public-read";
            }
        }
        ,
        public_read_write{

            public String toString() {
                return "public-read-write";
            }
        }
        ,
        authenticated_read{

            public String toString() {
                return "authenticated-read";
            }
        }
        ,
        bucket_owner_read{

            public String toString() {
                return "bucket-owner-read";
            }
        }
        ,
        bucket_owner_full_control{

            public String toString() {
                return "bucket-owner-full-control";
            }
        }
        ,
        log_delivery_write{

            public String toString() {
                return "log-delivery-write";
            }
        }
        ,
        aws_exec_read{

            public String toString() {
                return "aws-exec-read";
            }
        }
        ,
        ec2_bundle_read{

            public String toString() {
                return "ec2-bundle-read";
            }
        };

    }

    public static enum S3_GROUP {
        ALL_USERS_GROUP{

            public String toString() {
                return "http://acs.amazonaws.com/groups/global/AllUsers";
            }
        }
        ,
        AUTHENTICATED_USERS_GROUP{

            public String toString() {
                return "http://acs.amazonaws.com/groups/global/AuthenticatedUsers";
            }
        }
        ,
        LOGGING_GROUP{

            public String toString() {
                return "http://acs.amazonaws.com/groups/s3/LogDelivery";
            }
        }
        ,
        AWS_EXEC_READ{

            public String toString() {
                return "http://acs.amazonaws.com/groups/s3/zateam";
            }
        }
        ,
        EC2_BUNDLE_READ{

            public String toString() {
                return "http://acs.amazonaws.com/groups/s3/ec2-bundle";
            }
        };

    }
}

