/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.util;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.crypto.Ciphers;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.objectstorage.exceptions.ObjectStorageException;
import com.eucalyptus.objectstorage.msgs.HeadObjectResponseType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataResponseType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageErrorMessageType;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Internets;
import com.google.common.base.Strings;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import edu.ucsb.eucalyptus.msgs.ExceptionResponseType;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import org.bouncycastle.util.encoders.Base64;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferIndexFinder;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class OSGUtil {
    public static BaseMessage convertErrorMessage(ExceptionResponseType errorMessage) {
        Throwable ex = errorMessage.getException();
        String correlationId = errorMessage.getCorrelationId();
        BaseMessage errMsg = null;
        errMsg = OSGUtil.convertException(correlationId, ex);
        if (errMsg == null) {
            errMsg = errorMessage;
        }
        return errMsg;
    }

    public static BaseMessage convertErrorMessage(EucalyptusErrorMessageType errorMessage) {
        Throwable ex = errorMessage.getException();
        String correlationId = errorMessage.getCorrelationId();
        BaseMessage errMsg = null;
        errMsg = OSGUtil.convertException(correlationId, ex);
        if (errMsg == null) {
            errMsg = errorMessage;
        }
        return errMsg;
    }

    private static BaseMessage convertException(String correlationId, Throwable ex) {
        if (ex instanceof ObjectStorageException) {
            ObjectStorageException e = (ObjectStorageException)((Object)ex);
            ObjectStorageErrorMessageType errMsg = new ObjectStorageErrorMessageType(e.getMessage(), e.getCode(), e.getStatus(), e.getResourceType(), e.getResource(), correlationId, Internets.localHostAddress(), e.getLogData());
            errMsg.setCorrelationId(correlationId);
            return errMsg;
        }
        return null;
    }

    public static String URLdecode(String objectKey) throws UnsupportedEncodingException {
        return URLDecoder.decode(objectKey, "UTF-8");
    }

    public static String[] getTarget(String operationPath) {
        String[] parts;
        if ((operationPath = operationPath.replaceAll("^/{2,}", "/")).startsWith("/")) {
            operationPath = operationPath.substring(1);
        }
        if ((parts = operationPath.split("/", 2)) != null) {
            if (parts.length == 1 && Strings.isNullOrEmpty((String)parts[0])) {
                return null;
            }
            if (parts.length == 2 && Strings.isNullOrEmpty((String)parts[1])) {
                return new String[]{parts[0]};
            }
        }
        return parts;
    }

    public static int findFirstMatchInBuffer(ChannelBuffer buffer, int start, byte[] bytesToFind) {
        return buffer.indexOf(start, buffer.readableBytes(), (ChannelBufferIndexFinder)new ByteMatcherBeginningIndexFinder(bytesToFind));
    }

    public static int findLastMatchInBuffer(ChannelBuffer buffer, int start, byte[] bytesToFind) {
        return buffer.indexOf(buffer.readableBytes(), start, (ChannelBufferIndexFinder)new ByteMatcherBeginningIndexFinder(bytesToFind));
    }

    public static String encryptWithComponentPublicKey(Class<? extends ComponentId> componentClass, String data) throws EucalyptusCloudException {
        try {
            PublicKey clcPublicKey = SystemCredentials.lookup(componentClass).getCertificate().getPublicKey();
            Cipher cipher = Ciphers.RSA_PKCS1.get();
            cipher.init(1, (Key)clcPublicKey, (SecureRandom)Crypto.getSecureRandomSupplier().get());
            return new String(Base64.encode((byte[])cipher.doFinal(data.getBytes("UTF-8"))));
        }
        catch (Exception e) {
            throw new EucalyptusCloudException("Unable to encrypt data: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String decryptWithComponentPrivateKey(Class<? extends ComponentId> componentClass, String data) throws EucalyptusCloudException {
        PrivateKey clcPrivateKey = SystemCredentials.lookup(componentClass).getPrivateKey();
        try {
            Cipher cipher = Ciphers.RSA_PKCS1.get();
            cipher.init(2, (Key)clcPrivateKey, (SecureRandom)Crypto.getSecureRandomSupplier().get());
            return new String(cipher.doFinal(Base64.decode((String)data)));
        }
        catch (Exception ex) {
            throw new EucalyptusCloudException("Unable to decrypt data with cloud private key", (Throwable)ex);
        }
    }

    public static void addCopiedHeadersToResponse(HttpResponse httpResponse, ObjectStorageDataResponseType osgResponse) {
        if (osgResponse instanceof HeadObjectResponseType && osgResponse.getContentDisposition() != null && !"".equals(osgResponse.getContentDisposition())) {
            httpResponse.addHeader("Content-Disposition", (Object)osgResponse.getContentDisposition());
        }
        if (osgResponse.getContentEncoding() != null && !"".equals(osgResponse.getContentEncoding())) {
            httpResponse.addHeader("Content-Encoding", (Object)osgResponse.getContentEncoding());
        }
        if (osgResponse.getCacheControl() != null && !"".equals(osgResponse.getCacheControl())) {
            httpResponse.addHeader("Cache-Control", (Object)osgResponse.getCacheControl());
        }
        if (osgResponse.getExpires() != null && !"".equals(osgResponse.getExpires())) {
            httpResponse.addHeader("Expires", (Object)osgResponse.getExpires());
        }
    }

    public static class ByteMatcherBeginningIndexFinder
    implements ChannelBufferIndexFinder {
        private byte[] toMatch;

        public ByteMatcherBeginningIndexFinder(byte[] bytesToFind) {
            this.toMatch = bytesToFind;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean find(ChannelBuffer channelBuffer, int i) {
            boolean bl;
            channelBuffer.markReaderIndex();
            try {
                int matchedCount = 0;
                if (i + this.toMatch.length > channelBuffer.readableBytes()) {
                    boolean bl2 = false;
                    return bl2;
                }
                int j = i;
                while (j - i < this.toMatch.length) {
                    if (channelBuffer.getByte(j) != this.toMatch[j - i]) {
                        boolean bl3 = false;
                        return bl3;
                    }
                    ++matchedCount;
                    ++j;
                }
                bl = matchedCount == this.toMatch.length;
                return bl;
            }
            catch (IndexOutOfBoundsException e) {
                bl = false;
                return bl;
            }
            finally {
                channelBuffer.resetReaderIndex();
            }
        }
    }
}

