/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.util;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidArgumentException;
import com.eucalyptus.objectstorage.exceptions.s3.UnresolvableGrantByEmailAddressException;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.storage.msgs.s3.AccessControlList;
import com.eucalyptus.storage.msgs.s3.AccessControlPolicy;
import com.eucalyptus.storage.msgs.s3.CanonicalUser;
import com.eucalyptus.storage.msgs.s3.Grant;
import com.eucalyptus.storage.msgs.s3.Grantee;
import com.eucalyptus.storage.msgs.s3.Group;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class AclUtils {
    private static final Logger LOG = Logger.getLogger(AclUtils.class);
    private static final HashMap<String, Function<OwnerIdPair, List<Grant>>> cannedAclMap = new HashMap();
    private static final HashMap<String, ObjectStorageProperties.S3_GROUP> groupUriMap = new HashMap();
    private static List<CanonicalIdChecker> canonicalIdCheckers;

    public static boolean isValidCannedAcl(String candidateAcl) {
        return cannedAclMap.containsKey(candidateAcl);
    }

    public static boolean isUserMemberOfGroup(String userId, String groupId) {
        if (Strings.isNullOrEmpty((String)groupId)) {
            return false;
        }
        try {
            ObjectStorageProperties.S3_GROUP group = groupUriMap.get(groupId);
            return group != null && AclUtils.isUserMember(userId, group);
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)("Unknown group id requested for membership check: " + groupId));
            return false;
        }
    }

    public static boolean isUserMember(String userId, ObjectStorageProperties.S3_GROUP group) {
        if (group == null) {
            return false;
        }
        if (ObjectStorageProperties.S3_GROUP.ALL_USERS_GROUP.equals((Object)group)) {
            return true;
        }
        if (ObjectStorageProperties.S3_GROUP.AUTHENTICATED_USERS_GROUP.equals((Object)group) && !Strings.isNullOrEmpty((String)userId) && !userId.equals(Principals.nobodyUser().getUserId())) {
            return true;
        }
        boolean isSystemAdmin = false;
        try {
            isSystemAdmin = Principals.systemUser().getUserId().equals(userId) || Accounts.lookupSystemAdmin().getUserId().equals(userId);
        }
        catch (AuthException e) {
            LOG.debug((Object)"Got auth exception trying to lookup system admin user for group membership check in ec2-bundle-read", (Throwable)e);
        }
        boolean isAWSExecReadUser = false;
        try {
            isAWSExecReadUser = Accounts.lookupAwsExecReadAdmin((boolean)false).getUserId().equals(userId);
        }
        catch (AuthException e) {
            LOG.debug((Object)"Got auth exception trying to lookup aws-exec-read admin user for group membership check in ec2-bundle-read", (Throwable)e);
        }
        if (ObjectStorageProperties.S3_GROUP.AWS_EXEC_READ.equals((Object)group) && isAWSExecReadUser) {
            return true;
        }
        if (ObjectStorageProperties.S3_GROUP.EC2_BUNDLE_READ.equals((Object)group) && isSystemAdmin) {
            return true;
        }
        return ObjectStorageProperties.S3_GROUP.LOGGING_GROUP.equals((Object)group) && isSystemAdmin;
    }

    public static ObjectStorageProperties.S3_GROUP getGroupFromUri(String uri) throws NoSuchElementException {
        ObjectStorageProperties.S3_GROUP foundGroup = groupUriMap.get(uri);
        if (foundGroup == null) {
            throw new NoSuchElementException(uri);
        }
        return foundGroup;
    }

    public static AccessControlList expandCannedAcl(@Nonnull AccessControlList msgAcl, @Nullable String bucketOwnerCanonicalId, @Nullable String objectOwnerCanonicalId) throws EucalyptusCloudException {
        if (msgAcl == null) {
            throw new IllegalArgumentException("Null list received");
        }
        AccessControlList outputList = new AccessControlList();
        if (outputList.getGrants() == null) {
            outputList.setGrants(new ArrayList());
        }
        OwnerIdPair owners = new OwnerIdPair(bucketOwnerCanonicalId, objectOwnerCanonicalId);
        String entryValue = null;
        for (Grant msgGrant : msgAcl.getGrants()) {
            entryValue = msgGrant.getPermission();
            try {
                if (cannedAclMap.containsKey(entryValue)) {
                    outputList.getGrants().addAll((Collection)cannedAclMap.get(entryValue).apply((Object)owners));
                    continue;
                }
                outputList.getGrants().add(msgGrant);
            }
            catch (Exception e) {
                throw new EucalyptusCloudException("Failed generating the full ACL from canned ACL", (Throwable)e);
            }
        }
        return outputList;
    }

    public static CanonicalUser buildCanonicalUser(Account accnt) {
        return new CanonicalUser(accnt.getCanonicalId(), accnt.getName());
    }

    public static AccessControlPolicy processNewResourcePolicy(@Nonnull User requestUser, @Nullable AccessControlPolicy policy, @Nullable String bucketOwnerCanonicalId) throws Exception {
        AccessControlPolicy acPolicy = null;
        acPolicy = policy != null ? policy : new AccessControlPolicy();
        if (acPolicy.getOwner() == null) {
            acPolicy.setOwner(AclUtils.buildCanonicalUser(requestUser.getAccount()));
        }
        if (acPolicy.getAccessControlList() == null) {
            acPolicy.setAccessControlList(new AccessControlList());
        }
        if (acPolicy.getAccessControlList().getGrants() == null || acPolicy.getAccessControlList().getGrants().size() == 0) {
            acPolicy.getAccessControlList().getGrants().add(new Grant(new Grantee(AclUtils.buildCanonicalUser(requestUser.getAccount())), ObjectStorageProperties.Permission.FULL_CONTROL.toString()));
        }
        if (bucketOwnerCanonicalId != null) {
            acPolicy.setAccessControlList(AclUtils.expandCannedAcl(acPolicy.getAccessControlList(), bucketOwnerCanonicalId, requestUser.getAccount().getCanonicalId()));
        } else {
            acPolicy.setAccessControlList(AclUtils.expandCannedAcl(acPolicy.getAccessControlList(), requestUser.getAccount().getCanonicalId(), null));
        }
        return acPolicy;
    }

    public static AccessControlList scrubAcl(AccessControlList acl) {
        AccessControlList scrubbed = new AccessControlList();
        if (acl == null || acl.getGrants() == null || acl.getGrants().size() == 0) {
            return scrubbed;
        }
        String canonicalId = null;
        for (Grant g : acl.getGrants()) {
            Grantee grantee = g.getGrantee();
            if (grantee == null) continue;
            CanonicalUser canonicalUser = grantee.getCanonicalUser();
            Group group = grantee.getGroup();
            String email = grantee.getEmailAddress();
            String string = canonicalId = canonicalUser == null ? null : AclUtils.resolveCanonicalId(canonicalUser.getID());
            if (canonicalId == null) {
                try {
                    User user = Accounts.lookupUserByEmailAddress((String)email);
                    if (user != null && user.isAccountAdmin() && user.getAccount() != null) {
                        canonicalId = user.getAccount().getCanonicalId();
                    }
                }
                catch (AuthException user) {
                    // empty catch block
                }
            }
            if (canonicalId == null && group != null && !Strings.isNullOrEmpty((String)group.getUri())) {
                ObjectStorageProperties.S3_GROUP foundGroup = AclUtils.getGroupFromUri(group.getUri());
                if (foundGroup == null) {
                    throw new NoSuchElementException("URI: " + group.getUri() + " not found in group map");
                }
                canonicalId = group.getUri();
            }
            if (email != null && !"".equals(email) && canonicalId == null) {
                UnresolvableGrantByEmailAddressException ugbeae = new UnresolvableGrantByEmailAddressException();
                ugbeae.setEmailAddress(email);
                throw new RuntimeException((Throwable)((Object)ugbeae));
            }
            if (canonicalId == null) {
                InvalidArgumentException iae = new InvalidArgumentException();
                iae.setMessage("Invalid id");
                iae.setArgumentName("CanonicalUser/ID");
                iae.setArgumentValue(canonicalUser.getID());
                throw new RuntimeException((Throwable)((Object)iae));
            }
            if (grantee.getCanonicalUser() == null) {
                grantee.setCanonicalUser(new CanonicalUser(canonicalId, ""));
                continue;
            }
            grantee.getCanonicalUser().setID(canonicalId);
        }
        return acl;
    }

    public static String resolveCanonicalId(String inputCanonicalId) {
        String resultCanonicalId = null;
        for (CanonicalIdChecker checker : canonicalIdCheckers) {
            resultCanonicalId = checker.check(inputCanonicalId);
            if (resultCanonicalId == null) continue;
            return resultCanonicalId;
        }
        return null;
    }

    static {
        cannedAclMap.put(ObjectStorageProperties.CannedACL.private_only.toString(), PrivateOnlyGrantBuilder.INSTANCE);
        cannedAclMap.put(ObjectStorageProperties.CannedACL.authenticated_read.toString(), AuthenticatedReadGrantBuilder.INSTANCE);
        cannedAclMap.put(ObjectStorageProperties.CannedACL.public_read.toString(), PublicReadGrantBuilder.INSTANCE);
        cannedAclMap.put(ObjectStorageProperties.CannedACL.public_read_write.toString(), PublicReadWriteGrantBuilder.INSTANCE);
        cannedAclMap.put(ObjectStorageProperties.CannedACL.aws_exec_read.toString(), AwsExecReadGrantBuilder.INSTANCE);
        cannedAclMap.put(ObjectStorageProperties.CannedACL.ec2_bundle_read.toString(), Ec2BundleReadGrantBuilder.INSTANCE);
        cannedAclMap.put(ObjectStorageProperties.CannedACL.bucket_owner_full_control.toString(), BucketOwnerFullControlGrantBuilder.INSTANCE);
        cannedAclMap.put(ObjectStorageProperties.CannedACL.bucket_owner_read.toString(), BucketOwnerReadGrantBuilder.INSTANCE);
        cannedAclMap.put(ObjectStorageProperties.CannedACL.log_delivery_write.toString(), LogDeliveryWriteGrantBuilder.INSTANCE);
        for (ObjectStorageProperties.S3_GROUP g : ObjectStorageProperties.S3_GROUP.values()) {
            groupUriMap.put(g.toString(), g);
        }
        canonicalIdCheckers = Lists.newArrayList((Object[])new CanonicalIdChecker[]{new CanonicalIdChecker(){

            @Override
            public String check(String id) {
                try {
                    Account account = Accounts.lookupAccountByCanonicalId((String)id);
                    return account.getCanonicalId();
                }
                catch (AuthException authEx) {
                    return null;
                }
            }
        }, new CanonicalIdChecker(){

            @Override
            public String check(String id) {
                try {
                    Account account = Accounts.lookupAccountById((String)id);
                    return account.getCanonicalId();
                }
                catch (AuthException authEx) {
                    return null;
                }
            }
        }, new CanonicalIdChecker(){

            @Override
            public String check(String id) {
                try {
                    User user = Accounts.lookupUserByEmailAddress((String)id);
                    if (user.isAccountAdmin()) {
                        return user.getAccount().getCanonicalId();
                    }
                    return null;
                }
                catch (AuthException authEx) {
                    return null;
                }
            }
        }});
    }

    private static interface CanonicalIdChecker {
        public String check(String var1);
    }

    protected static enum LogDeliveryWriteGrantBuilder implements Function<OwnerIdPair, List<Grant>>
    {
        INSTANCE;


        public List<Grant> apply(OwnerIdPair ownerIds) {
            List<Grant> logDeliveryWrite = PrivateOnlyGrantBuilder.INSTANCE.apply(ownerIds);
            Grantee logGroup = new Grantee();
            logGroup.setGroup(new Group(ObjectStorageProperties.S3_GROUP.LOGGING_GROUP.toString()));
            Grant loggingWriteGrant = new Grant();
            loggingWriteGrant.setPermission(ObjectStorageProperties.Permission.WRITE.toString());
            loggingWriteGrant.setGrantee(logGroup);
            Grant loggingReadAcpGrant = new Grant();
            loggingReadAcpGrant.setPermission(ObjectStorageProperties.Permission.READ_ACP.toString());
            loggingReadAcpGrant.setGrantee(logGroup);
            logDeliveryWrite.add(loggingWriteGrant);
            logDeliveryWrite.add(loggingReadAcpGrant);
            return logDeliveryWrite;
        }
    }

    protected static enum BucketOwnerReadGrantBuilder implements Function<OwnerIdPair, List<Grant>>
    {
        INSTANCE;


        public List<Grant> apply(OwnerIdPair ownerIds) {
            List<Grant> bucketOwnerRead = PrivateOnlyGrantBuilder.INSTANCE.apply(ownerIds);
            String canonicalId = ownerIds.getBucketOwnerCanonicalId();
            String displayName = "";
            try {
                displayName = Accounts.lookupAccountByCanonicalId((String)canonicalId).getName();
            }
            catch (AuthException e) {
                displayName = "";
            }
            Grantee bucketOwner = new Grantee();
            bucketOwner.setCanonicalUser(new CanonicalUser(canonicalId, displayName));
            Grant bucketOwnerGrant = new Grant();
            bucketOwnerGrant.setPermission(ObjectStorageProperties.Permission.READ.toString());
            bucketOwnerGrant.setGrantee(bucketOwner);
            bucketOwnerRead.add(bucketOwnerGrant);
            return bucketOwnerRead;
        }
    }

    protected static enum BucketOwnerFullControlGrantBuilder implements Function<OwnerIdPair, List<Grant>>
    {
        INSTANCE;


        public List<Grant> apply(OwnerIdPair ownerIds) {
            List<Grant> bucketOwnerFullControl = PrivateOnlyGrantBuilder.INSTANCE.apply(ownerIds);
            String canonicalId = ownerIds.getBucketOwnerCanonicalId();
            String displayName = "";
            try {
                displayName = Accounts.lookupAccountByCanonicalId((String)canonicalId).getName();
            }
            catch (AuthException e) {
                displayName = "";
            }
            Grantee bucketOwner = new Grantee();
            bucketOwner.setCanonicalUser(new CanonicalUser(canonicalId, displayName));
            Grant bucketOwnerGrant = new Grant();
            bucketOwnerGrant.setPermission(ObjectStorageProperties.Permission.FULL_CONTROL.toString());
            bucketOwnerGrant.setGrantee(bucketOwner);
            bucketOwnerFullControl.add(bucketOwnerGrant);
            return bucketOwnerFullControl;
        }
    }

    protected static enum Ec2BundleReadGrantBuilder implements Function<OwnerIdPair, List<Grant>>
    {
        INSTANCE;


        public List<Grant> apply(OwnerIdPair ownerIds) {
            List<Grant> grants = PrivateOnlyGrantBuilder.INSTANCE.apply(ownerIds);
            Grantee grantee = new Grantee();
            grantee.setGroup(new Group(ObjectStorageProperties.S3_GROUP.EC2_BUNDLE_READ.toString()));
            Grant grant = new Grant();
            grant.setPermission(ObjectStorageProperties.Permission.READ.toString());
            grant.setGrantee(grantee);
            grants.add(grant);
            return grants;
        }
    }

    protected static enum AwsExecReadGrantBuilder implements Function<OwnerIdPair, List<Grant>>
    {
        INSTANCE;


        public List<Grant> apply(OwnerIdPair ownerIds) {
            List<Grant> awsExecRead = PrivateOnlyGrantBuilder.INSTANCE.apply(ownerIds);
            Grantee execReadGroup = new Grantee();
            execReadGroup.setGroup(new Group(ObjectStorageProperties.S3_GROUP.AWS_EXEC_READ.toString()));
            Grant execReadGrant = new Grant();
            execReadGrant.setPermission(ObjectStorageProperties.Permission.READ.toString());
            execReadGrant.setGrantee(execReadGroup);
            awsExecRead.add(execReadGrant);
            return awsExecRead;
        }
    }

    protected static enum PublicReadWriteGrantBuilder implements Function<OwnerIdPair, List<Grant>>
    {
        INSTANCE;


        public List<Grant> apply(OwnerIdPair ownerIds) {
            List<Grant> publicReadWrite = PublicReadGrantBuilder.INSTANCE.apply(ownerIds);
            Grantee allUsers = new Grantee();
            allUsers.setGroup(new Group(ObjectStorageProperties.S3_GROUP.ALL_USERS_GROUP.toString()));
            Grant allUsersGrant = new Grant();
            allUsersGrant.setPermission(ObjectStorageProperties.Permission.WRITE.toString());
            allUsersGrant.setGrantee(allUsers);
            publicReadWrite.add(allUsersGrant);
            return publicReadWrite;
        }
    }

    protected static enum PublicReadGrantBuilder implements Function<OwnerIdPair, List<Grant>>
    {
        INSTANCE;


        public List<Grant> apply(OwnerIdPair ownerIds) {
            List<Grant> publicRead = PrivateOnlyGrantBuilder.INSTANCE.apply(ownerIds);
            Grantee allUsers = new Grantee();
            allUsers.setGroup(new Group(ObjectStorageProperties.S3_GROUP.ALL_USERS_GROUP.toString()));
            Grant allUsersGrant = new Grant();
            allUsersGrant.setPermission(ObjectStorageProperties.Permission.READ.toString());
            allUsersGrant.setGrantee(allUsers);
            publicRead.add(allUsersGrant);
            return publicRead;
        }
    }

    protected static enum AuthenticatedReadGrantBuilder implements Function<OwnerIdPair, List<Grant>>
    {
        INSTANCE;


        public List<Grant> apply(OwnerIdPair ownerIds) {
            List<Grant> authenticatedRead = PrivateOnlyGrantBuilder.INSTANCE.apply(ownerIds);
            Grantee authenticatedUsers = new Grantee();
            authenticatedUsers.setGroup(new Group(ObjectStorageProperties.S3_GROUP.AUTHENTICATED_USERS_GROUP.toString()));
            Grant authUsersGrant = new Grant();
            authUsersGrant.setPermission(ObjectStorageProperties.Permission.READ.toString());
            authUsersGrant.setGrantee(authenticatedUsers);
            authenticatedRead.add(authUsersGrant);
            return authenticatedRead;
        }
    }

    protected static enum PrivateOnlyGrantBuilder implements Function<OwnerIdPair, List<Grant>>
    {
        INSTANCE;


        public List<Grant> apply(OwnerIdPair ownerIds) {
            ArrayList<Grant> privateGrants = new ArrayList<Grant>();
            Grant ownerFullControl = new Grant();
            Grantee owner = new Grantee();
            String displayName = "";
            String ownerCanonicalId = null;
            ownerCanonicalId = !Strings.isNullOrEmpty((String)ownerIds.getObjectOwnerCanonicalId()) ? ownerIds.getObjectOwnerCanonicalId() : ownerIds.getBucketOwnerCanonicalId();
            try {
                displayName = Accounts.lookupAccountByCanonicalId((String)ownerCanonicalId).getName();
            }
            catch (AuthException e) {
                displayName = "";
            }
            owner.setCanonicalUser(new CanonicalUser(ownerCanonicalId, displayName));
            owner.setType("CanonicalUser");
            ownerFullControl.setGrantee(owner);
            ownerFullControl.setPermission(ObjectStorageProperties.Permission.FULL_CONTROL.toString());
            privateGrants.add(ownerFullControl);
            return privateGrants;
        }
    }

    public static class OwnerIdPair {
        private String bucketOwner;
        private String objectOwner;

        public OwnerIdPair(String bucketOwnerCanonicalId, String objectOwnerCanonicalId) {
            this.bucketOwner = bucketOwnerCanonicalId;
            this.objectOwner = objectOwnerCanonicalId;
        }

        public String getBucketOwnerCanonicalId() {
            return this.bucketOwner;
        }

        public String getObjectOwnerCanonicalId() {
            return this.objectOwner;
        }
    }
}

