/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.providers;

import com.amazonaws.auth.AWSCredentials;
import com.eucalyptus.objectstorage.client.OsgInternalS3Client;
import com.eucalyptus.objectstorage.entities.S3ProviderConfiguration;
import com.eucalyptus.storage.config.ConfigurationCache;
import java.util.Date;
import org.apache.commons.pool.PoolableObjectFactory;

public class PoolableProviderClientFactory
implements PoolableObjectFactory<OsgInternalS3Client> {
    private AWSCredentials requestUser;
    private String upstreamEndpoint;
    private boolean usePathStyle;
    private long checkIntervalInMs = 15L;

    public PoolableProviderClientFactory(AWSCredentials requestUser, String upstreamEndpoint, boolean usePathStyle) {
        this.requestUser = requestUser;
        this.upstreamEndpoint = upstreamEndpoint;
        this.usePathStyle = usePathStyle;
    }

    public OsgInternalS3Client makeObject() throws Exception {
        boolean useHttps = false;
        S3ProviderConfiguration providerConfig = (S3ProviderConfiguration)ConfigurationCache.getConfiguration(S3ProviderConfiguration.class);
        if (providerConfig != null && providerConfig.getS3UseHttps() != null && providerConfig.getS3UseHttps().booleanValue()) {
            useHttps = true;
        }
        OsgInternalS3Client osgInternalS3Client = new OsgInternalS3Client(this.requestUser, this.upstreamEndpoint, useHttps, providerConfig.getS3UseBackendDns());
        osgInternalS3Client.setUsePathStyle(this.usePathStyle);
        return osgInternalS3Client;
    }

    public void destroyObject(OsgInternalS3Client amazonS3Client) throws Exception {
        amazonS3Client.getS3Client().shutdown();
    }

    public boolean validateObject(OsgInternalS3Client amazonS3Client) {
        long instantiated;
        long now = new Date().getTime();
        return now - (instantiated = amazonS3Client.getInstantiated().getTime()) <= this.checkIntervalInMs || ((S3ProviderConfiguration)ConfigurationCache.getConfiguration(S3ProviderConfiguration.class)).getLastUpdateTimestamp().getTime() - instantiated <= 0L;
    }

    public void activateObject(OsgInternalS3Client amazonS3Client) throws Exception {
    }

    public void passivateObject(OsgInternalS3Client amazonS3Client) throws Exception {
    }
}

