/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.providers;

import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.objectstorage.entities.ObjectStorageGlobalConfiguration;
import com.eucalyptus.objectstorage.providers.ObjectStorageProviderClient;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ComputationException;
import com.google.common.collect.Maps;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class ObjectStorageProviders
extends ServiceJarDiscovery {
    private static Logger LOG = Logger.getLogger(ObjectStorageProviders.class);
    private static final String UNSET = "unset";
    private static final Map<String, Class> clients = Maps.newHashMap();
    private static final LoadingCache<String, ObjectStorageProviderClient> clientInstances = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, ObjectStorageProviderClient>(){

        public ObjectStorageProviderClient load(String arg0) {
            ObjectStorageProviderClient osp = (ObjectStorageProviderClient)Classes.newInstance(ObjectStorageProviders.lookupClient(arg0), (Object[])new Object[0]);
            try {
                osp.checkPreconditions();
                return osp;
            }
            catch (EucalyptusCloudException ex) {
                throw new ComputationException((Throwable)ex);
            }
        }
    });
    private static AtomicReference<String> lastClient = new AtomicReference();

    public boolean processClass(Class candidate) throws Exception {
        if (Ats.from((Object)candidate).has(ObjectStorageProviderClientProperty.class) && !Modifier.isAbstract(candidate.getModifiers()) && !Modifier.isInterface(candidate.getModifiers())) {
            ObjectStorageProviderClientProperty candidateType = (ObjectStorageProviderClientProperty)Ats.from((Object)candidate).get(ObjectStorageProviderClientProperty.class);
            String propName = candidateType.value();
            if (ObjectStorageProviderClient.class.isAssignableFrom(candidate)) {
                clients.put(propName, candidate);
            }
            return true;
        }
        return false;
    }

    public Double getPriority() {
        return 0.0;
    }

    public static ObjectStorageProviderClient getInstance() throws NoSuchElementException {
        if (lastClient.get() == null || UNSET.equals(lastClient.get())) {
            String providerClient = ObjectStorageProviders.lookupProviderClient();
            if (!Strings.isNullOrEmpty((String)providerClient)) {
                if (clients.containsKey(providerClient)) {
                    lastClient.set(providerClient);
                }
            } else {
                throw new NoSuchElementException("OSG object storage provider client not configured. Found property 'objectstorage.providerclient' empty or unset manager(" + lastClient + ").  Legal values are: " + Joiner.on((String)",").join(clients.keySet()));
            }
        }
        return (ObjectStorageProviderClient)clientInstances.getUnchecked((Object)lastClient.get());
    }

    private static String lookupProviderClient() {
        return ObjectStorageGlobalConfiguration.getConfiguration().getProviderClient();
    }

    public static ObjectStorageProviderClient getInstance(String propertyBackend) throws InstantiationException, IllegalAccessException, EucalyptusCloudException {
        if (clients.containsKey(propertyBackend)) {
            lastClient.set(propertyBackend);
        }
        return ObjectStorageProviders.getInstance();
    }

    public static Set<String> list() {
        return clients.keySet();
    }

    public static boolean contains(Object key) {
        return clients.containsKey(key);
    }

    public static synchronized void flushClientInstances() throws EucalyptusCloudException {
        LOG.debug((Object)"Flushing all object storage manager instances");
        clientInstances.invalidateAll();
        lastClient.set(UNSET);
    }

    public static synchronized void flushClientInstance(String key) throws EucalyptusCloudException {
        LOG.debug((Object)("Flusing block object manager instance: " + key));
        lastClient.set(UNSET);
        clientInstances.invalidate((Object)key);
    }

    public static Class<? extends ObjectStorageProviderClient> lookupClient(String arg0) {
        if (!clients.containsKey(arg0)) {
            throw new NoSuchElementException("Not a valid value:  " + arg0 + ".  Legal values are: " + Joiner.on((String)",").join(clients.keySet()));
        }
        return clients.get(arg0);
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ObjectStorageProviderClientProperty {
        public String value();
    }
}

