/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.policy;

import com.eucalyptus.auth.policy.ern.Ern;

public class S3ResourceName
extends Ern {
    private String bucket;
    private String object;

    public S3ResourceName(String bucket, String object) {
        this.bucket = bucket;
        this.object = object;
        this.vendor = "s3";
    }

    public boolean isBucket() {
        return this.object == null || "".equals(this.object);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("arn:aws:").append(this.getVendor()).append(":::").append(this.bucket);
        if (this.object != null) {
            sb.append(this.object);
        }
        return sb.toString();
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getObject() {
        return this.object;
    }

    public String getResourceType() {
        if (this.isBucket()) {
            return this.vendor + ":" + "bucket";
        }
        return this.vendor + ":" + "object";
    }

    public String getResourceName() {
        String resourceName = this.bucket;
        if (this.object != null) {
            resourceName = resourceName + this.object;
        }
        return resourceName;
    }
}

