/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.policy;

import com.eucalyptus.auth.policy.ern.Ern;
import com.eucalyptus.auth.policy.ern.ServiceErnBuilder;
import com.eucalyptus.objectstorage.policy.S3ResourceName;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONException;

public class S3ErnBuilder
extends ServiceErnBuilder {
    public static final Pattern RESOURCE_PATTERN = Pattern.compile("([^\\s/]+)(?:(/\\S+))?");
    public static final int ARN_PATTERNGROUP_S3_BUCKET = 1;
    public static final int ARN_PATTERNGROUP_S3_OBJECT = 2;

    public S3ErnBuilder() {
        super(Collections.singleton("s3"));
    }

    public Ern build(String ern, String service, String region, String account, String resource) throws JSONException {
        Matcher matcher = RESOURCE_PATTERN.matcher(resource);
        if (matcher.matches()) {
            String bucket = matcher.group(1);
            String object = matcher.group(2);
            return new S3ResourceName(bucket, object);
        }
        throw new JSONException("'" + ern + "' is not a valid ARN");
    }
}

