/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.msgs;

import com.eucalyptus.objectstorage.msgs.ObjectStorageDataMessage;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataQueue;
import com.eucalyptus.objectstorage.msgs.ObjectStorageMonitor;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class ObjectStorageDataMessenger {
    private static Logger LOG = Logger.getLogger(ObjectStorageDataMessenger.class);
    private static final int DATA_QUEUE_SIZE = 3;
    private ConcurrentHashMap<String, ConcurrentHashMap<String, ObjectStorageDataQueue<ObjectStorageDataMessage>>> queueMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ObjectStorageMonitor> monitorMap = new ConcurrentHashMap();

    public ObjectStorageDataQueue<ObjectStorageDataMessage> getQueue(String key1, String key2) {
        ObjectStorageDataQueue queue;
        ConcurrentHashMap<Object, Object> queues = this.queueMap.putIfAbsent(key1, new ConcurrentHashMap());
        if (queues == null) {
            queues = this.queueMap.get(key1);
        }
        if ((queue = queues.putIfAbsent(key2, new ObjectStorageDataQueue(3))) == null) {
            queue = (ObjectStorageDataQueue)queues.get(key2);
        }
        return queue;
    }

    public ObjectStorageDataQueue<ObjectStorageDataMessage> interruptAllAndGetQueue(String key1, String key2) {
        ConcurrentHashMap<String, ObjectStorageDataQueue<ObjectStorageDataMessage>> queues = this.queueMap.get(key1);
        if (queues != null) {
            for (ObjectStorageDataQueue<ObjectStorageDataMessage> queue : queues.values()) {
                queue.setInterrupted(true);
            }
        }
        return this.getQueue(key1, key2);
    }

    public void clearQueues(String key1) {
        ConcurrentHashMap<String, ObjectStorageDataQueue<ObjectStorageDataMessage>> queues = this.queueMap.get(key1);
        if (queues != null) {
            for (ObjectStorageDataQueue<ObjectStorageDataMessage> queue : queues.values()) {
                queue.setInterrupted(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueue(String key1, String key2) {
        ConcurrentHashMap<String, ObjectStorageDataQueue<ObjectStorageDataMessage>> queues;
        if (this.queueMap.containsKey(key1) && (queues = this.queueMap.get(key1)).containsKey(key2)) {
            queues.remove(key2);
            ConcurrentHashMap<String, ObjectStorageDataQueue<ObjectStorageDataMessage>> concurrentHashMap = queues;
            synchronized (concurrentHashMap) {
                if (queues.size() == 0) {
                    this.queueMap.remove(key1);
                }
            }
        }
    }

    public ObjectStorageMonitor getMonitor(String key) {
        ObjectStorageMonitor monitor = this.monitorMap.putIfAbsent(key, new ObjectStorageMonitor());
        if (monitor == null) {
            monitor = this.monitorMap.get(key);
        }
        return monitor;
    }

    public void removeMonitor(String key) {
        if (this.monitorMap.containsKey(key)) {
            this.monitorMap.remove(key);
        }
    }
}

