/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.entities.upgrade;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.DatabaseAuthProvider;
import com.eucalyptus.auth.api.AccountProvider;
import com.eucalyptus.auth.entities.AccountEntity;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.objectstorage.BucketState;
import com.eucalyptus.objectstorage.ObjectState;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.objectstorage.entities.Bucket;
import com.eucalyptus.objectstorage.entities.ObjectEntity;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.storage.msgs.s3.AccessControlList;
import com.eucalyptus.storage.msgs.s3.AccessControlPolicy;
import com.eucalyptus.storage.msgs.s3.CanonicalUser;
import com.eucalyptus.storage.msgs.s3.Grant;
import com.eucalyptus.storage.msgs.s3.Grantee;
import com.eucalyptus.storage.msgs.s3.Group;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.walrus.entities.BucketInfo;
import com.eucalyptus.walrus.entities.GrantInfo;
import com.eucalyptus.walrus.entities.ImageCacheInfo;
import com.eucalyptus.walrus.entities.ObjectInfo;
import com.eucalyptus.walrus.entities.WalrusSnapshotInfo;
import com.eucalyptus.walrus.util.WalrusProperties;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityTransaction;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ObjectStorage400Upgrade {
    private static Logger LOG = Logger.getLogger(ObjectStorage400Upgrade.class);
    private static Map<String, Account> accountIdAccountMap = Maps.newHashMap();
    private static Map<String, User> accountIdAdminMap = Maps.newHashMap();
    private static Map<String, User> userIdUserMap = Maps.newHashMap();
    private static Set<String> deletedAccountIds = Sets.newHashSet();
    private static Set<String> deletedUserIds = Sets.newHashSet();
    private static Set<String> deletedAdminAccountIds = Sets.newHashSet();
    private static Set<String> noCanonicalIdAccountIds = Sets.newHashSet();
    private static Map<String, Bucket> bucketMap = Maps.newHashMap();
    private static Set<String> walrusSnapshotBuckets = Sets.newHashSet();
    private static Set<String> walrusSnapshotObjects = Sets.newHashSet();
    private static Account eucalyptusAccount = null;
    private static User eucalyptusAdmin = null;
    private static Account blockStorageAccount = null;
    private static User blockStorageAdmin = null;
    private static final ArrayList<? extends UpgradeTask> upgrades = Lists.newArrayList((Object[])new Enum[]{Setup.INSTANCE, CopyBucketsToOSG.INSTANCE, CopyObjectsToOSG.INSTANCE, ModifyWalrusBuckets.INSTANCE, ModifyWalrusObjects.INSTANCE, FlushImageCache.INSTANCE});

    private static Account getEucalyptusAccount() throws Exception {
        if (eucalyptusAccount == null) {
            eucalyptusAccount = Accounts.lookupAccountByName((String)"eucalyptus");
        }
        return eucalyptusAccount;
    }

    private static User getEucalyptusAdmin() throws Exception {
        if (eucalyptusAdmin == null) {
            eucalyptusAdmin = ObjectStorage400Upgrade.getEucalyptusAccount().lookupAdmin();
        }
        return eucalyptusAdmin;
    }

    private static void createBlockStorageAccount() throws Exception {
        blockStorageAccount = Accounts.addSystemAccountWithAdmin((String)"(eucalyptus)blockstorage");
    }

    private static Account getBlockStorageAccount() throws Exception {
        if (blockStorageAccount == null) {
            ObjectStorage400Upgrade.createBlockStorageAccount();
        }
        return blockStorageAccount;
    }

    private static User getBlockStorageAdmin() throws Exception {
        if (blockStorageAdmin == null) {
            blockStorageAdmin = ObjectStorage400Upgrade.getBlockStorageAccount().lookupAdmin();
        }
        return blockStorageAdmin;
    }

    private static void populateSnapshotBucketsAndObjects() {
        EntityTransaction tran = Entities.get(WalrusSnapshotInfo.class);
        try {
            List walrusSnapshots = Entities.query((Object)new WalrusSnapshotInfo(), (boolean)Boolean.TRUE);
            for (WalrusSnapshotInfo walrusSnapshot : walrusSnapshots) {
                walrusSnapshotBuckets.add(walrusSnapshot.getSnapshotBucket());
                walrusSnapshotObjects.add(walrusSnapshot.getSnapshotId());
            }
            tran.commit();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to lookup snapshots stored in Walrus", (Throwable)e);
            tran.rollback();
            throw e;
        }
        finally {
            if (tran.isActive()) {
                tran.commit();
            }
        }
    }

    private static void generateCanonicaIDs() throws Exception {
        EntityTransaction tran = Entities.get(AccountEntity.class);
        try {
            List accounts = Entities.query((Object)new AccountEntity());
            if (accounts != null && accounts.size() > 0) {
                for (AccountEntity account : accounts) {
                    if (account.getCanonicalId() != null && !account.getCanonicalId().equals("")) continue;
                    account.populateCanonicalId();
                    LOG.debug((Object)("Assigning canonical id " + account.getCanonicalId() + " for account " + account.getAccountNumber()));
                }
            }
            tran.commit();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to generate and assign canonical ids", (Throwable)e);
            tran.rollback();
            throw e;
        }
        finally {
            if (tran.isActive()) {
                tran.commit();
            }
        }
    }

    private static ArrayList<Grant> getBucketGrants(BucketInfo walrusBucket) throws Exception {
        ArrayList<Grant> grants = new ArrayList<Grant>();
        walrusBucket.readPermissions(grants);
        grants = ObjectStorage400Upgrade.convertGrantInfosToGrants(grants, walrusBucket.getGrants());
        return grants;
    }

    private static ArrayList<Grant> getObjectGrants(ObjectInfo walrusObject) throws Exception {
        ArrayList<Grant> grants = new ArrayList<Grant>();
        walrusObject.readPermissions(grants);
        grants = ObjectStorage400Upgrade.convertGrantInfosToGrants(grants, walrusObject.getGrants());
        return grants;
    }

    private static ArrayList<Grant> convertGrantInfosToGrants(ArrayList<Grant> grants, List<GrantInfo> grantInfos) throws Exception {
        if (grants == null) {
            grants = new ArrayList();
        }
        if (grantInfos == null) {
            return grants;
        }
        for (GrantInfo grantInfo : grantInfos) {
            if (grantInfo.getGrantGroup() != null) {
                Group group = new Group(grantInfo.getGrantGroup());
                ObjectStorage400Upgrade.transferPermissions(grants, grantInfo, new Grantee(group));
                continue;
            }
            Account account = null;
            if (accountIdAccountMap.containsKey(grantInfo.getUserId())) {
                account = accountIdAccountMap.get(grantInfo.getUserId());
            } else {
                if (deletedAccountIds.contains(grantInfo.getUserId())) {
                    LOG.warn((Object)("Account ID " + grantInfo.getUserId() + " does not not exist. Skipping this grant"));
                    continue;
                }
                if (noCanonicalIdAccountIds.contains(grantInfo.getUserId())) {
                    LOG.warn((Object)("Account ID " + grantInfo.getUserId() + " does not not have a canonical ID. Skipping this grant"));
                    continue;
                }
                try {
                    account = Accounts.lookupAccountById((String)grantInfo.getUserId());
                    if (StringUtils.isBlank((String)grantInfo.getUserId())) {
                        LOG.warn((Object)("Account ID " + grantInfo.getUserId() + " does not not have a canonical ID. Skipping this grant"));
                        noCanonicalIdAccountIds.add(grantInfo.getUserId());
                        continue;
                    }
                    accountIdAccountMap.put(grantInfo.getUserId(), account);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Account ID " + grantInfo.getUserId() + " does not not exist. Skipping this grant"));
                    deletedAccountIds.add(grantInfo.getUserId());
                    continue;
                }
            }
            CanonicalUser user = new CanonicalUser(account.getCanonicalId(), account.getName());
            ObjectStorage400Upgrade.transferPermissions(grants, grantInfo, new Grantee(user));
        }
        return grants;
    }

    private static void transferPermissions(List<Grant> grants, GrantInfo grantInfo, Grantee grantee) {
        if (grantInfo.canRead() && grantInfo.canWrite() && grantInfo.canReadACP() && grantInfo.canWriteACP()) {
            grants.add(new Grant(grantee, ObjectStorageProperties.Permission.FULL_CONTROL.toString()));
            return;
        }
        if (grantInfo.canRead()) {
            grants.add(new Grant(grantee, ObjectStorageProperties.Permission.READ.toString()));
        }
        if (grantInfo.canWrite()) {
            grants.add(new Grant(grantee, ObjectStorageProperties.Permission.WRITE.toString()));
        }
        if (grantInfo.canReadACP()) {
            grants.add(new Grant(grantee, ObjectStorageProperties.Permission.READ_ACP.toString()));
        }
        if (grantInfo.canWriteACP()) {
            grants.add(new Grant(grantee, ObjectStorageProperties.Permission.WRITE_ACP.toString()));
        }
    }

    public static Function<BucketInfo, Bucket> bucketTransformationFunction() {
        return new Function<BucketInfo, Bucket>(){

            @Nullable
            public Bucket apply(@Nonnull BucketInfo walrusBucket) {
                Bucket osgBucket = null;
                try {
                    Account owningAccount = null;
                    User owningUser = null;
                    if (walrusSnapshotBuckets.contains(walrusBucket.getBucketName())) {
                        LOG.warn((Object)("Changing the ownership of snapshot bucket " + walrusBucket.getBucketName() + " to blockstorage system account"));
                        owningAccount = ObjectStorage400Upgrade.getBlockStorageAccount();
                        owningUser = ObjectStorage400Upgrade.getBlockStorageAdmin();
                    } else if (accountIdAccountMap.containsKey(walrusBucket.getOwnerId())) {
                        owningAccount = (Account)accountIdAccountMap.get(walrusBucket.getOwnerId());
                    } else if (deletedAccountIds.contains(walrusBucket.getOwnerId())) {
                        LOG.warn((Object)("Account ID " + walrusBucket.getOwnerId() + " does not not exist. Changing the ownership of bucket " + walrusBucket.getBucketName() + " to eucalyptus admin account"));
                        owningAccount = ObjectStorage400Upgrade.getEucalyptusAccount();
                        owningUser = ObjectStorage400Upgrade.getEucalyptusAdmin();
                    } else if (noCanonicalIdAccountIds.contains(walrusBucket.getOwnerId())) {
                        LOG.warn((Object)("Account ID " + walrusBucket.getOwnerId() + " does not have a canonical ID. Changing the ownership of bucket " + walrusBucket.getBucketName() + " to eucalyptus admin account"));
                        owningAccount = ObjectStorage400Upgrade.getEucalyptusAccount();
                        owningUser = ObjectStorage400Upgrade.getEucalyptusAdmin();
                    } else {
                        try {
                            owningAccount = Accounts.lookupAccountById((String)walrusBucket.getOwnerId());
                            if (StringUtils.isBlank((String)owningAccount.getCanonicalId())) {
                                LOG.warn((Object)("Account ID " + walrusBucket.getOwnerId() + " does not have a canonical ID. Changing the ownership of bucket " + walrusBucket.getBucketName() + " to eucalyptus admin account"));
                                owningAccount = ObjectStorage400Upgrade.getEucalyptusAccount();
                                owningUser = ObjectStorage400Upgrade.getEucalyptusAdmin();
                                noCanonicalIdAccountIds.add(walrusBucket.getOwnerId());
                            } else {
                                accountIdAccountMap.put(walrusBucket.getOwnerId(), owningAccount);
                            }
                        }
                        catch (AuthException e) {
                            LOG.warn((Object)("Account ID " + walrusBucket.getOwnerId() + " does not not exist. Changing the ownership of bucket " + walrusBucket.getBucketName() + " to eucalyptus admin account"));
                            owningAccount = ObjectStorage400Upgrade.getEucalyptusAccount();
                            owningUser = ObjectStorage400Upgrade.getEucalyptusAdmin();
                            deletedAccountIds.add(walrusBucket.getOwnerId());
                            deletedUserIds.add(walrusBucket.getUserId());
                        }
                    }
                    if (owningUser == null) {
                        if (userIdUserMap.containsKey(walrusBucket.getUserId())) {
                            owningUser = (User)userIdUserMap.get(walrusBucket.getUserId());
                        } else if (deletedUserIds.contains(walrusBucket.getUserId()) && accountIdAdminMap.containsKey(walrusBucket.getOwnerId())) {
                            LOG.warn((Object)("User ID " + walrusBucket.getUserId() + " does not exist. Changing the IAM ownership of bucket " + walrusBucket.getBucketName() + " to the account admin"));
                            owningUser = (User)accountIdAdminMap.get(walrusBucket.getOwnerId());
                        } else if (deletedUserIds.contains(walrusBucket.getUserId()) && deletedAdminAccountIds.contains(walrusBucket.getOwnerId())) {
                            LOG.warn((Object)("User ID " + walrusBucket.getUserId() + " and the account admin do not exist. Changing the IAM ownership of bucket " + walrusBucket.getBucketName() + " to the eucalyptus account admin"));
                            owningUser = ObjectStorage400Upgrade.getEucalyptusAdmin();
                        } else if (walrusBucket.getUserId() != null) {
                            try {
                                owningUser = Accounts.lookupUserById((String)walrusBucket.getUserId());
                                userIdUserMap.put(walrusBucket.getUserId(), owningUser);
                            }
                            catch (AuthException e) {
                                deletedUserIds.add(walrusBucket.getUserId());
                                try {
                                    owningUser = owningAccount.lookupAdmin();
                                    accountIdAdminMap.put(walrusBucket.getOwnerId(), owningUser);
                                    LOG.warn((Object)("User ID " + walrusBucket.getUserId() + " does not exist. Changing the IAM ownership of bucket " + walrusBucket.getBucketName() + " to the account admin"));
                                }
                                catch (AuthException ie) {
                                    LOG.warn((Object)("User ID " + walrusBucket.getUserId() + " and the account admin do not exist. Changing the IAM ownership of bucket " + walrusBucket.getBucketName() + " to the eucalyptus account admin"));
                                    owningUser = ObjectStorage400Upgrade.getEucalyptusAdmin();
                                    deletedAdminAccountIds.add(walrusBucket.getOwnerId());
                                }
                            }
                        } else if (accountIdAdminMap.containsKey(walrusBucket.getOwnerId())) {
                            LOG.warn((Object)("No user ID listed for bucket " + walrusBucket.getBucketName() + ". Changing the IAM ownership of bucket to the account admin"));
                            owningUser = (User)accountIdAdminMap.get(walrusBucket.getBucketName());
                        } else {
                            try {
                                owningUser = owningAccount.lookupAdmin();
                                accountIdAdminMap.put(walrusBucket.getOwnerId(), owningUser);
                                LOG.warn((Object)("No user ID listed for bucket " + walrusBucket.getBucketName() + ". Changing the IAM ownership of bucket to the account admin"));
                            }
                            catch (AuthException ie) {
                                LOG.warn((Object)("No user ID listed for bucket " + walrusBucket.getBucketName() + " and account admin does not exist. Changing the IAM ownership of bucket to the eucalyptus account admin"));
                                owningUser = ObjectStorage400Upgrade.getEucalyptusAdmin();
                            }
                        }
                    }
                    osgBucket = new Bucket();
                    osgBucket.setBucketName(walrusBucket.getBucketName());
                    osgBucket.withUuid(walrusBucket.getBucketName());
                    osgBucket.setBucketSize(walrusBucket.getBucketSize());
                    osgBucket.setLocation(walrusBucket.getLocation());
                    osgBucket.setLoggingEnabled(walrusBucket.getLoggingEnabled());
                    osgBucket.setState(BucketState.extant);
                    osgBucket.setLastState(BucketState.creating);
                    osgBucket.setTargetBucket(walrusBucket.getTargetBucket());
                    osgBucket.setTargetPrefix(walrusBucket.getTargetPrefix());
                    osgBucket.setVersioning(ObjectStorageProperties.VersioningStatus.valueOf(walrusBucket.getVersioning()));
                    osgBucket.setOwnerCanonicalId(owningAccount.getCanonicalId());
                    osgBucket.setOwnerDisplayName(owningAccount.getName());
                    osgBucket.setOwnerIamUserId(owningUser.getUserId());
                    osgBucket.setOwnerIamUserDisplayName(owningUser.getName());
                    AccessControlList acl = new AccessControlList();
                    if (walrusSnapshotBuckets.contains(walrusBucket.getBucketName())) {
                        acl.setGrants(new ArrayList());
                    } else {
                        acl.setGrants(ObjectStorage400Upgrade.getBucketGrants(walrusBucket));
                    }
                    AccessControlPolicy acp = new AccessControlPolicy(new CanonicalUser(owningAccount.getCanonicalId(), owningAccount.getName()), acl);
                    osgBucket.setAcl(acp);
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to transform Walrus bucket " + walrusBucket.getBucketName() + " to objectstorage bucket"), (Throwable)e);
                    Exceptions.toUndeclared((String)("Failed to transform Walrus bucket " + walrusBucket.getBucketName() + " to objectstorage bucket"), (Throwable[])new Exception[]{e});
                }
                return osgBucket;
            }
        };
    }

    public static Function<ObjectInfo, ObjectEntity> objectTransformationFunction() {
        return new Function<ObjectInfo, ObjectEntity>(){

            @Nullable
            public ObjectEntity apply(@Nonnull ObjectInfo walrusObject) {
                ObjectEntity osgObject;
                block26: {
                    osgObject = null;
                    try {
                        Bucket osgBucket = null;
                        if (bucketMap.containsKey(walrusObject.getBucketName())) {
                            osgBucket = (Bucket)bucketMap.get(walrusObject.getBucketName());
                        } else {
                            osgBucket = (Bucket)Transactions.find((Object)new Bucket(walrusObject.getBucketName()));
                            bucketMap.put(walrusObject.getBucketName(), osgBucket);
                        }
                        osgObject = new ObjectEntity(osgBucket, walrusObject.getObjectKey(), walrusObject.getVersionId());
                        if (walrusObject.getDeleted() != null && walrusObject.getDeleted().booleanValue()) {
                            osgObject.setObjectUuid(UUID.randomUUID().toString());
                            osgObject.setStorageClass(ObjectStorageProperties.STORAGE_CLASS.STANDARD.toString());
                            osgObject.setObjectModifiedTimestamp(walrusObject.getLastModified());
                            osgObject.setIsDeleteMarker(Boolean.TRUE);
                            osgObject.setSize(0L);
                            osgObject.setIsLatest(walrusObject.getLast());
                            osgObject.setState(ObjectState.extant);
                            osgObject.setOwnerCanonicalId(osgBucket.getOwnerCanonicalId());
                            osgObject.setOwnerDisplayName(osgBucket.getOwnerDisplayName());
                            osgObject.setOwnerIamUserId(osgBucket.getOwnerIamUserId());
                            osgObject.setOwnerIamUserDisplayName(osgBucket.getOwnerIamUserDisplayName());
                            AccessControlList acl = new AccessControlList();
                            acl.setGrants(new ArrayList());
                            AccessControlPolicy acp = new AccessControlPolicy(new CanonicalUser(osgBucket.getOwnerCanonicalId(), osgBucket.getOwnerDisplayName()), acl);
                            osgObject.setAcl(acp);
                            break block26;
                        }
                        Account owningAccount = null;
                        User adminUser = null;
                        if (walrusSnapshotObjects.contains(walrusObject.getObjectKey())) {
                            LOG.warn((Object)("Changing the ownership of snapshot object " + walrusObject.getObjectKey() + " to blockstorage system account"));
                            owningAccount = ObjectStorage400Upgrade.getBlockStorageAccount();
                            adminUser = ObjectStorage400Upgrade.getBlockStorageAdmin();
                        } else if (accountIdAccountMap.containsKey(walrusObject.getOwnerId())) {
                            owningAccount = (Account)accountIdAccountMap.get(walrusObject.getOwnerId());
                        } else if (deletedAccountIds.contains(walrusObject.getOwnerId())) {
                            LOG.warn((Object)("Account ID " + walrusObject.getOwnerId() + " does not not exist. Changing the ownership of object " + walrusObject.getObjectKey() + " in bucket " + walrusObject.getBucketName() + " to eucalyptus admin account"));
                            owningAccount = ObjectStorage400Upgrade.getEucalyptusAccount();
                            adminUser = ObjectStorage400Upgrade.getEucalyptusAdmin();
                        } else if (noCanonicalIdAccountIds.contains(walrusObject.getOwnerId())) {
                            LOG.warn((Object)("Account ID " + walrusObject.getOwnerId() + " does not have a canonical ID. Changing the ownership of object " + walrusObject.getObjectKey() + " in bucket " + walrusObject.getBucketName() + " to eucalyptus admin account"));
                            owningAccount = ObjectStorage400Upgrade.getEucalyptusAccount();
                            adminUser = ObjectStorage400Upgrade.getEucalyptusAdmin();
                        } else {
                            try {
                                owningAccount = Accounts.lookupAccountById((String)walrusObject.getOwnerId());
                                if (StringUtils.isBlank((String)owningAccount.getCanonicalId())) {
                                    LOG.warn((Object)("Account ID " + walrusObject.getOwnerId() + " does not have a canonical ID. Changing the ownership of object " + walrusObject.getObjectKey() + " in bucket " + walrusObject.getBucketName() + " to eucalyptus admin account"));
                                    owningAccount = ObjectStorage400Upgrade.getEucalyptusAccount();
                                    adminUser = ObjectStorage400Upgrade.getEucalyptusAdmin();
                                    noCanonicalIdAccountIds.add(walrusObject.getOwnerId());
                                } else {
                                    accountIdAccountMap.put(walrusObject.getOwnerId(), owningAccount);
                                }
                            }
                            catch (AuthException e) {
                                LOG.warn((Object)("Account ID " + walrusObject.getOwnerId() + " does not not exist. Changing the ownership of object " + walrusObject.getObjectKey() + " in bucket " + walrusObject.getBucketName() + " to eucalyptus admin account"));
                                owningAccount = ObjectStorage400Upgrade.getEucalyptusAccount();
                                adminUser = ObjectStorage400Upgrade.getEucalyptusAdmin();
                                deletedAccountIds.add(walrusObject.getOwnerId());
                            }
                        }
                        if (adminUser == null) {
                            if (accountIdAdminMap.containsKey(walrusObject.getOwnerId())) {
                                adminUser = (User)accountIdAdminMap.get(walrusObject.getOwnerId());
                            } else if (deletedAdminAccountIds.contains(walrusObject.getOwnerId())) {
                                LOG.warn((Object)("Admin for account ID " + walrusObject.getOwnerId() + " does not exist. Changing the IAM ownership of object " + walrusObject.getObjectKey() + " in bucket " + walrusObject.getBucketName() + " to the eucalyptus account admin"));
                                adminUser = ObjectStorage400Upgrade.getEucalyptusAdmin();
                            } else {
                                try {
                                    adminUser = owningAccount.lookupAdmin();
                                    accountIdAdminMap.put(walrusObject.getOwnerId(), adminUser);
                                }
                                catch (AuthException e) {
                                    LOG.warn((Object)("Admin for account ID " + walrusObject.getOwnerId() + " does not exist. Changing the IAM ownership of object " + walrusObject.getObjectKey() + " in bucket " + walrusObject.getBucketName() + " to the eucalyptus account admin"));
                                    adminUser = ObjectStorage400Upgrade.getEucalyptusAdmin();
                                    deletedAdminAccountIds.add(walrusObject.getOwnerId());
                                }
                            }
                        }
                        osgObject.seteTag(walrusObject.getEtag());
                        osgObject.setIsDeleteMarker(Boolean.FALSE);
                        osgObject.setIsLatest(walrusObject.getLast());
                        osgObject.setObjectModifiedTimestamp(walrusObject.getLastModified());
                        osgObject.setObjectUuid(walrusObject.getObjectName());
                        osgObject.setSize(walrusObject.getSize());
                        osgObject.setState(ObjectState.extant);
                        osgObject.setLastState(ObjectState.creating);
                        osgObject.setStorageClass(walrusObject.getStorageClass());
                        osgObject.setOwnerCanonicalId(owningAccount.getCanonicalId());
                        osgObject.setOwnerDisplayName(owningAccount.getName());
                        osgObject.setOwnerIamUserId(adminUser.getUserId());
                        osgObject.setOwnerIamUserDisplayName(adminUser.getName());
                        AccessControlList acl = new AccessControlList();
                        if (walrusSnapshotObjects.contains(walrusObject.getObjectKey())) {
                            acl.setGrants(new ArrayList());
                        } else {
                            acl.setGrants(ObjectStorage400Upgrade.getObjectGrants(walrusObject));
                        }
                        AccessControlPolicy acp = new AccessControlPolicy(new CanonicalUser(owningAccount.getCanonicalId(), owningAccount.getName()), acl);
                        osgObject.setAcl(acp);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to transform Walrus object " + walrusObject.getObjectKey() + " to objectstorage object"), (Throwable)e);
                        Exceptions.toUndeclared((String)("Failed to transform Walrus object " + walrusObject.getObjectKey() + " to objectstorage object"), (Throwable[])new Exception[]{e});
                    }
                }
                return osgObject;
            }
        };
    }

    public static Function<ImageCacheInfo, ObjectEntity> imageToOSGObjectTransformation() {
        return new Function<ImageCacheInfo, ObjectEntity>(){

            @Nullable
            public ObjectEntity apply(@Nonnull ImageCacheInfo image) {
                ObjectEntity osgObject = null;
                try {
                    Bucket osgBucket = null;
                    if (bucketMap.containsKey(image.getBucketName())) {
                        osgBucket = (Bucket)bucketMap.get(image.getBucketName());
                    } else {
                        osgBucket = (Bucket)Transactions.find((Object)new Bucket(image.getBucketName()));
                        bucketMap.put(image.getBucketName(), osgBucket);
                    }
                    osgObject = new ObjectEntity(osgBucket, image.getManifestName(), "null");
                    osgObject.setIsDeleteMarker(Boolean.FALSE);
                    osgObject.setIsLatest(Boolean.TRUE);
                    osgObject.setObjectUuid(image.getImageName());
                    osgObject.setObjectModifiedTimestamp(new Date());
                    osgObject.setSize(image.getSize());
                    osgObject.setStorageClass(ObjectStorageProperties.STORAGE_CLASS.STANDARD.toString());
                    osgObject.setState(ObjectState.deleting);
                    osgObject.setLastState(ObjectState.extant);
                    osgObject.setOwnerCanonicalId(ObjectStorage400Upgrade.getEucalyptusAccount().getCanonicalId());
                    osgObject.setOwnerDisplayName(ObjectStorage400Upgrade.getEucalyptusAccount().getName());
                    osgObject.setOwnerIamUserDisplayName(ObjectStorage400Upgrade.getEucalyptusAdmin().getName());
                    osgObject.setOwnerIamUserId(ObjectStorage400Upgrade.getEucalyptusAdmin().getUserId());
                    AccessControlList acl = new AccessControlList();
                    acl.setGrants(new ArrayList());
                    AccessControlPolicy acp = new AccessControlPolicy(new CanonicalUser(osgObject.getOwnerCanonicalId(), osgObject.getOwnerDisplayName()), acl);
                    osgObject.setAcl(acp);
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to create objectstorage object for cached image " + image.getManifestName()), (Throwable)e);
                    Exceptions.toUndeclared((String)("Failed to create objectstorage object for cached image " + image.getManifestName()), (Throwable[])new Exception[]{e});
                }
                return osgObject;
            }
        };
    }

    public static Function<ImageCacheInfo, ObjectInfo> imageToWalrusObjectTransformation() {
        return new Function<ImageCacheInfo, ObjectInfo>(){

            @Nullable
            public ObjectInfo apply(@Nonnull ImageCacheInfo image) {
                ObjectInfo walrusObject = null;
                try {
                    walrusObject = new ObjectInfo(image.getBucketName(), image.getImageName());
                    walrusObject.setDeleted(Boolean.FALSE);
                    walrusObject.setLast(Boolean.TRUE);
                    walrusObject.setLastModified(new Date());
                    walrusObject.setObjectName(image.getImageName());
                    walrusObject.setOwnerId(ObjectStorage400Upgrade.getEucalyptusAccount().getAccountNumber());
                    walrusObject.setSize(image.getSize());
                    walrusObject.setStorageClass(ObjectStorageProperties.STORAGE_CLASS.STANDARD.toString());
                    walrusObject.setVersionId("null");
                    walrusObject.resetGlobalGrants();
                    ArrayList grantInfos = new ArrayList();
                    GrantInfo.setFullControl((String)walrusObject.getOwnerId(), grantInfos);
                    walrusObject.setGrants(grantInfos);
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to create Walrus object for cached image " + image.getManifestName()), (Throwable)e);
                    Exceptions.toUndeclared((String)("Failed to create Walrus object for cached image " + image.getManifestName()), (Throwable[])new Exception[]{e});
                }
                return walrusObject;
            }
        };
    }

    public static enum FlushImageCache implements UpgradeTask
    {
        INSTANCE;


        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply() throws Exception {
            EntityTransaction walrusImageTran = Entities.get(ImageCacheInfo.class);
            try {
                List images = Entities.query((Object)new ImageCacheInfo());
                if (images != null && !images.isEmpty()) {
                    EntityTransaction osgObjectTran = Entities.get(ObjectEntity.class);
                    EntityTransaction walrusObjectTran = Entities.get(ObjectInfo.class);
                    try {
                        for (ImageCacheInfo image : images) {
                            Entities.persist((Object)ObjectStorage400Upgrade.imageToOSGObjectTransformation().apply((Object)image));
                            Entities.persist((Object)ObjectStorage400Upgrade.imageToWalrusObjectTransformation().apply((Object)image));
                            Entities.delete((Object)image);
                        }
                        osgObjectTran.commit();
                        walrusObjectTran.commit();
                    }
                    catch (Exception e) {
                        osgObjectTran.rollback();
                        walrusObjectTran.rollback();
                        throw e;
                    }
                    finally {
                        if (osgObjectTran.isActive()) {
                            osgObjectTran.commit();
                        }
                        if (walrusObjectTran.isActive()) {
                            walrusObjectTran.commit();
                        }
                    }
                }
                walrusImageTran.commit();
            }
            catch (Exception e) {
                walrusImageTran.rollback();
                LOG.warn((Object)"Cannot flush cached images in Walrus due to an error. May have to be flushed manually");
            }
            finally {
                if (walrusImageTran.isActive()) {
                    walrusImageTran.commit();
                }
            }
        }
    }

    public static enum ModifyWalrusObjects implements UpgradeTask
    {
        INSTANCE;


        @Override
        public void apply() throws Exception {
            EntityTransaction tran = Entities.get(ObjectInfo.class);
            try {
                List walrusObjects = Entities.query((Object)new ObjectInfo());
                if (walrusObjects != null && !walrusObjects.isEmpty()) {
                    for (ObjectInfo walrusObject : walrusObjects) {
                        try {
                            if (walrusObject.getDeleted() != null && walrusObject.getDeleted().booleanValue()) {
                                LOG.info((Object)("Removing delete marker from Walrus for object " + walrusObject.getObjectKey() + " in bucket " + walrusObject.getBucketName() + " with version ID " + walrusObject.getVersionId()));
                                Entities.delete((Object)walrusObject);
                                continue;
                            }
                            walrusObject.setObjectKey(walrusObject.getObjectName());
                            walrusObject.setVersionId("null");
                            walrusObject.setLast(Boolean.TRUE);
                            walrusObject.setOwnerId(ObjectStorage400Upgrade.getEucalyptusAccount().getAccountNumber());
                            walrusObject.resetGlobalGrants();
                            ArrayList grantInfos = new ArrayList();
                            GrantInfo.setFullControl((String)walrusObject.getOwnerId(), grantInfos);
                            walrusObject.setGrants(grantInfos);
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Failed to modify Walrus object " + walrusObject.getObjectKey()), (Throwable)e);
                            throw e;
                        }
                    }
                }
                tran.commit();
            }
            catch (Exception e) {
                tran.rollback();
                throw e;
            }
            finally {
                if (tran.isActive()) {
                    tran.commit();
                }
            }
        }
    }

    public static enum ModifyWalrusBuckets implements UpgradeTask
    {
        INSTANCE;


        @Override
        public void apply() throws Exception {
            EntityTransaction tran = Entities.get(BucketInfo.class);
            try {
                List walrusBuckets = Entities.query((Object)new BucketInfo());
                if (walrusBuckets != null && !walrusBuckets.isEmpty()) {
                    for (BucketInfo walrusBucket : walrusBuckets) {
                        try {
                            walrusBucket.setOwnerId(ObjectStorage400Upgrade.getEucalyptusAccount().getAccountNumber());
                            walrusBucket.setUserId(ObjectStorage400Upgrade.getEucalyptusAdmin().getUserId());
                            walrusBucket.resetGlobalGrants();
                            ArrayList grantInfos = new ArrayList();
                            GrantInfo.setFullControl((String)walrusBucket.getOwnerId(), grantInfos);
                            walrusBucket.setGrants(grantInfos);
                            if (walrusBucket.getVersioning() == null || !WalrusProperties.VersioningStatus.Enabled.toString().equals(walrusBucket.getVersioning()) && !WalrusProperties.VersioningStatus.Suspended.toString().equals(walrusBucket.getVersioning())) continue;
                            walrusBucket.setVersioning(WalrusProperties.VersioningStatus.Disabled.toString());
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Failed to modify Walrus bucket " + walrusBucket.getBucketName()), (Throwable)e);
                            throw e;
                        }
                    }
                }
                tran.commit();
            }
            catch (Exception e) {
                tran.rollback();
                throw e;
            }
            finally {
                if (tran.isActive()) {
                    tran.commit();
                }
            }
        }
    }

    public static enum CopyObjectsToOSG implements UpgradeTask
    {
        INSTANCE;


        @Override
        public void apply() throws Exception {
            EntityTransaction osgTran = Entities.get(ObjectEntity.class);
            try {
                List osgObjects = Entities.query((Object)new ObjectEntity());
                if (osgObjects != null && osgObjects.isEmpty()) {
                    EntityTransaction walrusTran = Entities.get(ObjectInfo.class);
                    try {
                        List walrusObjects = Entities.query((Object)new ObjectInfo(), (boolean)Boolean.TRUE);
                        if (walrusObjects != null && !walrusObjects.isEmpty()) {
                            for (ObjectEntity osgObject : Lists.transform((List)walrusObjects, ObjectStorage400Upgrade.objectTransformationFunction())) {
                                Entities.persist((Object)osgObject);
                            }
                        }
                        walrusTran.commit();
                    }
                    catch (Exception e) {
                        walrusTran.rollback();
                        throw e;
                    }
                    finally {
                        if (walrusTran.isActive()) {
                            walrusTran.commit();
                        }
                    }
                }
                osgTran.commit();
            }
            catch (Exception e) {
                osgTran.rollback();
                throw e;
            }
            finally {
                if (osgTran.isActive()) {
                    osgTran.commit();
                }
            }
        }
    }

    public static enum CopyBucketsToOSG implements UpgradeTask
    {
        INSTANCE;


        @Override
        public void apply() throws Exception {
            EntityTransaction osgTran = Entities.get(Bucket.class);
            try {
                List osgBuckets = Entities.query((Object)new Bucket());
                if (osgBuckets != null && osgBuckets.isEmpty()) {
                    EntityTransaction walrusTran = Entities.get(BucketInfo.class);
                    try {
                        List walrusBuckets = Entities.query((Object)new BucketInfo(), (boolean)Boolean.TRUE);
                        if (walrusBuckets != null && !walrusBuckets.isEmpty()) {
                            ObjectStorage400Upgrade.populateSnapshotBucketsAndObjects();
                            for (Bucket osgBucket : Lists.transform((List)walrusBuckets, ObjectStorage400Upgrade.bucketTransformationFunction())) {
                                Entities.persist((Object)osgBucket);
                            }
                        }
                        walrusTran.commit();
                    }
                    catch (Exception e) {
                        walrusTran.rollback();
                        throw e;
                    }
                    finally {
                        if (walrusTran.isActive()) {
                            walrusTran.commit();
                        }
                    }
                }
                osgTran.commit();
            }
            catch (Exception e) {
                osgTran.rollback();
                throw e;
            }
            finally {
                if (osgTran.isActive()) {
                    osgTran.commit();
                }
            }
        }
    }

    public static enum Setup implements UpgradeTask
    {
        INSTANCE;


        @Override
        public void apply() throws Exception {
            DatabaseAuthProvider dbAuth = new DatabaseAuthProvider();
            Accounts.setAccountProvider((AccountProvider)dbAuth);
            ObjectStorage400Upgrade.createBlockStorageAccount();
            ObjectStorage400Upgrade.generateCanonicaIDs();
        }
    }

    @Upgrades.EntityUpgrade(entities={ObjectEntity.class}, since=Upgrades.Version.v4_0_0, value=ObjectStorage.class)
    public static enum OSGUpgrade implements Predicate<Class>
    {
        INSTANCE;


        public boolean apply(@Nullable Class arg0) {
            return Iterators.all(upgrades.iterator(), (Predicate)new Predicate<UpgradeTask>(){

                public boolean apply(UpgradeTask task) {
                    try {
                        LOG.info((Object)("Executing objectstorage upgrade task: " + task.getClass().getSimpleName()));
                        task.apply();
                        return true;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Upgrade task failed: " + task.getClass().getSimpleName()));
                        throw Exceptions.toUndeclared((String)("Objectstorage upgrade failed due to an error in upgrade task: " + task.getClass().getSimpleName()), (Throwable[])new Exception[]{e});
                    }
                }
            });
        }
    }

    public static interface UpgradeTask {
        public void apply() throws Exception;
    }
}

