/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.entities;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.objectstorage.util.OSGUtil;
import com.eucalyptus.storage.config.CacheableConfiguration;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import java.util.NoSuchElementException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_osg")
@Table(name="s3provider_config")
@ConfigurableClass(root="objectstorage.s3provider", alias="backendconfig", description="Configuration for S3-compatible backend", singleton=true)
public class S3ProviderConfiguration
extends AbstractPersistent
implements CacheableConfiguration<S3ProviderConfiguration> {
    @Transient
    private static final String DEFAULT_S3_ENDPOINT = "uninitialized-s3-endpoint";
    @Transient
    private static final Logger LOG = Logger.getLogger(S3ProviderConfiguration.class);
    @Transient
    private static final boolean DEFAULT_BACKEND_DNS = false;
    @Transient
    private static final Boolean DEFAULT_BACKEND_HTTPS = false;
    @ConfigurableField(description="External S3 endpoint.", displayName="s3_endpoint", initial="s3.amazonaws.com")
    @Column(name="endpoint")
    protected String S3Endpoint;
    @ConfigurableField(description="Local Store S3 Access Key.", displayName="s3_access_key", type=ConfigurableFieldType.KEYVALUEHIDDEN)
    @Column(name="access_key")
    protected String S3AccessKey;
    @ConfigurableField(description="Local Store S3 Secret Key.", displayName="s3_secret_key", type=ConfigurableFieldType.KEYVALUEHIDDEN)
    @Column(name="secret_key")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    protected String S3SecretKey;
    @ConfigurableField(description="Use HTTPS for communication to service backend.", displayName="use_https", initial="false")
    @Column(name="use_https")
    protected Boolean S3UseHttps;
    @ConfigurableField(description="Use DNS virtual-hosted-style bucket names for communication to service backend.", displayName="use_backend_dns", initial="false")
    @Column(name="use_backend_dns")
    protected Boolean S3UseBackendDns;

    public boolean getS3UseBackendDns() {
        return this.S3UseBackendDns;
    }

    public void setS3UserBackendDns(boolean useDns) {
        this.S3UseBackendDns = useDns;
    }

    public String getS3AccessKey() {
        return this.S3AccessKey;
    }

    public void setS3AccessKey(String s3AccessKey) {
        this.S3AccessKey = s3AccessKey;
    }

    public String getS3SecretKey() throws Exception {
        if (this.S3SecretKey != null) {
            try {
                return OSGUtil.decryptWithComponentPrivateKey(ObjectStorage.class, this.S3SecretKey);
            }
            catch (EucalyptusCloudException ex) {
                LOG.error((Object)ex);
                throw ex;
            }
        }
        return this.S3SecretKey;
    }

    public void setS3SecretKey(String s3SecretKey) throws Exception {
        if (s3SecretKey != null) {
            try {
                s3SecretKey = OSGUtil.encryptWithComponentPublicKey(ObjectStorage.class, s3SecretKey);
            }
            catch (EucalyptusCloudException ex) {
                LOG.error((Object)ex);
                throw ex;
            }
        }
        this.S3SecretKey = s3SecretKey;
    }

    public Boolean getS3UseHttps() {
        return this.S3UseHttps;
    }

    public void setS3UseHttps(Boolean s3UseHttps) {
        this.S3UseHttps = s3UseHttps;
    }

    public String getS3Endpoint() {
        return this.S3Endpoint;
    }

    public void setS3Endpoint(String endPoint) {
        this.S3Endpoint = endPoint;
    }

    public S3ProviderConfiguration initializeDefaults() {
        this.setS3Endpoint(DEFAULT_S3_ENDPOINT);
        this.setS3UserBackendDns(false);
        this.setS3UseHttps(DEFAULT_BACKEND_HTTPS);
        return this;
    }

    public static S3ProviderConfiguration getS3ProviderConfiguration() {
        try {
            try {
                return (S3ProviderConfiguration)((Object)Transactions.find((Object)((Object)new S3ProviderConfiguration())));
            }
            catch (NoSuchElementException enf) {
                LOG.info((Object)"No extant S3 provider configuration found. Initializing defaults");
                return (S3ProviderConfiguration)((Object)Transactions.saveDirect((Object)((Object)new S3ProviderConfiguration().initializeDefaults())));
            }
        }
        catch (Throwable f) {
            LOG.error((Object)"exception occurred while retrieving S3 provider configuration", f);
            throw Exceptions.toUndeclared((String)"Error getting/initializing s3 provider configuration", (Throwable[])new Throwable[]{f});
        }
    }

    public S3ProviderConfiguration getLatest() {
        return S3ProviderConfiguration.getS3ProviderConfiguration();
    }
}

