/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.entities;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.entities.AbstractStatefulStacklessPersistent;
import com.eucalyptus.objectstorage.util.AclUtils;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.storage.msgs.s3.AccessControlList;
import com.eucalyptus.storage.msgs.s3.AccessControlPolicy;
import com.eucalyptus.storage.msgs.s3.CanonicalUser;
import com.eucalyptus.storage.msgs.s3.Grant;
import com.eucalyptus.storage.msgs.s3.Grantee;
import com.eucalyptus.storage.msgs.s3.Group;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.Transient;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Type;

@MappedSuperclass
public abstract class S3AccessControlledEntity<STATE extends Enum<STATE>>
extends AbstractStatefulStacklessPersistent<STATE> {
    @Transient
    private static final Logger LOG = Logger.getLogger(S3AccessControlledEntity.class);
    @Column(name="owner_iam_user_displayname")
    protected String ownerIamUserDisplayName;
    @Column(name="owner_canonical_id", nullable=false, length=64)
    protected String ownerCanonicalId;
    @Column(name="owner_iam_user_id", nullable=false, length=64)
    protected String ownerIamUserId;
    @Column(name="acl", nullable=false)
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String acl;
    @Column(name="owner_displayname")
    protected String ownerDisplayName;
    @Transient
    private Map<String, Integer> decodedAcl = null;

    @PostLoad
    @PrePersist
    public void nullChecks() {
        if (this.acl == null) {
            this.acl = "{}";
        }
    }

    public abstract String getResourceFullName();

    public String getOwnerCanonicalId() {
        return this.ownerCanonicalId;
    }

    public void setOwnerCanonicalId(String ownerCanonicalId) {
        this.ownerCanonicalId = ownerCanonicalId;
    }

    public String getOwnerIamUserId() {
        return this.ownerIamUserId;
    }

    public void setOwnerIamUserId(String ownerIamUserId) {
        this.ownerIamUserId = ownerIamUserId;
    }

    public String getOwnerDisplayName() {
        return this.ownerDisplayName;
    }

    public void setOwnerDisplayName(String ownerDisplayName) {
        this.ownerDisplayName = ownerDisplayName;
    }

    protected String getAcl() {
        return this.acl;
    }

    public void setAcl(String aclString) {
        this.acl = aclString;
        this.setDecodedAcl(null);
    }

    public void setAcl(AccessControlPolicy msgAcl) {
        AccessControlPolicy policy = msgAcl;
        if (this.getOwnerCanonicalId() != null) {
            if (policy.getOwner() != null && !StringUtils.equals((String)policy.getOwner().getID(), (String)this.getOwnerCanonicalId())) {
                throw new RuntimeException("Owner cannot be changed");
            }
            if (policy.getOwner() == null) {
                policy.setOwner(new CanonicalUser(this.getOwnerCanonicalId(), this.getOwnerDisplayName()));
            }
        }
        Map<String, Integer> resultMap = AccessControlPolicyToMap.INSTANCE.apply(policy);
        this.setAcl(JSONObject.fromObject(resultMap).toString());
        this.setDecodedAcl(resultMap);
    }

    public static String marshallAclToString(AccessControlList acl) throws Exception {
        Map<String, Integer> resultMap = AccessControlListToMap.INSTANCE.apply(acl);
        return JSONObject.fromObject(resultMap).toString();
    }

    public static String marshallAcpToString(AccessControlPolicy acl) throws Exception {
        Map<String, Integer> resultMap = AccessControlPolicyToMap.INSTANCE.apply(acl);
        return JSONObject.fromObject(resultMap).toString();
    }

    public AccessControlPolicy getAccessControlPolicy() throws Exception {
        AccessControlPolicy policy = MapToAccessControlPolicy.INSTANCE.apply(this.getDecodedAcl());
        policy.setOwner(new CanonicalUser(this.getOwnerCanonicalId(), this.ownerDisplayName));
        return policy;
    }

    public String getOwnerIamUserDisplayName() {
        return this.ownerIamUserDisplayName;
    }

    public void setOwnerIamUserDisplayName(String ownerIamUserDisplayName) {
        this.ownerIamUserDisplayName = ownerIamUserDisplayName;
    }

    public boolean can(ObjectStorageProperties.Permission permission, String canonicalId) {
        try {
            Map<String, Integer> myAcl = this.getDecodedAcl();
            if (myAcl == null) {
                LOG.error((Object)("Got null acl, cannot authorize " + permission.toString()));
                return false;
            }
            for (ObjectStorageProperties.S3_GROUP group : ObjectStorageProperties.S3_GROUP.values()) {
                if (!this.can(permission, group) || !AclUtils.isUserMemberOfGroup(canonicalId, group.toString())) continue;
                return true;
            }
            if (myAcl.containsKey(canonicalId) && BitmapGrant.allows(permission, myAcl.get(canonicalId))) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error checking authorization", (Throwable)e);
        }
        return false;
    }

    public boolean can(ObjectStorageProperties.Permission permission, ObjectStorageProperties.S3_GROUP group) {
        try {
            Map<String, Integer> myAcl = this.getDecodedAcl();
            if (myAcl == null) {
                LOG.error((Object)("Got null acl, cannot authorize " + permission.toString()));
                return false;
            }
            String groupName = group.toString();
            return myAcl.containsKey(groupName) && BitmapGrant.allows(permission, myAcl.get(groupName));
        }
        catch (Exception e) {
            LOG.error((Object)"Error checking authorization", (Throwable)e);
            return false;
        }
    }

    private synchronized void setDecodedAcl(Map<String, Integer> permissionsMap) {
        this.decodedAcl = permissionsMap;
    }

    private synchronized Map<String, Integer> getDecodedAcl() throws Exception {
        if (this.decodedAcl == null) {
            try {
                HashMap<String, Integer> aclMap = new HashMap<String, Integer>();
                JSONObject aclJson = (JSONObject)JSONSerializer.toJSON((Object)this.getAcl());
                String key = null;
                Iterator keys = aclJson.keys();
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    aclMap.put(key, new Integer(aclJson.getInt(key)));
                }
                this.setDecodedAcl(aclMap);
            }
            catch (Exception e) {
                this.setDecodedAcl(null);
                LOG.error((Object)"Error decoding acl from DB string", (Throwable)e);
                throw e;
            }
        }
        return this.decodedAcl;
    }

    public static enum BitmapGrant {
        INSTANCE;

        private static final int readMask = 8;
        private static final int writeMask = 4;
        private static final int readACPMask = 2;
        private static final int writeACPMask = 1;

        public static boolean allows(ObjectStorageProperties.Permission perm, int mapValue) {
            switch (perm) {
                case FULL_CONTROL: {
                    return (mapValue & 0xF) == 15;
                }
                case READ: {
                    return (mapValue & 8) == 8;
                }
                case WRITE: {
                    return (mapValue & 4) == 4;
                }
                case READ_ACP: {
                    return (mapValue & 2) == 2;
                }
                case WRITE_ACP: {
                    return (mapValue & 1) == 1;
                }
            }
            return false;
        }

        public static int translateToBitmap(ObjectStorageProperties.Permission perm) {
            switch (perm) {
                case FULL_CONTROL: {
                    return 15;
                }
                case READ: {
                    return 8;
                }
                case WRITE: {
                    return 4;
                }
                case READ_ACP: {
                    return 2;
                }
                case WRITE_ACP: {
                    return 1;
                }
            }
            return 0;
        }

        public static int add(ObjectStorageProperties.Permission perm, int oldAclBitmap) {
            switch (perm) {
                case FULL_CONTROL: {
                    return oldAclBitmap | 8 | 4 | 2 | 1;
                }
                case READ: {
                    return oldAclBitmap | 8;
                }
                case WRITE: {
                    return oldAclBitmap | 4;
                }
                case READ_ACP: {
                    return oldAclBitmap | 2;
                }
                case WRITE_ACP: {
                    return oldAclBitmap | 1;
                }
            }
            return 0;
        }

        public static String toLogString(Integer b) {
            StringBuilder sb = new StringBuilder("{");
            sb.append("read=").append(BitmapGrant.allows(ObjectStorageProperties.Permission.READ, b));
            sb.append(",write=").append(BitmapGrant.allows(ObjectStorageProperties.Permission.WRITE, b));
            sb.append(",readacp=").append(BitmapGrant.allows(ObjectStorageProperties.Permission.READ_ACP, b));
            sb.append(",writeacp=").append(BitmapGrant.allows(ObjectStorageProperties.Permission.WRITE_ACP, b));
            sb.append("}");
            return sb.toString();
        }
    }

    protected static enum AccountGrantsFromBitmap implements Function<Integer, List<ObjectStorageProperties.Permission>>
    {
        INSTANCE;


        public List<ObjectStorageProperties.Permission> apply(Integer srcBitmap) {
            ArrayList<ObjectStorageProperties.Permission> permissions = new ArrayList<ObjectStorageProperties.Permission>();
            if (srcBitmap == null) {
                return permissions;
            }
            if (BitmapGrant.allows(ObjectStorageProperties.Permission.FULL_CONTROL, srcBitmap)) {
                permissions.add(ObjectStorageProperties.Permission.FULL_CONTROL);
            } else {
                boolean i = false;
                if (BitmapGrant.allows(ObjectStorageProperties.Permission.READ, srcBitmap)) {
                    permissions.add(ObjectStorageProperties.Permission.READ);
                }
                if (BitmapGrant.allows(ObjectStorageProperties.Permission.WRITE, srcBitmap)) {
                    permissions.add(ObjectStorageProperties.Permission.WRITE);
                }
                if (BitmapGrant.allows(ObjectStorageProperties.Permission.READ_ACP, srcBitmap)) {
                    permissions.add(ObjectStorageProperties.Permission.READ_ACP);
                }
                if (BitmapGrant.allows(ObjectStorageProperties.Permission.WRITE_ACP, srcBitmap)) {
                    permissions.add(ObjectStorageProperties.Permission.WRITE_ACP);
                }
            }
            return permissions;
        }
    }

    protected static enum AccessControlListToMap implements Function<AccessControlList, Map<String, Integer>>
    {
        INSTANCE;


        public Map<String, Integer> apply(AccessControlList srcList) {
            HashMap<String, Integer> aclMap = new HashMap<String, Integer>();
            if (srcList == null) {
                return aclMap;
            }
            AclUtils.scrubAcl(srcList);
            for (Grant g : srcList.getGrants()) {
                int oldGrant;
                String canonicalId = g.getGrantee().getCanonicalUser().getID();
                int n = oldGrant = aclMap.containsKey(canonicalId) ? aclMap.get(canonicalId) : 0;
                int newGrant = BitmapGrant.add(ObjectStorageProperties.Permission.valueOf(g.getPermission().toUpperCase()), oldGrant);
                if (newGrant == 0) continue;
                aclMap.put(canonicalId, newGrant);
            }
            return aclMap;
        }
    }

    protected static enum AccessControlPolicyToMap implements Function<AccessControlPolicy, Map<String, Integer>>
    {
        INSTANCE;


        public Map<String, Integer> apply(AccessControlPolicy srcPolicy) {
            if (srcPolicy == null) {
                throw new RuntimeException("Null source policy. Cannot map");
            }
            Map<String, Integer> aclMap = AccessControlListToMap.INSTANCE.apply(srcPolicy.getAccessControlList());
            if (aclMap == null) {
                throw new RuntimeException("Null acl map. Cannot proceed with policy generation");
            }
            String ownerCanonicalId = srcPolicy.getOwner().getID();
            if (ownerCanonicalId == null) {
                throw new RuntimeException("Invalid ACP: OwnerCanonicalId required.");
            }
            try {
                Accounts.lookupAccountByCanonicalId((String)ownerCanonicalId);
            }
            catch (Exception e) {
                LOG.warn((Object)("Got invalid owner in AccessControlPolicy during mapping to DB: " + ownerCanonicalId));
                throw new RuntimeException("Could not find account by canonicalId " + ownerCanonicalId, e);
            }
            aclMap.remove(ownerCanonicalId);
            Integer ownerGrant = BitmapGrant.translateToBitmap(ObjectStorageProperties.Permission.FULL_CONTROL);
            aclMap.put(ownerCanonicalId, ownerGrant);
            return aclMap;
        }
    }

    protected static enum MapToAccessControlPolicy implements Function<Map<String, Integer>, AccessControlPolicy>
    {
        INSTANCE;


        public AccessControlPolicy apply(Map<String, Integer> srcMap) {
            AccessControlPolicy policy = new AccessControlPolicy();
            AccessControlList acList = new AccessControlList();
            ArrayList<Grant> grants = new ArrayList<Grant>();
            String displayName = null;
            for (Map.Entry<String, Integer> entry : srcMap.entrySet()) {
                Grantee grantee = new Grantee();
                ObjectStorageProperties.S3_GROUP groupId = null;
                try {
                    groupId = AclUtils.getGroupFromUri(entry.getKey());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (groupId != null) {
                    grantee.setGroup(new Group(groupId.toString()));
                    grantee.setType("Group");
                } else {
                    try {
                        displayName = Accounts.lookupAccountByCanonicalId((String)entry.getKey()).getName();
                    }
                    catch (AuthException e) {
                        displayName = "";
                    }
                    grantee.setCanonicalUser(new CanonicalUser(entry.getKey(), displayName));
                    grantee.setType("CanonicalUser");
                }
                for (ObjectStorageProperties.Permission p : AccountGrantsFromBitmap.INSTANCE.apply(entry.getValue())) {
                    grants.add(new Grant(grantee, p.toString()));
                }
            }
            acList.setGrants(grants);
            policy.setAccessControlList(acList);
            return policy;
        }
    }
}

