/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.entities;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.objectstorage.ObjectState;
import com.eucalyptus.objectstorage.entities.Bucket;
import com.eucalyptus.objectstorage.entities.S3AccessControlledEntity;
import com.eucalyptus.objectstorage.exceptions.s3.AccountProblemException;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.storage.msgs.s3.Part;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.OptimisticLocking;

@Entity
@OptimisticLocking(type=OptimisticLockType.NONE)
@PersistenceContext(name="eucalyptus_osg")
@Table(name="parts")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class PartEntity
extends S3AccessControlledEntity<ObjectState>
implements Comparable {
    @Column(name="object_key")
    private String objectKey;
    @NotFound(action=NotFoundAction.EXCEPTION)
    @ManyToOne(optional=false, targetEntity=Bucket.class, fetch=FetchType.EAGER)
    @ForeignKey(name="FK_bucket")
    @JoinColumn(name="bucket_fk")
    private Bucket bucket;
    @Index(name="IDX_part_uuid")
    @Column(name="part_uuid", unique=true, nullable=false)
    private String partUuid;
    @Column(name="size", nullable=false)
    private Long size;
    @Column(name="storage_class", nullable=false)
    private String storageClass;
    @Column(name="object_last_modified")
    private Date objectModifiedTimestamp;
    @Column(name="etag")
    private String eTag;
    @Column(name="is_latest")
    private Boolean isLatest;
    @Column(name="creation_expiration")
    private Long creationExpiration;
    @Column(name="upload_id")
    private String uploadId;
    @Column(name="part_number")
    private Integer partNumber;
    private static Logger LOG = Logger.getLogger(PartEntity.class);

    public Long getCreationExpiration() {
        return this.creationExpiration;
    }

    public void setCreationExpiration(Long creationExpiration) {
        this.creationExpiration = creationExpiration;
    }

    public PartEntity() {
    }

    public PartEntity(Bucket parentBucket, String objectKey, String uploadId) {
        this.bucket = parentBucket;
        this.uploadId = uploadId;
        this.objectKey = objectKey;
    }

    public PartEntity withBucket(Bucket parentBucket) {
        this.setBucket(parentBucket);
        return this;
    }

    public PartEntity withKey(String key) {
        this.setObjectKey(key);
        return this;
    }

    public PartEntity withUuid(String uuid) {
        this.setPartUuid(uuid);
        return this;
    }

    public PartEntity withUploadId(String uploadId) {
        this.setUploadId(uploadId);
        return this;
    }

    public PartEntity withPartNumber(int partNumber) {
        this.setPartNumber(partNumber);
        return this;
    }

    public PartEntity withState(ObjectState s) {
        this.setState(s);
        this.setLastState(null);
        return this;
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    public void setBucket(Bucket bucket) {
        this.bucket = bucket;
    }

    @PrePersist
    public void ensureFieldsNotNull() {
        if (this.partUuid == null) {
            this.partUuid = PartEntity.generateInternalKey(this.objectKey);
        }
    }

    public static PartEntity newInitializedForCreate(@Nonnull Bucket bucket, @Nonnull String objectKey, @Nonnull String uploadId, @Nonnull Integer partNumber, @Nonnull long contentLength, @Nonnull User usr) throws Exception {
        PartEntity entity = new PartEntity(bucket, objectKey, uploadId);
        entity.setPartUuid(PartEntity.generateInternalKey(objectKey));
        try {
            entity.setOwnerCanonicalId(usr.getAccount().getCanonicalId());
            entity.setOwnerDisplayName(usr.getAccount().getName());
        }
        catch (AuthException e) {
            throw new AccountProblemException();
        }
        entity.setPartNumber(partNumber);
        entity.setUploadId(uploadId);
        entity.setOwnerIamUserId(usr.getUserId());
        entity.setObjectModifiedTimestamp(null);
        entity.setSize(contentLength);
        entity.setIsLatest(false);
        entity.setStorageClass(ObjectStorageProperties.STORAGE_CLASS.STANDARD.toString());
        entity.updateCreationExpiration();
        entity.setState(ObjectState.creating);
        return entity;
    }

    public void updateCreationExpiration() {
        this.creationExpiration = System.currentTimeMillis() + 30000L;
    }

    private static String generateInternalKey(@Nonnull String key) {
        return UUID.randomUUID().toString() + "-" + key;
    }

    public String geteTag() {
        return this.eTag;
    }

    public void seteTag(String eTag) {
        this.eTag = eTag;
    }

    public Date getObjectModifiedTimestamp() {
        return this.objectModifiedTimestamp;
    }

    public void setObjectModifiedTimestamp(Date objectModifiedTimestamp) {
        this.objectModifiedTimestamp = objectModifiedTimestamp;
    }

    @Override
    public String getResourceFullName() {
        return this.getBucket().getBucketName() + "/" + this.getObjectKey() + "?uploadId=" + this.uploadId + "&partNumber=" + this.partNumber;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public int compareTo(Object o) {
        return this.objectKey.compareTo(((PartEntity)o).getObjectKey());
    }

    public boolean isPending() {
        return this.getObjectModifiedTimestamp() == null;
    }

    public String getPartUuid() {
        return this.partUuid;
    }

    public void setPartUuid(String partUuid) {
        this.partUuid = partUuid;
    }

    public Boolean getIsLatest() {
        return this.isLatest;
    }

    public void setIsLatest(Boolean isLatest) {
        this.isLatest = isLatest;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public Integer getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(Integer partNumber) {
        this.partNumber = partNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.partUuid == null ? 0 : this.partUuid.hashCode());
        result = 31 * result + (this.objectKey == null ? 0 : this.objectKey.hashCode());
        result = 31 * result + (this.uploadId == null ? 0 : this.uploadId.hashCode());
        result = 31 * result + (this.partNumber == null ? 0 : this.partNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartEntity other = (PartEntity)obj;
        if (this.objectKey == null ? other.objectKey != null : !this.objectKey.equals(other.objectKey)) {
            return false;
        }
        if (this.partUuid == null ? other.partUuid != null : !this.partUuid.equals(other.partUuid)) {
            return false;
        }
        if (this.uploadId == null ? other.uploadId != null : !this.uploadId.equals(other.uploadId)) {
            return false;
        }
        return !(this.partNumber == null ? other.partNumber != null : !this.partNumber.equals(other.partNumber));
    }

    public Part toPartListEntry() {
        Part e = new Part();
        e.setEtag("\"" + this.geteTag() + "\"");
        e.setPartNumber(this.getPartNumber());
        e.setLastModified(this.getObjectModifiedTimestamp());
        e.setSize(this.getSize());
        return e;
    }
}

