/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.entities;

import com.eucalyptus.component.Components;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.objectstorage.entities.ObjectStorageConfiguration;
import com.eucalyptus.objectstorage.providers.ObjectStorageProviders;
import com.eucalyptus.storage.config.CacheableConfiguration;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.walrus.entities.WalrusInfo;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import groovy.sql.GroovyRowResult;
import groovy.sql.Sql;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_osg")
@Table(name="osg_config")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@ConfigurableClass(root="ObjectStorage", description="Object Storage Gateway configuration.", deferred=true, singleton=true)
public class ObjectStorageGlobalConfiguration
extends AbstractPersistent
implements CacheableConfiguration<ObjectStorageGlobalConfiguration> {
    @Transient
    private static final Logger LOG = Logger.getLogger(ObjectStorageGlobalConfiguration.class);
    @Transient
    private static final int DEFAULT_MAX_BUCKETS_PER_ACCOUNT = 100;
    @Transient
    private static final int DEFAULT_PUT_TIMEOUT_HOURS = 168;
    @Transient
    private static final int DEFAULT_CLEANUP_INTERVAL_SEC = 60;
    @Transient
    private static final String DEFAULT_BUCKET_NAMING_SCHEME = "extended";
    @Transient
    private static final Boolean DEFAULT_COPY_UNSUPPORTED_STRATEGY = Boolean.FALSE;
    @Column
    @ConfigurableField(description="Maximum number of buckets per account", displayName="Maximum buckets per account")
    protected Integer max_buckets_per_account;
    @Column
    @ConfigurableField(description="Total ObjectStorage storage capacity for Objects soley for reporting usage percentage. Not a size restriction. No enforcement of this value", displayName="ObjectStorage object capacity (GB)")
    protected Integer max_total_reporting_capacity_gb;
    @Column
    @ConfigurableField(description="Number of hours to wait for object PUT operations to be allowed to complete before cleanup.", displayName="Object PUT failure cleanup (Hours)")
    protected Integer failed_put_timeout_hrs;
    @Column
    @ConfigurableField(description="Interval, in seconds, at which cleanup tasks are initiated for removing old/stale objects.", displayName="Cleanup interval (seconds)")
    protected Integer cleanup_task_interval_seconds;
    @Column
    @ConfigurableField(description="Interval, in seconds, during which buckets in creating-state are valid. After this interval, the operation is assumed failed.", displayName="Operation wait interval (seconds)")
    protected Integer bucket_creation_wait_interval_seconds;
    @Column
    @ConfigurableField(description="The S3 bucket naming restrictions to enforce. Values are 'dns-compliant' or 'extended'. Default is 'extended'. dns_compliant is non-US region S3 names, extended is for US-Standard Region naming. See http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html", displayName="Bucket Naming restrictions", changeListener=BucketNamingRestrictionsValidator.class)
    protected String bucket_naming_restrictions;
    @Column
    @ConfigurableField(description="Should provider client attempt a GET / PUT when backend does not support Copy operation", displayName="attempt GET/PUT on Copy fail", type=ConfigurableFieldType.BOOLEAN)
    protected Boolean doGetPutOnCopyFail;
    @Column
    @ConfigurableField(description="Object Storage Provider client to use for backend", displayName="Object Storage Provider Client", changeListener=ObjectStorageProviderChangeListener.class)
    protected String providerClient;

    public ObjectStorageGlobalConfiguration getLatest() {
        return ObjectStorageGlobalConfiguration.getConfiguration();
    }

    protected ObjectStorageGlobalConfiguration initializeDefaults() {
        this.setBucket_creation_wait_interval_seconds(60);
        this.setBucket_naming_restrictions(DEFAULT_BUCKET_NAMING_SCHEME);
        this.setCleanup_task_interval_seconds(60);
        this.setDoGetPutOnCopyFail(DEFAULT_COPY_UNSUPPORTED_STRATEGY);
        this.setFailed_put_timeout_hrs(168);
        this.setMax_buckets_per_account(100);
        this.setMax_total_reporting_capacity_gb(Integer.MAX_VALUE);
        return this;
    }

    public Integer getMax_buckets_per_account() {
        return this.max_buckets_per_account;
    }

    public void setMax_buckets_per_account(Integer max_buckets_per_account) {
        this.max_buckets_per_account = max_buckets_per_account;
    }

    public Integer getMax_total_reporting_capacity_gb() {
        return this.max_total_reporting_capacity_gb;
    }

    public void setMax_total_reporting_capacity_gb(Integer max_total_reporting_capacity_gb) {
        this.max_total_reporting_capacity_gb = max_total_reporting_capacity_gb;
    }

    public Integer getFailed_put_timeout_hrs() {
        return this.failed_put_timeout_hrs;
    }

    public void setFailed_put_timeout_hrs(Integer failed_put_timeout_hrs) {
        this.failed_put_timeout_hrs = failed_put_timeout_hrs;
    }

    public Integer getCleanup_task_interval_seconds() {
        return this.cleanup_task_interval_seconds;
    }

    public void setCleanup_task_interval_seconds(Integer cleanup_task_interval_seconds) {
        this.cleanup_task_interval_seconds = cleanup_task_interval_seconds;
    }

    public Integer getBucket_creation_wait_interval_seconds() {
        return this.bucket_creation_wait_interval_seconds;
    }

    public void setBucket_creation_wait_interval_seconds(Integer bucket_creation_wait_interval_seconds) {
        this.bucket_creation_wait_interval_seconds = bucket_creation_wait_interval_seconds;
    }

    public String getBucket_naming_restrictions() {
        return this.bucket_naming_restrictions;
    }

    public void setBucket_naming_restrictions(String bucket_naming_restrictions) {
        this.bucket_naming_restrictions = bucket_naming_restrictions;
    }

    public Boolean getDoGetPutOnCopyFail() {
        return this.doGetPutOnCopyFail;
    }

    public void setDoGetPutOnCopyFail(Boolean doGetPutOnCopyFail) {
        this.doGetPutOnCopyFail = doGetPutOnCopyFail;
    }

    public String getProviderClient() {
        return this.providerClient;
    }

    public void setProviderClient(String providerClient) {
        this.providerClient = providerClient;
    }

    public static ObjectStorageGlobalConfiguration getConfiguration() {
        try {
            try {
                return (ObjectStorageGlobalConfiguration)((Object)Transactions.find((Object)((Object)new ObjectStorageGlobalConfiguration())));
            }
            catch (NoSuchElementException e) {
                LOG.info((Object)"No extant S3 provider configuration found. Initializing defaults");
                return (ObjectStorageGlobalConfiguration)((Object)Transactions.saveDirect((Object)((Object)new ObjectStorageGlobalConfiguration().initializeDefaults())));
            }
        }
        catch (Throwable f) {
            throw Exceptions.toUndeclared((String)"Failed getting and/or initializing OSG global configuration", (Throwable[])new Throwable[]{f});
        }
    }

    public String toString() {
        String value = "[OSG Global configuration: MaxTotalCapacity=" + this.max_total_reporting_capacity_gb + " , " + "MaxBucketsPerAccount=" + this.max_buckets_per_account + " , " + "FailedPutTimeoutHrs=" + this.failed_put_timeout_hrs + " , " + "CleanupTaskIntervalSec=" + this.cleanup_task_interval_seconds + " , " + "BucketCreationWaitIntervalSec=" + this.bucket_creation_wait_interval_seconds + " , " + "BucketNamingRestrictions=" + this.bucket_naming_restrictions + " , " + "DoGetPutOnCopyFail=" + this.doGetPutOnCopyFail + " , " + "ProviderClient=" + this.providerClient + "]";
        return value;
    }

    public static class ObjectStorageProviderChangeListener
    implements PropertyChangeListener<String> {
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            String existingValue = t.getValue();
            List objConfigs = null;
            try {
                objConfigs = ServiceConfigurations.list(ObjectStorage.class);
            }
            catch (NoSuchElementException e) {
                throw new ConfigurablePropertyException("No ObjectStorage configurations found");
            }
            final String proposedValue = newValue;
            final HashSet validEntries = Sets.newHashSet();
            try (TransactionResource tr = Entities.transactionFor(ObjectStorageConfiguration.class);){
                boolean match = Iterables.any((Iterable)Components.lookup(ObjectStorage.class).services(), (Predicate)new Predicate<ServiceConfiguration>(){

                    public boolean apply(ServiceConfiguration config) {
                        if (config.isVmLocal().booleanValue()) {
                            validEntries.addAll(ObjectStorageProviders.list());
                            return ObjectStorageProviders.contains(proposedValue);
                        }
                        try {
                            ObjectStorageConfiguration objConfig = (ObjectStorageConfiguration)Entities.uniqueResult((Object)((ObjectStorageConfiguration)config));
                            for (String entry : Splitter.on((String)",").split((CharSequence)objConfig.getAvailableClients())) {
                                validEntries.add(entry);
                            }
                            return validEntries.contains(proposedValue);
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                });
                tr.commit();
                if (!match) {
                    throw new ConfigurablePropertyException("Cannot modify " + t.getQualifiedName() + "." + t.getFieldName() + " new value is not a valid value.  " + "Legal values are: " + Joiner.on((String)",").join((Iterable)validEntries));
                }
            }
        }
    }

    @Upgrades.EntityUpgrade(entities={ObjectStorageGlobalConfiguration.class}, since=Upgrades.Version.v4_1_0, value=ObjectStorage.class)
    public static enum ProviderClientUpgrade implements Predicate<Class>
    {
        INSTANCE;

        private static final Logger LOG;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean apply(@Nullable Class arg0) {
            try (TransactionResource tr = Entities.transactionFor((Object)arg0);){
                ObjectStorageGlobalConfiguration osgc = null;
                try {
                    osgc = (ObjectStorageGlobalConfiguration)((Object)Entities.uniqueResult((Object)((Object)new ObjectStorageGlobalConfiguration())));
                }
                catch (NoSuchElementException e) {
                    osgc = new ObjectStorageGlobalConfiguration().initializeDefaults();
                    Entities.persist((Object)((Object)osgc));
                }
                if (StringUtils.isNotBlank((String)osgc.getProviderClient())) {
                    LOG.info((Object)("Nothing to upgrade as objectstorage provider client is already configured to " + osgc.getProviderClient()));
                } else {
                    String prevClient = this.getStaticProviderClient();
                    if (StringUtils.isNotBlank((String)prevClient)) {
                        LOG.info((Object)("Found global objectstorage.providerclient=" + prevClient + ". Copying value to providerClient of ObjectStorageGlobalConfiguration entity"));
                        osgc.setProviderClient(prevClient);
                    } else {
                        LOG.info((Object)"Global objectstorage.providerclient not found. Defaulting providerClient of ObjectStorageGlobalConfiguration entity to walrus");
                        osgc.setProviderClient("walrus");
                    }
                }
                tr.commit();
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                LOG.error((Object)"Error upgrading global osg configuration", (Throwable)e);
                throw Exceptions.toUndeclared((String)"Error upgrading global osg configuration", (Throwable[])new Exception[]{e});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getStaticProviderClient() {
            String propertyValue = null;
            Sql sql = null;
            try {
                sql = Upgrades.DatabaseFilters.NEWVERSION.getConnection("eucalyptus_config");
                String query = "select config_static_field_value from config_static_property where config_static_prop_name='objectstorage.providerclient'";
                try {
                    List result = sql.rows(query);
                    if (result != null && result.size() == 1 && result.get(0) != null) {
                        propertyValue = (String)((GroovyRowResult)result.get(0)).getProperty("config_static_field_value");
                        query = "delete from config_static_property where config_static_prop_name='objectstorage.providerclient'";
                        sql.execute(query);
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed to execute query: " + query), (Throwable)e);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed to connect to database", (Throwable)e);
            }
            finally {
                try {
                    if (sql != null) {
                        sql.close();
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)"Failed to close database connection", (Throwable)e);
                }
            }
            return propertyValue;
        }

        static {
            LOG = Logger.getLogger(ProviderClientUpgrade.class);
        }
    }

    @Upgrades.EntityUpgrade(entities={ObjectStorageGlobalConfiguration.class}, since=Upgrades.Version.v4_0_0, value=ObjectStorage.class)
    public static enum OSGConfigUpgrade implements Predicate<Class>
    {
        INSTANCE;


        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean apply(@Nullable Class arg0) {
            try (TransactionResource trans = Entities.transactionFor((Object)arg0);){
                ObjectStorageGlobalConfiguration config = new ObjectStorageGlobalConfiguration().initializeDefaults();
                config = (ObjectStorageGlobalConfiguration)((Object)Entities.merge((Object)((Object)config)));
                WalrusInfo walrusConfig = WalrusInfo.getWalrusInfo();
                config.setMax_buckets_per_account(walrusConfig.getStorageMaxBucketsPerAccount());
                config.setMax_total_reporting_capacity_gb(walrusConfig.getStorageMaxTotalCapacity());
                config.setBucket_naming_restrictions(walrusConfig.getBucketNamesRequireDnsCompliance() != false ? "dns-compliant" : ObjectStorageGlobalConfiguration.DEFAULT_BUCKET_NAMING_SCHEME);
                config.setProviderClient("walrus");
                trans.commit();
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                LOG.error((Object)"Error saving upgrade global osg configuration", (Throwable)e);
                throw Exceptions.toUndeclared((String)"Error upgrading walrus config to OSG config", (Throwable[])new Exception[]{e});
            }
        }
    }

    public static class BucketNamingRestrictionsValidator
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            String proposed = (String)newValue;
            if (Strings.isNullOrEmpty((String)proposed) || !ObjectStorageGlobalConfiguration.DEFAULT_BUCKET_NAMING_SCHEME.equals(proposed) && !"dns-compliant".equals(proposed)) {
                throw Exceptions.toUndeclared((String)("Invalid property value: " + proposed + " Acceptabled values are: 'extended' and 'dns-compliant'"), (Throwable[])new NoSuchElementException[]{new NoSuchElementException(proposed)});
            }
        }
    }
}

