/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.entities;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.objectstorage.ObjectState;
import com.eucalyptus.objectstorage.entities.Bucket;
import com.eucalyptus.objectstorage.entities.S3AccessControlledEntity;
import com.eucalyptus.objectstorage.exceptions.s3.AccountProblemException;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.storage.common.DateFormatter;
import com.eucalyptus.storage.msgs.s3.CanonicalUser;
import com.eucalyptus.storage.msgs.s3.DeleteMarkerEntry;
import com.eucalyptus.storage.msgs.s3.KeyEntry;
import com.eucalyptus.storage.msgs.s3.ListEntry;
import com.eucalyptus.storage.msgs.s3.VersionEntry;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.OptimisticLocking;
import org.hibernate.annotations.Type;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

@Entity
@OptimisticLocking(type=OptimisticLockType.NONE)
@PersistenceContext(name="eucalyptus_osg")
@Table(name="objects")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class ObjectEntity
extends S3AccessControlledEntity<ObjectState>
implements Comparable {
    @Transient
    private static Logger LOG = Logger.getLogger(ObjectEntity.class);
    @Index(name="IDX_object_key")
    @Column(name="object_key")
    private String objectKey;
    @NotFound(action=NotFoundAction.EXCEPTION)
    @ManyToOne(optional=false, targetEntity=Bucket.class, fetch=FetchType.EAGER)
    @ForeignKey(name="FK_bucket")
    @JoinColumn(name="bucket_fk")
    private Bucket bucket;
    @Index(name="IDX_object_uuid")
    @Column(name="object_uuid", unique=true, nullable=false)
    private String objectUuid;
    @Index(name="IDX_version_id")
    @Column(name="version_id", nullable=false)
    private String versionId;
    @Column(name="size", nullable=false)
    private Long size;
    @Column(name="storage_class", nullable=false)
    private String storageClass;
    @Column(name="is_delete_marker")
    private Boolean isDeleteMarker;
    @Column(name="object_last_modified")
    private Date objectModifiedTimestamp;
    @Column(name="etag")
    private String eTag;
    @Column(name="is_latest")
    private Boolean isLatest;
    @Column(name="creation_expiration")
    private Long creationExpiration;
    @Column(name="upload_id")
    private String uploadId;
    @Column(name="stored_headers")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String storedHeaders;

    public Long getCreationExpiration() {
        return this.creationExpiration;
    }

    public void setCreationExpiration(Long creationExpiration) {
        this.creationExpiration = creationExpiration;
    }

    public Boolean getIsDeleteMarker() {
        return this.isDeleteMarker;
    }

    public void setIsDeleteMarker(Boolean isDeleteMarker) {
        this.isDeleteMarker = isDeleteMarker;
    }

    public ObjectEntity() {
    }

    public ObjectEntity(Bucket parentBucket, String objectKey, String versionId) {
        this.bucket = parentBucket;
        this.objectKey = objectKey;
        this.versionId = versionId;
    }

    public ObjectEntity withBucket(Bucket parentBucket) {
        this.setBucket(parentBucket);
        return this;
    }

    public ObjectEntity withKey(String key) {
        this.setObjectKey(key);
        return this;
    }

    public ObjectEntity withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public ObjectEntity withUuid(String uuid) {
        this.setObjectUuid(uuid);
        return this;
    }

    public ObjectEntity withUploadId(String uploadId) {
        this.setUploadId(uploadId);
        return this;
    }

    public ObjectEntity withState(ObjectState s) {
        this.setState(s);
        this.setLastState(null);
        return this;
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    public void setBucket(Bucket bucket) {
        this.bucket = bucket;
    }

    @PrePersist
    public void ensureFieldsNotNull() {
        if (this.versionId == null) {
            this.versionId = "null";
        }
        if (this.isDeleteMarker == null) {
            this.isDeleteMarker = false;
        }
        if (this.objectUuid == null) {
            ObjectEntity.generateInternalKey(this.objectKey);
        }
    }

    public static ObjectEntity newInitializedForCreate(@Nonnull Bucket bucket, @Nonnull String objectKey, @Nonnull long contentLength, @Nonnull User usr) throws Exception {
        ObjectEntity entity = new ObjectEntity(bucket, objectKey, bucket.generateObjectVersionId());
        entity.setObjectUuid(ObjectEntity.generateInternalKey(objectKey));
        try {
            entity.setOwnerCanonicalId(usr.getAccount().getCanonicalId());
            entity.setOwnerDisplayName(usr.getAccount().getName());
        }
        catch (AuthException e) {
            throw new AccountProblemException();
        }
        entity.setOwnerIamUserId(usr.getUserId());
        entity.setOwnerIamUserDisplayName(usr.getName());
        entity.setObjectModifiedTimestamp(null);
        entity.setSize(contentLength);
        entity.setIsLatest(false);
        entity.setStorageClass(ObjectStorageProperties.STORAGE_CLASS.STANDARD.toString());
        entity.updateCreationExpiration();
        entity.setState(ObjectState.creating);
        return entity;
    }

    public static ObjectEntity newInitializedForCreate(@Nonnull Bucket bucket, @Nonnull String objectKey, @Nonnull long contentLength, @Nonnull User usr, @Nullable Map<String, String> headersToStore) throws Exception {
        ObjectEntity entity = ObjectEntity.newInitializedForCreate(bucket, objectKey, contentLength, usr);
        entity.setStoredHeaders(headersToStore);
        return entity;
    }

    public void updateCreationExpiration() {
        this.creationExpiration = System.currentTimeMillis() + 30000L;
    }

    public ObjectEntity generateNewDeleteMarkerFrom() {
        ObjectEntity deleteMarker = new ObjectEntity(this.bucket, this.getObjectKey(), this.getBucket().generateObjectVersionId()).withState(ObjectState.creating);
        deleteMarker.setObjectUuid(ObjectEntity.generateInternalKey(this.objectKey));
        deleteMarker.setStorageClass("STANDARD");
        deleteMarker.setObjectModifiedTimestamp(new Date());
        deleteMarker.setIsDeleteMarker(true);
        deleteMarker.setSize(0L);
        deleteMarker.setIsLatest(true);
        return deleteMarker;
    }

    private static String generateInternalKey(@Nonnull String key) {
        return UUID.randomUUID().toString();
    }

    public String geteTag() {
        return this.eTag;
    }

    public void seteTag(String eTag) {
        this.eTag = eTag;
    }

    public Date getObjectModifiedTimestamp() {
        return this.objectModifiedTimestamp;
    }

    public void setObjectModifiedTimestamp(Date objectModifiedTimestamp) {
        this.objectModifiedTimestamp = objectModifiedTimestamp;
    }

    @Override
    public String getResourceFullName() {
        return this.getBucket().getBucketName() + "/" + this.getObjectKey();
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public int compareTo(Object o) {
        return this.objectKey.compareTo(((ObjectEntity)o).getObjectKey());
    }

    public boolean isPending() {
        return this.getObjectModifiedTimestamp() == null;
    }

    public String getObjectUuid() {
        return this.objectUuid;
    }

    public void setObjectUuid(String objectUuid) {
        this.objectUuid = objectUuid;
    }

    public Boolean getIsLatest() {
        return this.isLatest;
    }

    public void setIsLatest(Boolean isLatest) {
        this.isLatest = isLatest;
    }

    public boolean isNullVersioned() {
        return "null".equals(this.versionId);
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public Map<String, String> getStoredHeaders() {
        HashMap headersMap = Maps.newHashMap();
        if (this.storedHeaders == null || "".equals(this.storedHeaders)) {
            return headersMap;
        }
        JSONObject headersJson = (JSONObject)JSONSerializer.toJSON((Object)this.storedHeaders);
        String key = null;
        Iterator keys = headersJson.keys();
        while (keys.hasNext()) {
            key = (String)keys.next();
            Object value = headersJson.get(key);
            if (value == null) continue;
            headersMap.put(key, value.toString());
        }
        return headersMap;
    }

    public void setStoredHeaders(Map<String, String> storedHeadersMap) {
        this.storedHeaders = JSONObject.fromObject(storedHeadersMap).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.objectUuid == null ? 0 : this.objectUuid.hashCode());
        result = 31 * result + (this.objectKey == null ? 0 : this.objectKey.hashCode());
        result = 31 * result + (this.versionId == null ? 0 : this.versionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectEntity other = (ObjectEntity)obj;
        if (this.bucket == null ? other.bucket == null : !this.bucket.equals(other.bucket)) {
            return false;
        }
        if (this.objectKey == null ? other.objectKey != null : !this.objectKey.equals(other.objectKey)) {
            return false;
        }
        if (this.versionId == null ? other.versionId != null : !this.versionId.equals(other.versionId)) {
            return false;
        }
        return !(this.objectUuid == null ? other.objectUuid != null : !this.objectUuid.equals(other.objectUuid));
    }

    public ListEntry toListEntry() {
        ListEntry e = new ListEntry();
        e.setEtag("\"" + this.geteTag() + "\"");
        e.setKey(this.getObjectKey());
        e.setLastModified(DateFormatter.dateToListingFormattedString((Date)this.getObjectModifiedTimestamp()));
        e.setSize(this.getSize().longValue());
        e.setStorageClass(this.getStorageClass());
        e.setOwner(new CanonicalUser(this.getOwnerCanonicalId(), this.getOwnerDisplayName()));
        return e;
    }

    public KeyEntry toVersionEntry() {
        if (!this.isDeleteMarker.booleanValue()) {
            VersionEntry e = new VersionEntry();
            e.setEtag("\"" + this.geteTag() + "\"");
            e.setKey(this.getObjectKey());
            e.setVersionId(this.getVersionId());
            e.setLastModified(DateFormatter.dateToListingFormattedString((Date)this.getObjectModifiedTimestamp()));
            e.setSize(this.getSize().longValue());
            e.setIsLatest(this.isLatest);
            e.setStorageClass(this.getStorageClass());
            e.setOwner(new CanonicalUser(this.getOwnerCanonicalId(), this.getOwnerDisplayName()));
            return e;
        }
        DeleteMarkerEntry e = new DeleteMarkerEntry();
        e.setKey(this.getObjectKey());
        e.setVersionId(this.getVersionId());
        e.setLastModified(DateFormatter.dateToListingFormattedString((Date)this.getObjectModifiedTimestamp()));
        e.setIsLatest(this.isLatest);
        e.setOwner(new CanonicalUser(this.getOwnerCanonicalId(), this.getOwnerDisplayName()));
        return e;
    }

    public static class QueryHelpers {
        public static Criterion getIsPartRestriction() {
            return Restrictions.isNotNull((String)"partNumber");
        }

        public static Criterion getIsNotPartRestriction() {
            return Restrictions.isNull((String)"partNumber");
        }

        public static Criterion getIsPendingRestriction() {
            return Restrictions.isNull((String)"objectModifiedTimestamp");
        }

        public static Criterion getIsMultipartRestriction() {
            return Restrictions.isNotNull((String)"uploadId");
        }
    }
}

