/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.entities;

import com.eucalyptus.objectstorage.BucketState;
import com.eucalyptus.objectstorage.entities.S3AccessControlledEntity;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.storage.common.DateFormatter;
import com.eucalyptus.storage.msgs.s3.AccessControlPolicy;
import com.eucalyptus.storage.msgs.s3.BucketListEntry;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_osg")
@Table(name="buckets")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class Bucket
extends S3AccessControlledEntity<BucketState>
implements Comparable {
    private static final long serialVersionUID = 1L;
    @Column(name="bucket_name", unique=true, nullable=true)
    private String bucketName;
    @Column(name="bucket_uuid", unique=true, nullable=false)
    private String bucketUuid;
    @Column(name="bucket_location")
    private String location;
    @Column(name="logging_enabled")
    private Boolean loggingEnabled;
    @Column(name="target_bucket")
    private String targetBucket;
    @Column(name="target_prefix")
    private String targetPrefix;
    @Column(name="versioning")
    @Enumerated(value=EnumType.STRING)
    private ObjectStorageProperties.VersioningStatus versioning;
    @Column(name="bucket_size")
    private Long bucketSize;

    @PrePersist
    public void checkPrePersist() {
        if (this.getState() == null) {
            throw new RuntimeException("Unspecified state");
        }
        if (this.versioning == null) {
            this.versioning = ObjectStorageProperties.VersioningStatus.Disabled;
        }
        if (this.bucketSize == null) {
            this.bucketSize = 0L;
        }
        if (this.bucketUuid == null) {
            this.genIds(this.getBucketName());
        }
    }

    public static Bucket getInitializedBucket(@Nonnull String name, @Nonnull String canonicalId, @Nonnull String displayName, @Nonnull String iamUserId, @Nonnull String acl, @Nonnull String location) {
        Bucket newBucket = new Bucket(name);
        newBucket.setOwnerCanonicalId(canonicalId);
        newBucket.setOwnerDisplayName(displayName);
        newBucket.setOwnerIamUserId(iamUserId);
        newBucket.setBucketSize(0L);
        newBucket.setAcl(acl);
        newBucket.setLocation(location);
        newBucket.setLoggingEnabled(false);
        newBucket.setState(BucketState.creating);
        newBucket.setVersioning(ObjectStorageProperties.VersioningStatus.Disabled);
        newBucket.genIds(name);
        return newBucket;
    }

    public static Bucket getInitializedBucket(@Nonnull String name, @Nonnull String iamUserId, @Nonnull AccessControlPolicy acp, @Nonnull String location) {
        if (acp.getOwner() == null || acp.getOwner().getID() == null || acp.getOwner().getDisplayName() == null) {
            throw new IllegalArgumentException("AccessControlPolicy must include full owner id and name");
        }
        Bucket newBucket = new Bucket(name);
        newBucket.setOwnerCanonicalId(acp.getOwner().getID());
        newBucket.setOwnerDisplayName(acp.getOwner().getDisplayName());
        newBucket.setOwnerIamUserId(iamUserId);
        newBucket.setBucketSize(0L);
        newBucket.setAcl(acp);
        newBucket.setLocation(location);
        newBucket.setLoggingEnabled(false);
        newBucket.setState(BucketState.creating);
        newBucket.setVersioning(ObjectStorageProperties.VersioningStatus.Disabled);
        newBucket.genIds(name);
        return newBucket;
    }

    public String getBucketUuid() {
        return this.bucketUuid;
    }

    void setBucketUuid(String bucketUuid) {
        this.bucketUuid = bucketUuid;
    }

    private void genIds(@Nonnull String bucketName) {
        this.setBucketUuid(UUID.randomUUID().toString());
    }

    public boolean stateStillValid(int stateTimeoutSeconds) {
        if (this.getState() != null && !BucketState.creating.equals(this.getState())) {
            return true;
        }
        if (this.getState() == null) {
            return false;
        }
        try {
            return System.currentTimeMillis() - this.getLastUpdateTimestamp().getTime() <= (long)stateTimeoutSeconds * 1000L;
        }
        catch (Throwable e) {
            return true;
        }
    }

    public Bucket withUuid(String bucketUuid) {
        this.setBucketUuid(bucketUuid);
        return this;
    }

    public Bucket withState(BucketState s) {
        this.setState(s);
        this.setLastState(null);
        return this;
    }

    public Long getBucketSize() {
        return this.bucketSize;
    }

    public void setBucketSize(Long bucketSize) {
        this.bucketSize = bucketSize;
    }

    public String generateObjectVersionId() {
        if (ObjectStorageProperties.VersioningStatus.Enabled.equals((Object)this.getVersioning())) {
            return UUID.randomUUID().toString().replaceAll("-", "");
        }
        return "null";
    }

    @Override
    public String getResourceFullName() {
        return this.getBucketName();
    }

    public Bucket() {
    }

    public Bucket(@Nonnull String bucketName) {
        this.bucketName = bucketName;
    }

    public Bucket(String ownerId, String ownerIamUserId, String bucketName) {
        this.genIds(bucketName);
        this.setOwnerCanonicalId(ownerId);
        this.setOwnerIamUserId(ownerIamUserId);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public boolean hasLoggingPerms() {
        return this.can(ObjectStorageProperties.Permission.READ_ACP, ObjectStorageProperties.S3_GROUP.LOGGING_GROUP.toString()) && this.can(ObjectStorageProperties.Permission.WRITE, ObjectStorageProperties.S3_GROUP.LOGGING_GROUP.toString());
    }

    public boolean isOwnedBy(String canonicalId) {
        return this.getOwnerCanonicalId() != null && this.getOwnerCanonicalId().equals(canonicalId);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Boolean getLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(Boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    public String getTargetBucket() {
        return this.targetBucket;
    }

    public void setTargetBucket(String targetBucket) {
        this.targetBucket = targetBucket;
    }

    public String getTargetPrefix() {
        return this.targetPrefix;
    }

    public void setTargetPrefix(String targetPrefix) {
        this.targetPrefix = targetPrefix;
    }

    public ObjectStorageProperties.VersioningStatus getVersioning() {
        return this.versioning;
    }

    public void setVersioning(ObjectStorageProperties.VersioningStatus versioning) {
        this.versioning = versioning;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bucketUuid == null ? 0 : this.bucketUuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bucket other = (Bucket)obj;
        return !(this.bucketUuid == null ? other.bucketUuid != null : !this.bucketUuid.equals(other.bucketUuid));
    }

    public String toString() {
        return "[BucketName: " + this.getBucketName() + " , BucketUuid: " + this.getBucketUuid() + " , State: " + this.getState() + " , Size: " + this.getBucketSize() + ", Location: " + this.getLocation() + " , VersioningState: " + this.getVersion() + " , LoggingEnabled: " + this.getLoggingEnabled() + " , AclString: " + this.getAcl() + "]";
    }

    public BucketListEntry toBucketListEntry() {
        return new BucketListEntry(this.getBucketName(), DateFormatter.dateToListingFormattedString((Date)this.getCreationTimestamp()));
    }

    public int compareTo(Object o) {
        if (o instanceof Bucket) {
            Bucket other = (Bucket)o;
            return this.getBucketName().compareTo(((Bucket)o).getBucketName());
        }
        return 0;
    }
}

