/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.client;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import java.util.Date;
import javax.annotation.Nonnull;

public class OsgInternalS3Client {
    private static final int CONNECTION_TIMEOUT_MS = 500;
    private static final int OSG_SOCKET_TIMEOUT_MS = 10000;
    private static final int OSG_MAX_CONNECTIONS = 512;
    private S3ClientOptions ops;
    private AmazonS3Client s3Client;
    private ClientConfiguration clientConfig;
    private Date instantiated;
    private volatile String endpoint;
    private volatile AWSCredentials currentCredentials;

    public OsgInternalS3Client(AWSCredentials credentials, String endpoint, boolean https, boolean useDns) {
        this.update(credentials, endpoint, https, useDns);
    }

    public void setUsePathStyle(boolean usePathStyle) {
        this.ops.setPathStyleAccess(usePathStyle);
        this.s3Client.setS3ClientOptions(this.ops);
    }

    public AmazonS3Client getS3Client() {
        return this.s3Client;
    }

    public synchronized String getS3Endpoint() {
        return this.endpoint;
    }

    public synchronized void setS3Endpoint(String s3Endpoint) {
        this.endpoint = s3Endpoint;
        this.s3Client.setEndpoint(s3Endpoint);
    }

    private static boolean credentialsEqual(AWSCredentials c1, AWSCredentials c2) {
        return c1 == null && c2 == null || c1 == null || c2 == null || c1.getAWSSecretKey() != null && c1.getAWSSecretKey().equals(c2.getAWSSecretKey()) && c1.getAWSAccessKeyId() != null && c1.getAWSAccessKeyId().equals(c2.getAWSAccessKeyId());
    }

    private synchronized void initializeNewClient(@Nonnull AWSCredentials credentials, @Nonnull String endpoint, @Nonnull Boolean https, @Nonnull Boolean useDns) {
        ClientConfiguration config = new ClientConfiguration();
        config.setConnectionTimeout(500);
        config.setSocketTimeout(10000);
        config.setUseReaper(true);
        config.setMaxConnections(512);
        Protocol protocol = https != false ? Protocol.HTTPS : Protocol.HTTP;
        config.setProtocol(protocol);
        this.clientConfig = config;
        this.s3Client = new AmazonS3Client(credentials, config);
        this.ops = new S3ClientOptions().withPathStyleAccess(useDns == false);
        this.s3Client.setS3ClientOptions(this.ops);
        this.instantiated = new Date();
        this.currentCredentials = credentials;
        this.setS3Endpoint(endpoint);
    }

    public void update(@Nonnull AWSCredentials credentials, @Nonnull String latestEndpoint, @Nonnull Boolean https, @Nonnull Boolean useDns) {
        Protocol tmpProto;
        if (this.s3Client == null || !OsgInternalS3Client.credentialsEqual(this.currentCredentials, credentials)) {
            this.initializeNewClient(credentials, latestEndpoint, https, useDns);
            return;
        }
        if (this.ops.isPathStyleAccess() == useDns.booleanValue()) {
            this.ops.setPathStyleAccess(useDns == false);
            this.s3Client.setS3ClientOptions(this.ops);
        }
        Protocol protocol = tmpProto = https != false ? Protocol.HTTPS : Protocol.HTTP;
        if (!tmpProto.equals((Object)this.clientConfig.getProtocol())) {
            this.clientConfig.setProtocol(tmpProto);
        }
        if (this.getS3Endpoint() == null || !this.getS3Endpoint().equals(latestEndpoint)) {
            this.setS3Endpoint(latestEndpoint);
        }
    }

    public Date getInstantiated() {
        return this.instantiated;
    }
}

