/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.client;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Transactions;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.apache.log4j.Logger;

@Entity
@PersistenceContext(name="eucalyptus_osg")
@Table(name="s3client_config")
@ConfigurableClass(root="objectstorage.s3client", description="Configuration for internal S3 clients.", singleton=true)
public class GenericS3ClientFactoryConfiguration
extends AbstractPersistent {
    private static final Logger LOG = Logger.getLogger(GenericS3ClientFactoryConfiguration.class);
    @ConfigurableField(description="Internal S3 client connection timeout in ms", displayName="connection_timeout", initial="10000")
    @Column(name="connection_timeout")
    private Integer connection_timeout_ms;
    private static final Integer DEFAULT_TIMEOUT_MS = new Integer(10000);
    @ConfigurableField(description="Internal S3 client maximum connections", displayName="max_connections", initial="64")
    @Column(name="max_connections")
    private Integer max_connections;
    private static final Integer DEFAULT_MAX_CONNECTIONS = new Integer(64);
    @ConfigurableField(description="Internal S3 client socket read timeout in ms", displayName="socket_read_timeout", initial="30000")
    @Column(name="socket_read_timeout_ms")
    private Integer socket_read_timeout_ms;
    private static final Integer DEFAULT_SOCKET_READ_TIMEOUT_MS = new Integer(30000);
    @ConfigurableField(description="Internal S3 client maximum retries on error", displayName="max_retries", initial="3")
    @Column(name="max_error_retries")
    private Integer max_error_retries;
    private static final Integer DEFAULT_MAX_ERROR_RETRIES = new Integer(3);
    @ConfigurableField(description="Internal S3 client buffer size", displayName="buffer_size", initial="524228")
    @Column(name="buffer_size")
    private Integer buffer_size;
    private static final Integer DEFAULT_BUFFER_SIZE = new Integer(524288);

    @PrePersist
    private void initialize() {
        if (this.connection_timeout_ms == null) {
            this.connection_timeout_ms = DEFAULT_TIMEOUT_MS;
        }
        if (this.max_connections == null) {
            this.max_connections = DEFAULT_MAX_CONNECTIONS;
        }
        if (this.socket_read_timeout_ms == null) {
            this.socket_read_timeout_ms = DEFAULT_SOCKET_READ_TIMEOUT_MS;
        }
        if (this.max_error_retries == null) {
            this.max_error_retries = DEFAULT_MAX_ERROR_RETRIES;
        }
        if (this.buffer_size == null) {
            this.buffer_size = DEFAULT_BUFFER_SIZE;
        }
    }

    public static GenericS3ClientFactoryConfiguration getInstance() {
        GenericS3ClientFactoryConfiguration config = null;
        try {
            config = (GenericS3ClientFactoryConfiguration)((Object)Transactions.find((Object)((Object)new GenericS3ClientFactoryConfiguration())));
        }
        catch (Exception e) {
            try {
                config = (GenericS3ClientFactoryConfiguration)((Object)Transactions.save((Object)((Object)new GenericS3ClientFactoryConfiguration())));
            }
            catch (Exception ex) {
                LOG.warn((Object)"failed to load and save configuration for internal S3 clients");
                config = new GenericS3ClientFactoryConfiguration();
                config.initialize();
            }
        }
        return config;
    }

    public Integer getConnection_timeout_ms() {
        return this.connection_timeout_ms;
    }

    public void setConnection_timeout_ms(Integer connection_timeout_ms) {
        this.connection_timeout_ms = connection_timeout_ms;
    }

    public Integer getMax_connections() {
        return this.max_connections;
    }

    public void setMax_connections(Integer max_connections) {
        this.max_connections = max_connections;
    }

    public Integer getSocket_read_timeout_ms() {
        return this.socket_read_timeout_ms;
    }

    public void setSocket_read_timeout_ms(Integer socket_read_timeout_ms) {
        this.socket_read_timeout_ms = socket_read_timeout_ms;
    }

    public Integer getMax_error_retries() {
        return this.max_error_retries;
    }

    public void setMax_error_retries(Integer max_error_retries) {
        this.max_error_retries = max_error_retries;
    }

    public Integer getBuffer_size() {
        return this.buffer_size;
    }

    public void setBuffer_size(Integer buffer_size) {
        this.buffer_size = buffer_size;
    }
}

