/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.client;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.Topology;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.objectstorage.client.GenericS3ClientFactoryConfiguration;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class GenericS3ClientFactory {
    private static final Logger LOG = Logger.getLogger(GenericS3ClientFactory.class);
    private static final Random randomizer = new Random(System.currentTimeMillis());

    public static AWSCredentialsProvider getEucaUserAWSCredentialsProvider(User user) {
        return new EucaUserCredentialsProvider(user);
    }

    protected static AmazonS3Client getS3ClientForUser(User clientUser, boolean useHttps) throws AuthException, NoSuchElementException {
        try {
            return GenericS3ClientFactory.getS3Client(GenericS3ClientFactory.getEucaUserAWSCredentialsProvider(clientUser), useHttps);
        }
        catch (Exception e) {
            LOG.error((Object)("Could not generate s3 client for user " + clientUser.getUserId() + " because no active access keys found."), (Throwable)e);
            throw new AuthException("No active access keys found for user", (Throwable)e);
        }
    }

    protected static ClientConfiguration getDefaultConfiguration(boolean withHttps) {
        ClientConfiguration config = new ClientConfiguration();
        config.setConnectionTimeout(GenericS3ClientFactoryConfiguration.getInstance().getConnection_timeout_ms().intValue());
        config.setMaxConnections(GenericS3ClientFactoryConfiguration.getInstance().getMax_connections().intValue());
        config.setMaxErrorRetry(GenericS3ClientFactoryConfiguration.getInstance().getMax_error_retries().intValue());
        config.setUseReaper(true);
        config.setSocketTimeout(GenericS3ClientFactoryConfiguration.getInstance().getSocket_read_timeout_ms().intValue());
        config.setProtocol(withHttps ? Protocol.HTTPS : Protocol.HTTP);
        return config;
    }

    public static S3ClientOptions getDefaultClientOptions() {
        S3ClientOptions ops = new S3ClientOptions();
        ops.setPathStyleAccess(true);
        return ops;
    }

    public static AmazonS3Client getS3Client(AWSCredentialsProvider provider, boolean https) throws NoSuchElementException {
        ClientConfiguration config = GenericS3ClientFactory.getDefaultConfiguration(https);
        AmazonS3Client s3Client = new AmazonS3Client(provider, config);
        s3Client.setS3ClientOptions(GenericS3ClientFactory.getDefaultClientOptions());
        s3Client.setEndpoint(GenericS3ClientFactory.getRandomOSGUri().toString());
        return s3Client;
    }

    public static AmazonS3Client getS3Client(AWSCredentials credentials, boolean https) throws NoSuchElementException {
        ClientConfiguration config = GenericS3ClientFactory.getDefaultConfiguration(https);
        AmazonS3Client s3Client = new AmazonS3Client(credentials, config);
        s3Client.setS3ClientOptions(GenericS3ClientFactory.getDefaultClientOptions());
        s3Client.setEndpoint(GenericS3ClientFactory.getRandomOSGUri().toString());
        return s3Client;
    }

    protected static URI getRandomOSGUri(boolean usePublicDns) throws NoSuchElementException {
        ArrayList osgs = Lists.newArrayList((Iterable)Topology.lookupMany(ObjectStorage.class, (Partition[])new Partition[0]));
        if (osgs == null || osgs.size() == 0) {
            throw new NoSuchElementException("No ENABLED OSGs found. Cannot generate client with no set endpoint");
        }
        int osgIndex = randomizer.nextInt(osgs.size());
        LOG.trace((Object)("Using osg index " + osgIndex + " from list: " + osgs));
        ServiceConfiguration conf = (ServiceConfiguration)osgs.get(osgIndex);
        if (usePublicDns) {
            return ServiceUris.remotePublicify((ServiceConfiguration)conf, (String[])new String[0]);
        }
        return ServiceUris.remote((ServiceConfiguration)conf, (String[])new String[0]);
    }

    protected static URI getRandomOSGUri() throws NoSuchElementException {
        return GenericS3ClientFactory.getRandomOSGUri(false);
    }

    static {
        System.setProperty("com.amazonaws.regions.RegionUtils.disableRemote", "disable");
        System.setProperty("com.amazonaws.sdk.s3.defaultStreamBufferSize", String.valueOf(GenericS3ClientFactoryConfiguration.getInstance().getBuffer_size()));
        System.setProperty("com.amazonaws.services.s3.disableGetObjectMD5Validation", "disable");
    }

    public static class EucaUserCredentialsProvider
    implements AWSCredentialsProvider {
        private User eucaUser;
        private AWSCredentials currentCredential;

        public EucaUserCredentialsProvider(User user) {
            this.eucaUser = user;
        }

        public synchronized AWSCredentials getCredentials() {
            if (this.currentCredential == null) {
                this.updateCreds();
            }
            return this.currentCredential;
        }

        protected void updateCreds() {
            try {
                AccessKey userAccessKey = (AccessKey)Iterables.find((Iterable)this.eucaUser.getKeys(), (Predicate)new Predicate<AccessKey>(){

                    public boolean apply(@Nullable AccessKey accessKey) {
                        return accessKey != null && accessKey.isActive() != false;
                    }
                });
                this.currentCredential = new BasicAWSCredentials(userAccessKey.getAccessKey(), userAccessKey.getSecretKey());
            }
            catch (AuthException e) {
                throw new RuntimeException("No active credentials for the user");
            }
        }

        public synchronized void refresh() {
            this.updateCreds();
        }
    }
}

