/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.hashing;

import com.eucalyptus.crypto.Digest;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;

public class HashUtils {
    public static String hash(String input) {
        byte[] inputBytes;
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        try {
            inputBytes = input.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("UTF-8 is not installed");
        }
        MessageDigest md = Digest.SHA1.get();
        return HashUtils.toHexString(md.digest(inputBytes));
    }

    private static String toHexString(byte[] b) {
        StringWriter s = new StringWriter();
        PrintWriter out = new PrintWriter(s);
        for (int i = 0; i < b.length; ++i) {
            out.printf("%02x", b[i]);
        }
        out.flush();
        return s.toString();
    }
}

