/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.domain.metricdata;

import com.eucalyptus.cloudwatch.domain.DimensionEntity;
import com.eucalyptus.cloudwatch.domain.metricdata.GetMetricStatisticsAggregationKey;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricEntity;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricEntityFactory;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricStatistics;
import com.eucalyptus.cloudwatch.domain.metricdata.SimpleMetricEntity;
import com.eucalyptus.cloudwatch.hashing.HashUtils;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.records.Logs;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class MetricManager {
    public static final Logger LOG = Logger.getLogger(MetricManager.class);

    public static void addMetric(String accountId, String metricName, String namespace, Map<String, String> dimensionMap, MetricEntity.MetricType metricType, MetricEntity.Units units, Date timestamp, Double sampleSize, Double sampleMax, Double sampleMin, Double sampleSum) {
        SimpleMetricEntity simpleMetricEntity = new SimpleMetricEntity();
        simpleMetricEntity.setAccountId(accountId);
        simpleMetricEntity.setDimensionMap(dimensionMap);
        simpleMetricEntity.setMetricName(metricName);
        simpleMetricEntity.setMetricType(metricType);
        simpleMetricEntity.setNamespace(namespace);
        simpleMetricEntity.setSampleMax(sampleMax);
        simpleMetricEntity.setSampleMin(sampleMin);
        simpleMetricEntity.setSampleSize(sampleSize);
        simpleMetricEntity.setSampleSum(sampleSum);
        simpleMetricEntity.setTimestamp(timestamp);
        simpleMetricEntity.setUnits(units);
        MetricManager.validateMetricQueueItem(simpleMetricEntity);
        MetricManager.addManyMetrics(MetricManager.makeMetricMap(MetricManager.foldAndHash(simpleMetricEntity)));
    }

    private static Multimap<Class, MetricEntity> makeMetricMap(Collection<MetricEntity> entities) {
        ArrayListMultimap metricMap = ArrayListMultimap.create();
        for (MetricEntity entity : entities) {
            metricMap.put((Object)MetricEntityFactory.getClassForEntitiesGet(entity.getMetricType(), entity.getDimensionHash()), (Object)entity);
        }
        return metricMap;
    }

    private static List<MetricEntity> foldAndHash(SimpleMetricEntity simpleMetricEntity) {
        if (simpleMetricEntity == null) {
            return new ArrayList<MetricEntity>();
        }
        TreeSet<DimensionEntity> dimensions = new TreeSet<DimensionEntity>();
        for (Map.Entry<String, String> entry : simpleMetricEntity.getDimensionMap().entrySet()) {
            DimensionEntity d = new DimensionEntity();
            d.setName(entry.getKey());
            d.setValue(entry.getValue());
            dimensions.add(d);
        }
        Set<TreeSet<DimensionEntity>> permutations = null;
        if (simpleMetricEntity.getMetricType() == MetricEntity.MetricType.System) {
            permutations = Sets.powerSet(dimensions);
        } else {
            permutations = Sets.newHashSet();
            permutations.add(dimensions);
        }
        ArrayList<MetricEntity> returnValue = new ArrayList<MetricEntity>();
        for (Set set : permutations) {
            String dimensionHash = MetricManager.hash(set);
            MetricEntity metric = MetricEntityFactory.getNewMetricEntity(simpleMetricEntity.getMetricType(), dimensionHash);
            metric.setAccountId(simpleMetricEntity.getAccountId());
            metric.setMetricName(simpleMetricEntity.getMetricName());
            metric.setNamespace(simpleMetricEntity.getNamespace());
            metric.setDimensions(dimensions);
            metric.setDimensionHash(dimensionHash);
            metric.setMetricType(simpleMetricEntity.getMetricType());
            metric.setUnits(simpleMetricEntity.getUnits());
            metric.setTimestamp(simpleMetricEntity.getTimestamp());
            metric.setSampleMax(simpleMetricEntity.getSampleMax());
            metric.setSampleMin(simpleMetricEntity.getSampleMin());
            metric.setSampleSum(simpleMetricEntity.getSampleSum());
            metric.setSampleSize(simpleMetricEntity.getSampleSize());
            returnValue.add(metric);
        }
        return returnValue;
    }

    private static void addManyMetrics(Multimap<Class, MetricEntity> metricMap) {
        for (Class c : metricMap.keySet()) {
            EntityTransaction db = Entities.get((Object)c);
            try {
                for (MetricEntity me : metricMap.get((Object)c)) {
                    Entities.persist((Object)((Object)me));
                }
                db.commit();
            }
            catch (RuntimeException ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
                throw ex;
            }
            finally {
                if (!db.isActive()) continue;
                db.rollback();
            }
        }
    }

    public static String hash(Map<String, String> dimensionMap) {
        TreeMap sortedDimensionMap = Maps.newTreeMap();
        if (dimensionMap != null) {
            sortedDimensionMap.putAll(dimensionMap);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : sortedDimensionMap.entrySet()) {
            sb.append((String)entry.getKey() + "|" + (String)entry.getValue() + "|");
        }
        return HashUtils.hash(sb.toString());
    }

    public static String hash(Collection<DimensionEntity> dimensions) {
        StringBuilder sb = new StringBuilder();
        for (DimensionEntity dimension : dimensions) {
            sb.append(dimension.getName() + "|" + dimension.getValue() + "|");
        }
        return HashUtils.hash(sb.toString());
    }

    public static Date stripSeconds(Date timestamp) {
        if (timestamp == null) {
            return timestamp;
        }
        long time = timestamp.getTime();
        time -= time % 60000L;
        return new Date(time);
    }

    public static void deleteAllMetrics() {
        for (Class c : MetricEntityFactory.getAllClassesForEntitiesGet()) {
            EntityTransaction db = Entities.get((Object)c);
            try {
                Entities.deleteAll((Class)c);
                db.commit();
            }
            catch (RuntimeException ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
                throw ex;
            }
            finally {
                if (!db.isActive()) continue;
                db.rollback();
            }
        }
    }

    public static void deleteMetrics(Date before) {
        for (Class c : MetricEntityFactory.getAllClassesForEntitiesGet()) {
            EntityTransaction db = Entities.get((Object)c);
            try {
                HashMap<String, Date> criteria = new HashMap<String, Date>();
                criteria.put("before", before);
                Entities.deleteAllMatching((Class)c, (String)"WHERE timestamp < :before", criteria);
                db.commit();
            }
            catch (RuntimeException ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
                throw ex;
            }
            finally {
                if (!db.isActive()) continue;
                db.rollback();
            }
        }
    }

    public static Collection<MetricStatistics> getMetricStatistics(String accountId, String metricName, String namespace, Map<String, String> dimensionMap, MetricEntity.MetricType metricType, MetricEntity.Units units, Date startTime, Date endTime, Integer period) {
        if (dimensionMap == null) {
            dimensionMap = new HashMap<String, String>();
        } else if (dimensionMap.size() > 10) {
            throw new IllegalArgumentException("Too many dimensions for metric, " + dimensionMap.size());
        }
        TreeSet<DimensionEntity> dimensions = new TreeSet<DimensionEntity>();
        for (Map.Entry<String, String> entry : dimensionMap.entrySet()) {
            DimensionEntity d = new DimensionEntity();
            d.setName(entry.getKey());
            d.setValue(entry.getValue());
            dimensions.add(d);
        }
        Date now = new Date();
        if (endTime == null) {
            endTime = now;
        }
        if (startTime == null) {
            startTime = new Date(now.getTime() - 3600000L);
        }
        if ((startTime = MetricManager.stripSeconds(startTime)).after(endTime = MetricManager.stripSeconds(endTime))) {
            throw new IllegalArgumentException("Start time must be after end time");
        }
        if (period == null) {
            period = 60;
        }
        if (period % 60 != 0) {
            throw new IllegalArgumentException("Period must be a multiple of 60");
        }
        if (period < 0) {
            throw new IllegalArgumentException("Period must be greater than 0");
        }
        if (period == 0) {
            throw new IllegalArgumentException("Period must not equal 0");
        }
        if (metricType == null) {
            throw new IllegalArgumentException("metricType must not be null");
        }
        if (accountId == null) {
            throw new IllegalArgumentException("accountId must not be null");
        }
        if (metricName == null) {
            throw new IllegalArgumentException("metricName must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace must not be null");
        }
        String hash = MetricManager.hash(dimensions);
        Class metricEntityClass = MetricEntityFactory.getClassForEntitiesGet(metricType, hash);
        TreeMap<GetMetricStatisticsAggregationKey, MetricStatistics> aggregationMap = new TreeMap<GetMetricStatisticsAggregationKey, MetricStatistics>(GetMetricStatisticsAggregationKey.COMPARATOR_WITH_NULLS.INSTANCE);
        EntityTransaction db = Entities.get((Object)metricEntityClass);
        try {
            Criteria criteria = Entities.createCriteria((Class)metricEntityClass);
            criteria = criteria.add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
            criteria = criteria.add((Criterion)Restrictions.eq((String)"metricName", (Object)metricName));
            criteria = criteria.add((Criterion)Restrictions.eq((String)"namespace", (Object)namespace));
            criteria = criteria.add((Criterion)Restrictions.lt((String)"timestamp", (Object)endTime));
            criteria = criteria.add((Criterion)Restrictions.ge((String)"timestamp", (Object)startTime));
            criteria = criteria.add((Criterion)Restrictions.eq((String)"dimensionHash", (Object)hash));
            if (units != null) {
                criteria = criteria.add((Criterion)Restrictions.eq((String)"units", (Object)((Object)units)));
            }
            criteria = criteria.addOrder(Order.asc((String)"creationTimestamp"));
            criteria = criteria.addOrder(Order.asc((String)"naturalId"));
            List results = criteria.list();
            for (Object o : results) {
                MetricEntity me = (MetricEntity)((Object)o);
                GetMetricStatisticsAggregationKey key = new GetMetricStatisticsAggregationKey(me, startTime, period, hash);
                MetricStatistics item = new MetricStatistics(me, startTime, period, dimensions);
                if (!aggregationMap.containsKey(key)) {
                    aggregationMap.put(key, item);
                    continue;
                }
                MetricStatistics totalSoFar = (MetricStatistics)aggregationMap.get(key);
                totalSoFar.setSampleMax(Math.max(item.getSampleMax(), totalSoFar.getSampleMax()));
                totalSoFar.setSampleMin(Math.min(item.getSampleMin(), totalSoFar.getSampleMin()));
                totalSoFar.setSampleSize(totalSoFar.getSampleSize() + item.getSampleSize());
                totalSoFar.setSampleSum(totalSoFar.getSampleSum() + item.getSampleSum());
            }
            db.commit();
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
        return Lists.newArrayList(aggregationMap.values());
    }

    public static Date getPeriodStart(Date originalTimestamp, Date startTime, Integer period) {
        long difference = originalTimestamp.getTime() - startTime.getTime();
        long remainderInOnePeriod = difference % (1000L * (long)period.intValue());
        return new Date(originalTimestamp.getTime() - remainderInOnePeriod);
    }

    public static Collection<MetricEntity> getAllMetrics() {
        ArrayList<MetricEntity> allResults = new ArrayList<MetricEntity>();
        for (Class c : MetricEntityFactory.getAllClassesForEntitiesGet()) {
            EntityTransaction db = Entities.get((Object)c);
            try {
                Criteria criteria = Entities.createCriteria((Class)c);
                criteria = criteria.addOrder(Order.asc((String)"creationTimestamp"));
                criteria = criteria.addOrder(Order.asc((String)"naturalId"));
                List dbResults = criteria.list();
                for (Object result : dbResults) {
                    allResults.add((MetricEntity)((Object)result));
                }
                db.commit();
            }
            catch (RuntimeException ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
                throw ex;
            }
            finally {
                if (!db.isActive()) continue;
                db.rollback();
            }
        }
        return allResults;
    }

    public static void addMetricBatch(List<SimpleMetricEntity> dataBatch) {
        ArrayList<MetricEntity> metricEntities = new ArrayList<MetricEntity>();
        for (SimpleMetricEntity simpleMetricEntity : dataBatch) {
            MetricManager.validateMetricQueueItem(simpleMetricEntity);
            metricEntities.addAll(MetricManager.foldAndHash(simpleMetricEntity));
        }
        MetricManager.addManyMetrics(MetricManager.makeMetricMap(metricEntities));
    }

    private static void validateMetricQueueItem(SimpleMetricEntity simpleMetricEntity) {
        LOG.trace((Object)("metricName=" + simpleMetricEntity.getMetricName()));
        LOG.trace((Object)("namespace=" + simpleMetricEntity.getNamespace()));
        LOG.trace((Object)("dimensionMap=" + simpleMetricEntity.getDimensionMap()));
        LOG.trace((Object)("metricType=" + (Object)((Object)simpleMetricEntity.getMetricType())));
        LOG.trace((Object)("units=" + (Object)((Object)simpleMetricEntity.getUnits())));
        LOG.trace((Object)("timestamp=" + simpleMetricEntity.getTimestamp()));
        LOG.trace((Object)("sampleSize=" + simpleMetricEntity.getSampleSize()));
        LOG.trace((Object)("sampleMax=" + simpleMetricEntity.getSampleMax()));
        LOG.trace((Object)("sampleMin=" + simpleMetricEntity.getSampleMin()));
        LOG.trace((Object)("sampleSum=" + simpleMetricEntity.getSampleSum()));
        if (simpleMetricEntity.getDimensionMap() == null) {
            simpleMetricEntity.setDimensionMap(new HashMap<String, String>());
        } else if (simpleMetricEntity.getDimensionMap().size() > 10) {
            throw new IllegalArgumentException("Too many dimensions for metric, " + simpleMetricEntity.getDimensionMap().size());
        }
        simpleMetricEntity.setTimestamp(MetricManager.stripSeconds(simpleMetricEntity.getTimestamp()));
    }
}

