/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.domain.metricdata;

import com.eucalyptus.cloudwatch.domain.AbstractPersistentWithDimensions;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricManager;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
public abstract class MetricEntity
extends AbstractPersistentWithDimensions {
    @Column(name="account_id", nullable=false)
    private String accountId;
    @Column(name="namespace", nullable=false)
    private String namespace;
    @Column(name="metric_name", nullable=false)
    private String metricName;
    @Column(name="dimension_hash", nullable=false)
    private String dimensionHash;
    @Column(name="units", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private Units units;
    @Column(name="metric_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private MetricType metricType;
    @Column(name="timestamp", nullable=false)
    private Date timestamp;
    @Column(name="sample_size", nullable=false)
    private Double sampleSize;
    @Column(name="sample_max", nullable=false)
    private Double sampleMax;
    @Column(name="sample_min", nullable=false)
    private Double sampleMin;
    @Column(name="sample_sum", nullable=false)
    private Double sampleSum;

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getDimensionHash() {
        return this.dimensionHash;
    }

    public void setDimensionHash(String dimensionHash) {
        this.dimensionHash = dimensionHash;
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        this.units = units;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public void setMetricType(MetricType metricType) {
        this.metricType = metricType;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = MetricManager.stripSeconds(timestamp);
    }

    public Double getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(Double sampleSize) {
        this.sampleSize = sampleSize;
    }

    public Double getSampleMax() {
        return this.sampleMax;
    }

    public void setSampleMax(Double sampleMax) {
        this.sampleMax = sampleMax;
    }

    public Double getSampleMin() {
        return this.sampleMin;
    }

    public void setSampleMin(Double sampleMin) {
        this.sampleMin = sampleMin;
    }

    public Double getSampleSum() {
        return this.sampleSum;
    }

    public void setSampleSum(Double sampleSum) {
        this.sampleSum = sampleSum;
    }

    public String toString() {
        return "MetricEntity [accountId=" + this.accountId + ", namespace=" + this.namespace + ", metricName=" + this.metricName + ", dimensionHash=" + this.dimensionHash + ", units=" + (Object)((Object)this.units) + ", metricType=" + (Object)((Object)this.metricType) + ", timestamp=" + this.timestamp + ", sampleSize=" + this.sampleSize + ", sampleMax=" + this.sampleMax + ", sampleMin=" + this.sampleMin + ", sampleSum=" + this.sampleSum + ", getDimensions()=" + this.getDimensions() + "]";
    }

    public static enum Units {
        Seconds,
        Microseconds,
        Milliseconds,
        Bytes,
        Kilobytes,
        Megabytes,
        Gigabytes,
        Terabytes,
        Bits,
        Kilobits,
        Megabits,
        Gigabits,
        Terabits,
        Percent,
        Count,
        BytesPerSecond("Bytes/Second"),
        KilobytesPerSecond("Kilobytes/Second"),
        MegabytesPerSecond("Megabytes/Second"),
        GigabytesPerSecond("Gigabytes/Second"),
        TerabytesPerSecond("Terabytes/Second"),
        BitsPerSecond("Bits/Second"),
        KilobitsPerSecond("Kilobits/Second"),
        MegabitsPerSecond("Megabits/Second"),
        GigabitsPerSecond("Gigabits/Second"),
        TerabitsPerSecond("Terabits/Second"),
        CountPerSecond("Count/Second"),
        None("None");

        private String value;

        private Units() {
            this.value = this.name();
        }

        private Units(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static Units fromValue(String value) {
            for (Units units : Units.values()) {
                if (!units.value.equals(value)) continue;
                return units;
            }
            throw new IllegalArgumentException("Unknown unit " + value);
        }
    }

    public static enum MetricType {
        Custom,
        System;

    }
}

