/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.domain.metricdata;

import com.eucalyptus.cloudwatch.common.backend.msgs.Dimension;
import com.eucalyptus.cloudwatch.common.backend.msgs.Dimensions;
import com.eucalyptus.cloudwatch.common.backend.msgs.MetricDatum;
import com.eucalyptus.cloudwatch.common.backend.msgs.StatisticSet;
import com.eucalyptus.cloudwatch.domain.absolute.AbsoluteMetricHelper;
import com.eucalyptus.cloudwatch.domain.absolute.AbsoluteMetricHistory;
import com.eucalyptus.cloudwatch.domain.listmetrics.ListMetricManager;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricEntity;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricManager;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricQueueItem;
import com.eucalyptus.cloudwatch.domain.metricdata.PutMetricDataAggregationKey;
import com.eucalyptus.cloudwatch.domain.metricdata.SimpleMetricEntity;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.records.Logs;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class MetricDataQueue {
    private static final Logger LOG = Logger.getLogger(MetricDataQueue.class);
    static final LinkedBlockingQueue<MetricQueueItem> dataQueue = new LinkedBlockingQueue();
    private static final ScheduledExecutorService dataFlushTimer = Executors.newSingleThreadScheduledExecutor();
    private static MetricDataQueue singleton = MetricDataQueue.getInstance();
    private static Runnable safeRunner = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long before = System.currentTimeMillis();
            try {
                List<Object> dataBatch = Lists.newArrayList();
                dataQueue.drainTo(dataBatch, 15000);
                LOG.debug((Object)("Timing:dataBatch.size()=" + dataBatch.size()));
                long t1 = System.currentTimeMillis();
                dataBatch = MetricDataQueue.dealWithAbsoluteMetrics(dataBatch);
                long t2 = System.currentTimeMillis();
                LOG.debug((Object)("Timing:dataBatch.dealWithAbsoluteMetrics():time=" + (t2 - t1)));
                List<SimpleMetricEntity> simpleDataBatch = MetricDataQueue.convertToSimpleDataBatch(dataBatch);
                long t3 = System.currentTimeMillis();
                LOG.debug((Object)("Timing:dataBatch.convertToSimpleDataBatch():time=" + (t3 - t2)));
                simpleDataBatch = MetricDataQueue.aggregate(simpleDataBatch);
                long t4 = System.currentTimeMillis();
                LOG.debug((Object)("Timing:dataBatch.aggregate():time=" + (t4 - t3)));
                MetricManager.addMetricBatch(simpleDataBatch);
                long t5 = System.currentTimeMillis();
                LOG.debug((Object)("Timing:dataBatch.MetricManager.addMetricBatch():time=" + (t5 - t4)));
                ListMetricManager.addMetricBatch(simpleDataBatch);
                long t6 = System.currentTimeMillis();
                LOG.debug((Object)("Timing:ListMetricManager.addMetricBatch:time=" + (t6 - t5)));
            }
            catch (Throwable ex) {
                LOG.debug((Object)"error");
                ex.printStackTrace();
                LOG.error((Object)ex, ex);
            }
            finally {
                long after = System.currentTimeMillis();
                LOG.debug((Object)("Timing:time=" + (after - before)));
            }
        }
    };
    private static final Map<String, String> EBS_ABSOLUTE_METRICS;
    private static final Map<String, String> EC2_ABSOLUTE_METRICS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetricDataQueue getInstance() {
        Class<MetricDataQueue> clazz = MetricDataQueue.class;
        synchronized (MetricDataQueue.class) {
            if (singleton == null) {
                singleton = new MetricDataQueue();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private void queue(Supplier<MetricQueueItem> metriMetaDataSupplier) {
        MetricQueueItem metricData = (MetricQueueItem)metriMetaDataSupplier.get();
        dataQueue.offer(metricData);
    }

    public static List<SimpleMetricEntity> aggregate(List<SimpleMetricEntity> dataBatch) {
        HashMap aggregationMap = Maps.newHashMap();
        for (SimpleMetricEntity item : dataBatch) {
            item.setTimestamp(MetricManager.stripSeconds(item.getTimestamp()));
            PutMetricDataAggregationKey key = new PutMetricDataAggregationKey(item);
            if (!aggregationMap.containsKey(key)) {
                aggregationMap.put(key, new SimpleMetricEntity(item));
                continue;
            }
            SimpleMetricEntity totalSoFar = (SimpleMetricEntity)aggregationMap.get(key);
            totalSoFar.setSampleMax(Math.max(item.getSampleMax(), totalSoFar.getSampleMax()));
            totalSoFar.setSampleMin(Math.min(item.getSampleMin(), totalSoFar.getSampleMin()));
            totalSoFar.setSampleSize(totalSoFar.getSampleSize() + item.getSampleSize());
            totalSoFar.setSampleSum(totalSoFar.getSampleSum() + item.getSampleSum());
        }
        return Lists.newArrayList(aggregationMap.values());
    }

    protected static List<SimpleMetricEntity> convertToSimpleDataBatch(List<MetricQueueItem> stupidDataBatch) {
        ArrayList<SimpleMetricEntity> returnValue = new ArrayList<SimpleMetricEntity>();
        for (MetricQueueItem item : stupidDataBatch) {
            SimpleMetricEntity metricMetadata = new SimpleMetricEntity();
            metricMetadata.setAccountId(item.getAccountId());
            MetricDatum datum = item.getMetricDatum();
            metricMetadata.setMetricName(datum.getMetricName());
            metricMetadata.setNamespace(item.getNamespace());
            ArrayList dimensions = datum.getDimensions() == null ? Collections.emptyList() : datum.getDimensions().getMember();
            metricMetadata.setDimensionMap(MetricDataQueue.makeDimensionMap(dimensions));
            metricMetadata.setMetricType(item.getMetricType());
            metricMetadata.setUnits(MetricEntity.Units.fromValue(datum.getUnit()));
            metricMetadata.setTimestamp(datum.getTimestamp());
            if (datum.getValue() != null) {
                metricMetadata.setSampleMax(datum.getValue());
                metricMetadata.setSampleMin(datum.getValue());
                metricMetadata.setSampleSum(datum.getValue());
                metricMetadata.setSampleSize(1.0);
            } else if (datum.getStatisticValues() != null && datum.getStatisticValues().getMaximum() != null && datum.getStatisticValues().getMinimum() != null && datum.getStatisticValues().getSum() != null && datum.getStatisticValues().getSampleCount() != null) {
                metricMetadata.setSampleMax(datum.getStatisticValues().getMaximum());
                metricMetadata.setSampleMin(datum.getStatisticValues().getMinimum());
                metricMetadata.setSampleSum(datum.getStatisticValues().getSum());
                metricMetadata.setSampleSize(datum.getStatisticValues().getSampleCount());
            } else {
                throw new RuntimeException("Statistics set (all values) or Value must be set");
            }
            returnValue.add(metricMetadata);
        }
        return returnValue;
    }

    protected static List<MetricQueueItem> dealWithAbsoluteMetrics(List<MetricQueueItem> dataBatch) {
        ArrayList<MetricQueueItem> dataToInsert = new ArrayList<MetricQueueItem>();
        EntityTransaction db = Entities.get(AbsoluteMetricHistory.class);
        try {
            AbsoluteMetricCache cache = new AbsoluteMetricCache(db);
            for (MetricQueueItem item : dataBatch) {
                String accountId = item.getAccountId();
                String nameSpace = item.getNamespace();
                MetricDatum datum = item.getMetricDatum();
                MetricEntity.MetricType metricType = item.getMetricType();
                if ("AWS/EBS".equals(nameSpace) && metricType == MetricEntity.MetricType.System) {
                    String volumeId = null;
                    if (datum.getDimensions() != null && datum.getDimensions().getMember() != null) {
                        for (Dimension dimension : datum.getDimensions().getMember()) {
                            if (!"VolumeId".equals(dimension.getName())) continue;
                            volumeId = dimension.getValue();
                            cache.load(nameSpace, "VolumeId", volumeId);
                        }
                    }
                    if (EBS_ABSOLUTE_METRICS.containsKey(datum.getMetricName()) && !MetricDataQueue.adjustAbsoluteVolumeStatisticSet(cache, datum, datum.getMetricName(), EBS_ABSOLUTE_METRICS.get(datum.getMetricName()), volumeId)) continue;
                    if ("VolumeReadOps".equals(datum.getMetricName())) {
                        dataToInsert.add(MetricDataQueue.createVolumeThroughputMetric(accountId, nameSpace, metricType, datum));
                    }
                    if ("VolumeTotalReadWriteTime".equals(datum.getMetricName())) {
                        MetricDataQueue.convertVolumeTotalReadWriteTimeToVolumeIdleTime(datum);
                    }
                    if ("VolumeQueueLength".equals(datum.getMetricName()) && !MetricDataQueue.adjustAbsoluteVolumeQueueLengthStatisticSet(cache, datum, volumeId)) continue;
                }
                if ("AWS/EC2".equals(nameSpace) && metricType == MetricEntity.MetricType.System) {
                    String instanceId = null;
                    if (datum.getDimensions() != null && datum.getDimensions().getMember() != null) {
                        for (Dimension dimension : datum.getDimensions().getMember()) {
                            if (!"InstanceId".equals(dimension.getName())) continue;
                            instanceId = dimension.getValue();
                            cache.load(nameSpace, "InstanceId", instanceId);
                        }
                    }
                    if (EC2_ABSOLUTE_METRICS.containsKey(datum.getMetricName()) ? !MetricDataQueue.adjustAbsoluteInstanceStatisticSet(cache, datum, datum.getMetricName(), EC2_ABSOLUTE_METRICS.get(datum.getMetricName()), instanceId) : "CPUUtilizationMSAbsolute".equals(datum.getMetricName()) && !MetricDataQueue.adjustAbsoluteInstanceCPUStatisticSet(cache, datum, "CPUUtilizationMSAbsolute", "CPUUtilization", instanceId)) continue;
                }
                dataToInsert.add(item);
            }
            db.commit();
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
        return dataToInsert;
    }

    public void insertMetricData(final String ownerAccountId, final String nameSpace, List<MetricDatum> metricDatum, final MetricEntity.MetricType metricType) {
        Date now = new Date();
        for (final MetricDatum datum : metricDatum) {
            this.scrub(datum, now);
            this.queue(new Supplier<MetricQueueItem>(){

                public MetricQueueItem get() {
                    MetricQueueItem metricMetadata = new MetricQueueItem();
                    metricMetadata.setAccountId(ownerAccountId);
                    metricMetadata.setMetricDatum(datum);
                    metricMetadata.setNamespace(nameSpace);
                    metricMetadata.setMetricType(metricType);
                    return metricMetadata;
                }
            });
        }
    }

    private static boolean adjustAbsoluteVolumeQueueLengthStatisticSet(AbsoluteMetricCache cache, MetricDatum datum, String volumeId) {
        MetricDatum absolutePlaceHolder = new MetricDatum();
        absolutePlaceHolder.setMetricName("VolumeQueueLengthPlaceHolderAbsolute");
        absolutePlaceHolder.setValue(Double.valueOf(0.0));
        absolutePlaceHolder.setTimestamp(datum.getTimestamp());
        if (!MetricDataQueue.adjustAbsoluteVolumeStatisticSet(cache, absolutePlaceHolder, absolutePlaceHolder.getMetricName(), "VolumeQueueLengthPlaceHolder", volumeId)) {
            return false;
        }
        double sampleCount = absolutePlaceHolder.getStatisticValues().getSampleCount();
        double value = datum.getValue();
        datum.setValue(null);
        StatisticSet statisticSet = new StatisticSet();
        statisticSet.setMaximum(Double.valueOf(value));
        statisticSet.setMinimum(Double.valueOf(value));
        statisticSet.setSum(Double.valueOf(value * sampleCount));
        statisticSet.setSampleCount(Double.valueOf(sampleCount));
        datum.setStatisticValues(statisticSet);
        return true;
    }

    private static void convertVolumeTotalReadWriteTimeToVolumeIdleTime(MetricDatum datum) {
        datum.setMetricName("VolumeIdleTime");
        double totalReadWriteTime = datum.getStatisticValues().getSum();
        double totalPeriodTime = 60.0 * datum.getStatisticValues().getSampleCount();
        double totalIdleTime = totalPeriodTime - totalReadWriteTime;
        if (totalIdleTime < 0.0) {
            totalIdleTime = 0.0;
        }
        datum.getStatisticValues().setSum(Double.valueOf(totalIdleTime));
        double averageIdleTime = totalIdleTime / datum.getStatisticValues().getSampleCount();
        datum.getStatisticValues().setMaximum(Double.valueOf(averageIdleTime));
        datum.getStatisticValues().setMinimum(Double.valueOf(averageIdleTime));
    }

    private static MetricQueueItem createVolumeThroughputMetric(String accountId, String nameSpace, MetricEntity.MetricType metricType, MetricDatum datum) {
        MetricDatum vtpDatum = new MetricDatum();
        vtpDatum.setMetricName("VolumeThroughputPercentage");
        vtpDatum.setTimestamp(datum.getTimestamp());
        vtpDatum.setUnit(MetricEntity.Units.Percent.toString());
        if (datum.getValue() != null) {
            vtpDatum.setValue(Double.valueOf(100.0));
        } else if (datum.getStatisticValues() != null) {
            StatisticSet statisticSet = new StatisticSet();
            statisticSet.setMaximum(Double.valueOf(100.0));
            statisticSet.setMinimum(Double.valueOf(100.0));
            statisticSet.setSum(Double.valueOf(100.0 * datum.getStatisticValues().getSampleCount()));
            statisticSet.setSampleCount(datum.getStatisticValues().getSampleCount());
            vtpDatum.setStatisticValues(statisticSet);
        }
        Dimensions vtpDimensions = new Dimensions();
        ArrayList<Dimension> vtpDimensionsMember = new ArrayList<Dimension>();
        if (datum.getDimensions() != null) {
            for (Dimension dimension : datum.getDimensions().getMember()) {
                Dimension vtpDimension = new Dimension();
                vtpDimension.setName(dimension.getName());
                vtpDimension.setValue(dimension.getValue());
                vtpDimensionsMember.add(vtpDimension);
            }
        }
        vtpDimensions.setMember(vtpDimensionsMember);
        vtpDatum.setDimensions(vtpDimensions);
        MetricQueueItem vtpQueueItem = new MetricQueueItem();
        vtpQueueItem.setAccountId(accountId);
        vtpQueueItem.setMetricType(metricType);
        vtpQueueItem.setNamespace(nameSpace);
        vtpQueueItem.setMetricDatum(vtpDatum);
        return vtpQueueItem;
    }

    private static boolean adjustAbsoluteInstanceCPUStatisticSet(AbsoluteMetricCache cache, MetricDatum datum, String absoluteMetricName, String relativeMetricName, String instanceId) {
        AbsoluteMetricHelper.MetricDifferenceInfo info = AbsoluteMetricHelper.calculateDifferenceSinceLastEvent(cache, "AWS/EC2", absoluteMetricName, "InstanceId", instanceId, datum.getTimestamp(), datum.getValue());
        if (info != null) {
            double percentage = 0.0;
            if (info.getElapsedTimeInMillis() != 0L) {
                percentage = 100.0 * (info.getValueDifference() / (double)info.getElapsedTimeInMillis().longValue());
            }
            datum.setMetricName(relativeMetricName);
            datum.setValue(null);
            StatisticSet statisticSet = new StatisticSet();
            statisticSet.setMaximum(Double.valueOf(percentage));
            statisticSet.setMinimum(Double.valueOf(percentage));
            double sampleCount = (double)info.getElapsedTimeInMillis().longValue() / 60000.0;
            statisticSet.setSum(Double.valueOf(sampleCount * percentage));
            statisticSet.setSampleCount(Double.valueOf(sampleCount));
            datum.setStatisticValues(statisticSet);
            datum.setUnit(MetricEntity.Units.Percent.toString());
            return true;
        }
        return false;
    }

    private static boolean adjustAbsoluteInstanceStatisticSet(AbsoluteMetricCache cache, MetricDatum datum, String absoluteMetricName, String relativeMetricName, String instanceId) {
        if (instanceId == null) {
            return false;
        }
        AbsoluteMetricHelper.MetricDifferenceInfo info = AbsoluteMetricHelper.calculateDifferenceSinceLastEvent(cache, "AWS/EC2", absoluteMetricName, "InstanceId", instanceId, datum.getTimestamp(), datum.getValue());
        if (info != null) {
            datum.setMetricName(relativeMetricName);
            datum.setValue(null);
            StatisticSet statisticSet = new StatisticSet();
            double sampleCount = (double)info.getElapsedTimeInMillis().longValue() / 60000.0;
            statisticSet.setSum(info.getValueDifference());
            statisticSet.setMaximum(Double.valueOf(info.getValueDifference() / sampleCount));
            statisticSet.setMinimum(Double.valueOf(info.getValueDifference() / sampleCount));
            statisticSet.setSampleCount(Double.valueOf(sampleCount));
            datum.setStatisticValues(statisticSet);
            return true;
        }
        return false;
    }

    private static boolean adjustAbsoluteVolumeStatisticSet(AbsoluteMetricCache cache, MetricDatum datum, String absoluteMetricName, String relativeMetricName, String volumeId) {
        if (volumeId == null) {
            return false;
        }
        AbsoluteMetricHelper.MetricDifferenceInfo info = AbsoluteMetricHelper.calculateDifferenceSinceLastEvent(cache, "AWS/EBS", absoluteMetricName, "VolumeId", volumeId, datum.getTimestamp(), datum.getValue());
        if (info != null) {
            datum.setMetricName(relativeMetricName);
            datum.setValue(null);
            StatisticSet statisticSet = new StatisticSet();
            double sampleCount = (double)info.getElapsedTimeInMillis().longValue() / 60000.0;
            statisticSet.setSum(info.getValueDifference());
            statisticSet.setMaximum(Double.valueOf(info.getValueDifference() / sampleCount));
            statisticSet.setMinimum(Double.valueOf(info.getValueDifference() / sampleCount));
            statisticSet.setSampleCount(Double.valueOf(sampleCount));
            datum.setStatisticValues(statisticSet);
            return true;
        }
        return false;
    }

    private void scrub(MetricDatum datum, Date now) {
        if (datum.getUnit() == null || datum.getUnit().trim().isEmpty()) {
            datum.setUnit(MetricEntity.Units.None.toString());
        }
        if (datum.getTimestamp() == null) {
            datum.setTimestamp(now);
        }
    }

    private static Map<String, String> makeDimensionMap(List<Dimension> dimensions) {
        TreeMap returnValue = Maps.newTreeMap();
        for (Dimension dimension : dimensions) {
            returnValue.put(dimension.getName(), dimension.getValue());
        }
        return returnValue;
    }

    static {
        dataFlushTimer.scheduleAtFixedRate(safeRunner, 0L, 1L, TimeUnit.MINUTES);
        EBS_ABSOLUTE_METRICS = new ImmutableMap.Builder().put((Object)"VolumeReadOpsAbsolute", (Object)"VolumeReadOps").put((Object)"VolumeWriteOpsAbsolute", (Object)"VolumeWriteOps").put((Object)"VolumeReadBytesAbsolute", (Object)"VolumeReadBytes").put((Object)"VolumeWriteBytesAbsolute", (Object)"VolumeWriteBytes").put((Object)"VolumeConsumedReadWriteOpsAbsolute", (Object)"VolumeConsumedReadWriteOps").put((Object)"VolumeTotalReadTimeAbsolute", (Object)"VolumeTotalReadTime").put((Object)"VolumeTotalWriteTimeAbsolute", (Object)"VolumeTotalWriteTime").put((Object)"VolumeTotalReadWriteTimeAbsolute", (Object)"VolumeTotalReadWriteTime").build();
        EC2_ABSOLUTE_METRICS = new ImmutableMap.Builder().put((Object)"DiskReadOpsAbsolute", (Object)"DiskReadOps").put((Object)"DiskWriteOpsAbsolute", (Object)"DiskWriteOps").put((Object)"DiskReadBytesAbsolute", (Object)"DiskReadBytes").put((Object)"DiskWriteBytesAbsolute", (Object)"DiskWriteBytes").put((Object)"NetworkInAbsolute", (Object)"NetworkIn").put((Object)"NetworkOutAbsolute", (Object)"NetworkOut").build();
    }

    public static class AbsoluteMetricCacheKey {
        private String namespace;
        private String metricName;
        private String dimensionName;
        private String dimensionValue;

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public String getDimensionName() {
            return this.dimensionName;
        }

        public void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        public String getDimensionValue() {
            return this.dimensionValue;
        }

        public void setDimensionValue(String dimensionValue) {
            this.dimensionValue = dimensionValue;
        }

        public AbsoluteMetricCacheKey(String namespace, String metricName, String dimensionName, String dimensionValue) {
            this.namespace = namespace;
            this.metricName = metricName;
            this.dimensionName = dimensionName;
            this.dimensionValue = dimensionValue;
        }

        public AbsoluteMetricCacheKey(AbsoluteMetricHistory item) {
            this.namespace = item.getNamespace();
            this.metricName = item.getMetricName();
            this.dimensionName = item.getDimensionName();
            this.dimensionValue = item.getDimensionValue();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dimensionName == null ? 0 : this.dimensionName.hashCode());
            result = 31 * result + (this.dimensionValue == null ? 0 : this.dimensionValue.hashCode());
            result = 31 * result + (this.metricName == null ? 0 : this.metricName.hashCode());
            result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AbsoluteMetricCacheKey other = (AbsoluteMetricCacheKey)obj;
            if (this.dimensionName == null ? other.dimensionName != null : !this.dimensionName.equals(other.dimensionName)) {
                return false;
            }
            if (this.dimensionValue == null ? other.dimensionValue != null : !this.dimensionValue.equals(other.dimensionValue)) {
                return false;
            }
            if (this.metricName == null ? other.metricName != null : !this.metricName.equals(other.metricName)) {
                return false;
            }
            return !(this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace));
        }
    }

    public static class AbsoluteMetricLoadCacheKey {
        private String namespace;
        private String dimensionName;

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getDimensionName() {
            return this.dimensionName;
        }

        public void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        private AbsoluteMetricLoadCacheKey(String namespace, String dimensionName) {
            this.namespace = namespace;
            this.dimensionName = dimensionName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dimensionName == null ? 0 : this.dimensionName.hashCode());
            result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AbsoluteMetricLoadCacheKey other = (AbsoluteMetricLoadCacheKey)obj;
            if (this.dimensionName == null ? other.dimensionName != null : !this.dimensionName.equals(other.dimensionName)) {
                return false;
            }
            return !(this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace));
        }
    }

    public static class AbsoluteMetricCache {
        private EntityTransaction db;
        private Set<AbsoluteMetricLoadCacheKey> loaded = Sets.newHashSet();
        private Map<AbsoluteMetricCacheKey, AbsoluteMetricHistory> cacheMap = Maps.newHashMap();

        public AbsoluteMetricCache(EntityTransaction db) {
            this.db = db;
        }

        public void load(String namespace, String dimensionName, String dimensionValue) {
            AbsoluteMetricLoadCacheKey loadKey = new AbsoluteMetricLoadCacheKey(namespace, dimensionName);
            if (!this.loaded.contains(loadKey)) {
                Criteria criteria = Entities.createCriteria(AbsoluteMetricHistory.class).add((Criterion)Restrictions.eq((String)"namespace", (Object)namespace)).add((Criterion)Restrictions.eq((String)"dimensionName", (Object)dimensionName));
                List list = criteria.list();
                for (AbsoluteMetricHistory item : list) {
                    this.cacheMap.put(new AbsoluteMetricCacheKey(item), item);
                }
                this.loaded.add(loadKey);
            }
        }

        public AbsoluteMetricHistory lookup(String namespace, String metricName, String dimensionName, String dimensionValue) {
            return this.cacheMap.get(new AbsoluteMetricCacheKey(namespace, metricName, dimensionName, dimensionValue));
        }

        public void put(String namespace, String metricName, String dimensionName, String dimensionValue, AbsoluteMetricHistory lastEntity) {
            this.cacheMap.put(new AbsoluteMetricCacheKey(namespace, metricName, dimensionName, dimensionValue), lastEntity);
        }
    }
}

