/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.domain.metricdata;

import com.eucalyptus.cloudwatch.domain.metricdata.MetricEntity;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricManager;
import java.util.Comparator;
import java.util.Date;

public class GetMetricStatisticsAggregationKey {
    private String accountId;
    private String namespace;
    private String metricName;
    private MetricEntity.Units units;
    private MetricEntity.MetricType metricType;
    private Date timestamp;
    private String dimensionHash;

    public GetMetricStatisticsAggregationKey(MetricEntity me, Date startTime, Integer period, String dimensionHash) {
        this.accountId = me.getAccountId();
        this.namespace = me.getNamespace();
        this.metricName = me.getMetricName();
        this.units = me.getUnits();
        this.metricType = me.getMetricType();
        this.timestamp = MetricManager.getPeriodStart(me.getTimestamp(), startTime, period);
        this.dimensionHash = dimensionHash;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accountId == null ? 0 : this.accountId.hashCode());
        result = 31 * result + (this.dimensionHash == null ? 0 : this.dimensionHash.hashCode());
        result = 31 * result + (this.metricName == null ? 0 : this.metricName.hashCode());
        result = 31 * result + (this.metricType == null ? 0 : this.metricType.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = 31 * result + (this.units == null ? 0 : this.units.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetMetricStatisticsAggregationKey other = (GetMetricStatisticsAggregationKey)obj;
        if (this.accountId == null ? other.accountId != null : !this.accountId.equals(other.accountId)) {
            return false;
        }
        if (this.dimensionHash == null ? other.dimensionHash != null : !this.dimensionHash.equals(other.dimensionHash)) {
            return false;
        }
        if (this.metricName == null ? other.metricName != null : !this.metricName.equals(other.metricName)) {
            return false;
        }
        if (this.metricType != other.metricType) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        if (this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp)) {
            return false;
        }
        return this.units == other.units;
    }

    public static enum COMPARATOR_WITH_NULLS implements Comparator<GetMetricStatisticsAggregationKey>
    {
        INSTANCE{

            @Override
            public int compare(GetMetricStatisticsAggregationKey a, GetMetricStatisticsAggregationKey b) {
                if (a == b) {
                    return 0;
                }
                if (a == null && b == null) {
                    return 0;
                }
                if (a == null && b != null) {
                    return -1;
                }
                if (a != null && b == null) {
                    return 1;
                }
                if (this.compare(a.accountId, b.accountId) != 0) {
                    return this.compare(a.accountId, b.accountId);
                }
                if (this.compare(a.timestamp, b.timestamp) != 0) {
                    return this.compare(a.timestamp, b.timestamp);
                }
                if (this.compare(a.namespace, b.namespace) != 0) {
                    return this.compare(a.namespace, b.namespace);
                }
                if (this.compare(a.metricType, b.metricType) != 0) {
                    return this.compare(a.metricType, b.metricType);
                }
                if (this.compare(a.metricName, b.metricName) != 0) {
                    return this.compare(a.metricName, b.metricName);
                }
                if (this.compare(a.dimensionHash, b.dimensionHash) != 0) {
                    return this.compare(a.dimensionHash, b.dimensionHash);
                }
                return this.compare(a.units, b.units);
            }

            @Override
            private int compare(MetricEntity.Units a, MetricEntity.Units b) {
                if (a == null && b == null) {
                    return 0;
                }
                if (a == null && b != null) {
                    return -1;
                }
                if (a != null && b == null) {
                    return 1;
                }
                return a.compareTo(b);
            }

            @Override
            private int compare(Date a, Date b) {
                if (a == null && b == null) {
                    return 0;
                }
                if (a == null && b != null) {
                    return -1;
                }
                if (a != null && b == null) {
                    return 1;
                }
                return a.compareTo(b);
            }

            @Override
            private int compare(MetricEntity.MetricType a, MetricEntity.MetricType b) {
                if (a == null && b == null) {
                    return 0;
                }
                if (a == null && b != null) {
                    return -1;
                }
                if (a != null && b == null) {
                    return 1;
                }
                return a.compareTo(b);
            }

            @Override
            private int compare(String a, String b) {
                if (a == null && b == null) {
                    return 0;
                }
                if (a == null && b != null) {
                    return -1;
                }
                if (a != null && b == null) {
                    return 1;
                }
                return a.compareTo(b);
            }
        };

    }
}

