/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.domain.listmetrics;

import com.eucalyptus.cloudwatch.backend.CloudWatchException;
import com.eucalyptus.cloudwatch.domain.DimensionEntity;
import com.eucalyptus.cloudwatch.domain.NextTokenUtils;
import com.eucalyptus.cloudwatch.domain.listmetrics.ListMetric;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricEntity;
import com.eucalyptus.cloudwatch.domain.metricdata.SimpleMetricEntity;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.records.Logs;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;

public class ListMetricManager {
    private static final Logger LOG = Logger.getLogger(ListMetricManager.class);

    public static void addMetric(String accountId, String metricName, String namespace, Map<String, String> dimensionMap, MetricEntity.MetricType metricType) {
        EntityTransaction db = Entities.get(ListMetric.class);
        try {
            ListMetricManager.addMetric(db, accountId, metricName, namespace, dimensionMap, metricType);
            db.commit();
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    private static List<ListMetric> foldMetric(String accountId, String metricName, String namespace, Map<String, String> dimensionMap, MetricEntity.MetricType metricType) {
        ArrayList metrics = Lists.newArrayList();
        if (dimensionMap == null) {
            dimensionMap = new HashMap<String, String>();
        } else if (dimensionMap.size() > 10) {
            throw new IllegalArgumentException("Too many dimensions for metric, " + dimensionMap.size());
        }
        TreeSet<DimensionEntity> dimensions = new TreeSet<DimensionEntity>();
        for (Map.Entry<String, String> entry : dimensionMap.entrySet()) {
            DimensionEntity d = new DimensionEntity();
            d.setName(entry.getKey());
            d.setValue(entry.getValue());
            dimensions.add(d);
        }
        Set permutations = null;
        if (metricType == MetricEntity.MetricType.System) {
            permutations = !namespace.equals("AWS/EC2") ? Sets.powerSet(dimensions) : Sets.filter((Set)Sets.powerSet(dimensions), (Predicate)new Predicate<Set<DimensionEntity>>(){

                public boolean apply(@Nullable Set<DimensionEntity> candidate) {
                    return candidate != null && candidate.size() < 2;
                }
            });
        } else {
            permutations = Sets.newHashSet();
            permutations.add(dimensions);
        }
        for (Set dimensionsPermutation : permutations) {
            ListMetric metric = new ListMetric();
            metric.setAccountId(accountId);
            metric.setMetricName(metricName);
            metric.setNamespace(namespace);
            metric.setDimensions(dimensionsPermutation);
            metric.setMetricType(metricType);
            metrics.add(metric);
        }
        return metrics;
    }

    private static void addMetric(EntityTransaction db, String accountId, String metricName, String namespace, Map<String, String> dimensionMap, MetricEntity.MetricType metricType) {
        List<ListMetric> foldedMetrics = ListMetricManager.foldMetric(accountId, metricName, namespace, dimensionMap, metricType);
        for (ListMetric metric : foldedMetrics) {
            Criteria criteria = Entities.createCriteria(ListMetric.class).add((Criterion)Restrictions.eq((String)"accountId", (Object)metric.getAccountId())).add((Criterion)Restrictions.eq((String)"metricName", (Object)metric.getMetricName())).add((Criterion)Restrictions.eq((String)"namespace", (Object)metric.getNamespace()));
            int dimIndex = 1;
            for (DimensionEntity d : metric.getDimensions()) {
                criteria.add((Criterion)Restrictions.eq((String)("dim" + dimIndex + "Name"), (Object)d.getName()));
                criteria.add((Criterion)Restrictions.eq((String)("dim" + dimIndex + "Value"), (Object)d.getValue()));
                ++dimIndex;
            }
            while (dimIndex <= 10) {
                criteria.add(Restrictions.isNull((String)("dim" + dimIndex + "Name")));
                criteria.add(Restrictions.isNull((String)("dim" + dimIndex + "Value")));
                ++dimIndex;
            }
            ListMetric inDbMetric = (ListMetric)((Object)criteria.uniqueResult());
            if (inDbMetric != null) {
                inDbMetric.setVersion(1 + inDbMetric.getVersion());
                continue;
            }
            Entities.persist((Object)((Object)metric));
        }
    }

    public static void deleteAllMetrics() {
        EntityTransaction db = Entities.get(ListMetric.class);
        try {
            Entities.deleteAll(ListMetric.class);
            db.commit();
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    public static void deleteMetrics(Date before) {
        EntityTransaction db = Entities.get(ListMetric.class);
        try {
            HashMap<String, Date> criteria = new HashMap<String, Date>();
            criteria.put("before", before);
            Entities.deleteAllMatching(ListMetric.class, (String)"WHERE lastUpdateTimestamp < :before", criteria);
            db.commit();
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    public static List<ListMetric> listMetrics(String accountId, String metricName, String namespace, Map<String, String> dimensionMap, Date after, Date before, Integer maxRecords, String nextToken) throws CloudWatchException {
        if (dimensionMap != null && dimensionMap.size() > 10) {
            throw new IllegalArgumentException("Too many dimensions " + dimensionMap.size());
        }
        EntityTransaction db = Entities.get(ListMetric.class);
        try {
            Date nextTokenCreatedTime = NextTokenUtils.getNextTokenCreatedTime(nextToken, ListMetric.class, false);
            TreeMap<String, String> sortedDimensionMap = new TreeMap<String, String>();
            Criteria criteria = Entities.createCriteria(ListMetric.class);
            if (accountId != null) {
                criteria = criteria.add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
            }
            if (metricName != null) {
                criteria = criteria.add((Criterion)Restrictions.eq((String)"metricName", (Object)metricName));
            }
            if (namespace != null) {
                criteria = criteria.add((Criterion)Restrictions.eq((String)"namespace", (Object)namespace));
            }
            if (before != null) {
                criteria = criteria.add((Criterion)Restrictions.le((String)"lastUpdateTimestamp", (Object)before));
            }
            if (after != null) {
                criteria = criteria.add((Criterion)Restrictions.ge((String)"lastUpdateTimestamp", (Object)after));
            }
            if (dimensionMap != null && !dimensionMap.isEmpty()) {
                sortedDimensionMap.putAll(dimensionMap);
                int numDimensions = sortedDimensionMap.size();
                int lowDimNum = 1;
                int highDimNum = 11 - numDimensions;
                for (Map.Entry dimEntry : sortedDimensionMap.entrySet()) {
                    Disjunction or = Restrictions.disjunction();
                    for (int i = lowDimNum; i <= highDimNum; ++i) {
                        or.add((Criterion)Restrictions.conjunction().add((Criterion)Restrictions.eq((String)("dim" + i + "Name"), dimEntry.getKey())).add((Criterion)Restrictions.eq((String)("dim" + i + "Value"), dimEntry.getValue())));
                    }
                    ++lowDimNum;
                    ++highDimNum;
                    criteria = criteria.add((Criterion)or);
                }
            }
            criteria = NextTokenUtils.addNextTokenConstraints(maxRecords, nextToken, nextTokenCreatedTime, criteria);
            List dbResult = criteria.list();
            db.commit();
            List list = dbResult;
            return list;
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    public static void addMetricBatch(List<SimpleMetricEntity> dataBatch) {
        EntityTransaction db = Entities.get(ListMetric.class);
        try {
            HashSet loadedKeys = Sets.newHashSet();
            HashMap cache = Maps.newHashMap();
            Collection<ListMetricCacheKey> cacheKeys = ListMetricManager.prune(dataBatch);
            ArrayList foldedMetrics = Lists.newArrayList();
            for (ListMetricCacheKey cacheKey : cacheKeys) {
                foldedMetrics.addAll(ListMetricManager.foldMetric(cacheKey.getLoadKey().getAccountId(), cacheKey.getMetricName(), cacheKey.getLoadKey().getNamespace(), cacheKey.getDimensionMap(), cacheKey.getMetricType()));
            }
            for (ListMetric metric : foldedMetrics) {
                ListMetricCacheLoadKey loadKey = new ListMetricCacheLoadKey();
                loadKey.setAccountId(metric.getAccountId());
                loadKey.setNamespace(metric.getNamespace());
                if (!loadedKeys.contains(loadKey)) {
                    Criteria criteria = Entities.createCriteria(ListMetric.class).add((Criterion)Restrictions.eq((String)"accountId", (Object)metric.getAccountId())).add((Criterion)Restrictions.eq((String)"namespace", (Object)metric.getNamespace()));
                    List results = criteria.list();
                    for (ListMetric result : results) {
                        ListMetricCacheKey key = new ListMetricCacheKey();
                        key.setLoadKey(loadKey);
                        key.setDimensionMap(result.getDimensionMap());
                        key.setMetricName(result.getMetricName());
                        key.setMetricType(result.getMetricType());
                        cache.put(key, result);
                    }
                    loadedKeys.add(loadKey);
                }
                ListMetricCacheKey key = new ListMetricCacheKey();
                key.setDimensionMap(metric.getDimensionMap());
                key.setLoadKey(loadKey);
                key.setMetricName(metric.getMetricName());
                key.setMetricType(metric.getMetricType());
                ListMetric inDbMetric = (ListMetric)((Object)cache.get(key));
                if (inDbMetric != null) {
                    inDbMetric.setVersion(1 + inDbMetric.getVersion());
                    continue;
                }
                cache.put(key, metric);
                Entities.persist((Object)((Object)metric));
            }
            db.commit();
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    private static Collection<ListMetricCacheKey> prune(List<SimpleMetricEntity> dataBatch) {
        LinkedHashSet<ListMetricCacheKey> returnValue = new LinkedHashSet<ListMetricCacheKey>();
        for (SimpleMetricEntity item : dataBatch) {
            ListMetricCacheLoadKey loadKey = new ListMetricCacheLoadKey();
            loadKey.setAccountId(item.getAccountId());
            loadKey.setNamespace(item.getNamespace());
            ListMetricCacheKey key = new ListMetricCacheKey();
            key.setDimensionMap(item.getDimensionMap());
            key.setLoadKey(loadKey);
            key.setMetricName(item.getMetricName());
            key.setMetricType(item.getMetricType());
            returnValue.add(key);
        }
        return returnValue;
    }

    private static class ListMetricCacheKey {
        String metricName;
        MetricEntity.MetricType metricType;
        ListMetricCacheLoadKey loadKey;
        Map<String, String> dimensionMap;

        private ListMetricCacheKey() {
        }

        public ListMetricCacheLoadKey getLoadKey() {
            return this.loadKey;
        }

        public void setLoadKey(ListMetricCacheLoadKey loadKey) {
            this.loadKey = loadKey;
        }

        public Map<String, String> getDimensionMap() {
            return this.dimensionMap;
        }

        public void setDimensionMap(Map<String, String> dimensionMap) {
            this.dimensionMap = dimensionMap;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public MetricEntity.MetricType getMetricType() {
            return this.metricType;
        }

        public void setMetricType(MetricEntity.MetricType metricType) {
            this.metricType = metricType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dimensionMap == null ? 0 : this.dimensionMap.hashCode());
            result = 31 * result + (this.loadKey == null ? 0 : this.loadKey.hashCode());
            result = 31 * result + (this.metricName == null ? 0 : this.metricName.hashCode());
            result = 31 * result + (this.metricType == null ? 0 : this.metricType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListMetricCacheKey other = (ListMetricCacheKey)obj;
            if (this.dimensionMap == null ? other.dimensionMap != null : !this.dimensionMap.equals(other.dimensionMap)) {
                return false;
            }
            if (this.loadKey == null ? other.loadKey != null : !this.loadKey.equals(other.loadKey)) {
                return false;
            }
            if (this.metricName == null ? other.metricName != null : !this.metricName.equals(other.metricName)) {
                return false;
            }
            return this.metricType == other.metricType;
        }
    }

    private static class ListMetricCacheLoadKey {
        String accountId;
        String namespace;

        private ListMetricCacheLoadKey() {
        }

        public String getAccountId() {
            return this.accountId;
        }

        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.accountId == null ? 0 : this.accountId.hashCode());
            result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListMetricCacheLoadKey other = (ListMetricCacheLoadKey)obj;
            if (this.accountId == null ? other.accountId != null : !this.accountId.equals(other.accountId)) {
                return false;
            }
            return !(this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace));
        }
    }
}

