/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.domain.alarms;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.cloudwatch.backend.CloudWatchBackendService;
import com.eucalyptus.cloudwatch.common.CloudWatchBackend;
import com.eucalyptus.cloudwatch.domain.alarms.AlarmEntity;
import com.eucalyptus.cloudwatch.domain.alarms.AlarmManager;
import com.eucalyptus.cloudwatch.domain.alarms.AlarmState;
import com.eucalyptus.cloudwatch.domain.alarms.AlarmUtils;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricManager;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricStatistics;
import com.eucalyptus.component.Topology;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.records.Logs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.TreeMap;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class AlarmStateEvaluationWorker
implements Runnable {
    private String accountId;
    private String alarmName;
    private static final Logger LOG = Logger.getLogger(AlarmStateEvaluationWorker.class);

    public AlarmStateEvaluationWorker(String accountId, String alarmName) {
        this.accountId = accountId;
        this.alarmName = alarmName;
    }

    @Override
    public void run() {
        if (!CloudWatchBackendService.DISABLE_CLOUDWATCH_SERVICE.booleanValue() && Bootstrap.isOperational().booleanValue() && Topology.isEnabledLocally(CloudWatchBackend.class)) {
            LOG.debug((Object)("Kicking off alarm state evaluation for " + this.alarmName));
            EntityTransaction db = Entities.get(AlarmEntity.class);
            try {
                Criteria criteria = Entities.createCriteria(AlarmEntity.class).add((Criterion)Restrictions.eq((String)"accountId", (Object)this.accountId)).add((Criterion)Restrictions.eq((String)"alarmName", (Object)this.alarmName));
                AlarmEntity alarmEntity = (AlarmEntity)((Object)criteria.uniqueResult());
                if (alarmEntity == null) {
                    return;
                }
                AlarmState currentState = this.evaluateState(alarmEntity);
                Date evaluationDate = new Date();
                if (currentState.getStateValue() != alarmEntity.getStateValue()) {
                    AlarmManager.changeAlarmState(alarmEntity, currentState, evaluationDate);
                    AlarmManager.executeActions(alarmEntity, currentState, true, evaluationDate);
                } else if (this.moreThanOnePeriodHasPassed(alarmEntity, evaluationDate)) {
                    AlarmManager.executeActions(alarmEntity, currentState, false, evaluationDate);
                }
                db.commit();
            }
            catch (RuntimeException ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
                throw ex;
            }
            finally {
                if (db.isActive()) {
                    db.rollback();
                }
            }
        }
    }

    private boolean moreThanOnePeriodHasPassed(AlarmEntity alarmEntity, Date now) {
        now = MetricManager.stripSeconds(now);
        Date then = MetricManager.stripSeconds(alarmEntity.getLastActionsUpdatedTimestamp());
        return now.getTime() - then.getTime() >= 1000L * (long)alarmEntity.getPeriod().intValue();
    }

    private AlarmState evaluateState(AlarmEntity alarmEntity) {
        Date queryDate = new Date();
        Date endDate = MetricManager.stripSeconds(queryDate);
        Date startDate = new Date(endDate.getTime() - 1000L * (long)alarmEntity.getPeriod().intValue() * (long)alarmEntity.getEvaluationPeriods().intValue());
        Date bufferStartDate = new Date(startDate.getTime() - 1000L * (long)alarmEntity.getPeriod().intValue() * (long)this.numBufferPeriods(alarmEntity.getPeriod()).intValue());
        Collection<MetricStatistics> metricStatisticsList = MetricManager.getMetricStatistics(this.accountId, alarmEntity.getMetricName(), alarmEntity.getNamespace(), alarmEntity.getDimensionMap(), alarmEntity.getMetricType(), alarmEntity.getUnit(), bufferStartDate, endDate, alarmEntity.getPeriod());
        TreeMap<Long, StateAndMetricValue> dataPointMap = new TreeMap<Long, StateAndMetricValue>();
        for (long L = bufferStartDate.getTime(); L < endDate.getTime(); L += (long)alarmEntity.getPeriod().intValue() * 1000L) {
            dataPointMap.put(L, new StateAndMetricValue(AlarmEntity.StateValue.INSUFFICIENT_DATA, null));
        }
        for (MetricStatistics metricStatistics : metricStatisticsList) {
            Long dateAsLong = metricStatistics.getTimestamp().getTime();
            if (!dataPointMap.containsKey(dateAsLong)) {
                LOG.warn((Object)"Data point does not fall in interval, skipping");
                continue;
            }
            dataPointMap.put(dateAsLong, this.calculateLocalStateAndMetricValue(alarmEntity, metricStatistics));
        }
        ArrayList<Double> okPoints = new ArrayList<Double>();
        ArrayList<Double> alarmPoints = new ArrayList<Double>();
        ArrayList<Double> insufficientDataPoints = new ArrayList<Double>();
        LinkedList<Double> relevantDataPoints = new LinkedList<Double>();
        AlarmEntity.StateValue oldestStateValue = null;
        for (long L = startDate.getTime(); L < endDate.getTime(); L += (long)alarmEntity.getPeriod().intValue() * 1000L) {
            StateAndMetricValue stateAndMetricValue = (StateAndMetricValue)dataPointMap.get(L);
            relevantDataPoints.addLast(stateAndMetricValue.getMetricValue());
            if (oldestStateValue == null) {
                oldestStateValue = stateAndMetricValue.getStateValue();
            }
            if (stateAndMetricValue.getStateValue() == AlarmEntity.StateValue.OK) {
                okPoints.add(stateAndMetricValue.getMetricValue());
                continue;
            }
            if (stateAndMetricValue.getStateValue() == AlarmEntity.StateValue.ALARM) {
                alarmPoints.add(stateAndMetricValue.getMetricValue());
                continue;
            }
            if (stateAndMetricValue.getStateValue() != AlarmEntity.StateValue.INSUFFICIENT_DATA) continue;
            insufficientDataPoints.add(stateAndMetricValue.getMetricValue());
        }
        if (okPoints.size() > 0) {
            return AlarmManager.createAlarmState(AlarmEntity.StateValue.OK, okPoints, relevantDataPoints, alarmEntity.getComparisonOperator(), alarmEntity.getThreshold(), alarmEntity.getPeriod(), queryDate, alarmEntity.getStatistic());
        }
        if (oldestStateValue == AlarmEntity.StateValue.ALARM) {
            return AlarmManager.createAlarmState(AlarmEntity.StateValue.ALARM, alarmPoints, relevantDataPoints, alarmEntity.getComparisonOperator(), alarmEntity.getThreshold(), alarmEntity.getPeriod(), queryDate, alarmEntity.getStatistic());
        }
        AlarmEntity.StateValue lastNonInsufficientDataStateValue = null;
        for (long L = startDate.getTime() - (long)alarmEntity.getPeriod().intValue() * 1000L; L >= bufferStartDate.getTime(); L -= (long)alarmEntity.getPeriod().intValue() * 1000L) {
            StateAndMetricValue stateAndMetricValue = (StateAndMetricValue)dataPointMap.get(L);
            relevantDataPoints.addFirst(stateAndMetricValue.getMetricValue());
            if (stateAndMetricValue.getStateValue() == AlarmEntity.StateValue.OK) {
                okPoints.add(stateAndMetricValue.getMetricValue());
                lastNonInsufficientDataStateValue = AlarmEntity.StateValue.OK;
                break;
            }
            if (stateAndMetricValue.getStateValue() != AlarmEntity.StateValue.ALARM) continue;
            alarmPoints.add(stateAndMetricValue.getMetricValue());
            lastNonInsufficientDataStateValue = AlarmEntity.StateValue.ALARM;
            break;
        }
        if (lastNonInsufficientDataStateValue == AlarmEntity.StateValue.OK) {
            return AlarmManager.createAlarmState(AlarmEntity.StateValue.OK, okPoints, relevantDataPoints, alarmEntity.getComparisonOperator(), alarmEntity.getThreshold(), alarmEntity.getPeriod(), queryDate, alarmEntity.getStatistic());
        }
        if (lastNonInsufficientDataStateValue == AlarmEntity.StateValue.ALARM) {
            return AlarmManager.createAlarmState(AlarmEntity.StateValue.ALARM, alarmPoints, relevantDataPoints, alarmEntity.getComparisonOperator(), alarmEntity.getThreshold(), alarmEntity.getPeriod(), queryDate, alarmEntity.getStatistic());
        }
        return AlarmManager.createAlarmState(AlarmEntity.StateValue.INSUFFICIENT_DATA, insufficientDataPoints, relevantDataPoints, alarmEntity.getComparisonOperator(), alarmEntity.getThreshold(), alarmEntity.getPeriod(), queryDate, alarmEntity.getStatistic());
    }

    private StateAndMetricValue calculateLocalStateAndMetricValue(AlarmEntity alarmEntity, MetricStatistics metricStatistics) {
        Double metricValue = AlarmUtils.calculateMetricValue(alarmEntity.getStatistic(), metricStatistics);
        AlarmEntity.StateValue stateValue = AlarmUtils.calculateStateValue(alarmEntity.getThreshold(), alarmEntity.getComparisonOperator(), metricValue);
        return new StateAndMetricValue(stateValue, metricValue);
    }

    private Integer numBufferPeriods(Integer period) {
        Integer periodMinutes = period / 60;
        if (periodMinutes == 1) {
            return 5;
        }
        if (periodMinutes == 2) {
            return 3;
        }
        return 2;
    }

    private static class StateAndMetricValue {
        private AlarmEntity.StateValue stateValue;
        private Double metricValue;

        public StateAndMetricValue(AlarmEntity.StateValue stateValue, Double metricValue) {
            this.stateValue = stateValue;
            this.metricValue = metricValue;
        }

        public AlarmEntity.StateValue getStateValue() {
            return this.stateValue;
        }

        public Double getMetricValue() {
            return this.metricValue;
        }
    }
}

