/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.domain.alarms;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.cloudwatch.backend.CloudWatchBackendService;
import com.eucalyptus.cloudwatch.common.CloudWatchBackend;
import com.eucalyptus.cloudwatch.domain.alarms.AlarmEntity;
import com.eucalyptus.cloudwatch.domain.alarms.AlarmStateEvaluationWorker;
import com.eucalyptus.component.Topology;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.records.Logs;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;

public class AlarmStateEvaluationDispatcher
implements Runnable {
    private static final Logger LOG = Logger.getLogger(AlarmStateEvaluationDispatcher.class);
    ExecutorService executorService;

    public AlarmStateEvaluationDispatcher(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public void run() {
        if (!CloudWatchBackendService.DISABLE_CLOUDWATCH_SERVICE.booleanValue() && Bootstrap.isOperational().booleanValue() && Topology.isEnabledLocally(CloudWatchBackend.class)) {
            LOG.debug((Object)"Kicking off AlarmStateEvaluationDispatcher");
            EntityTransaction db = Entities.get(AlarmEntity.class);
            try {
                Criteria criteria = Entities.createCriteria(AlarmEntity.class);
                List results = criteria.list();
                for (AlarmEntity alarmEntity : results) {
                    LOG.debug((Object)("Submitting job for " + alarmEntity.getAlarmName()));
                    this.executorService.submit(new AlarmStateEvaluationWorker(alarmEntity.getAccountId(), alarmEntity.getAlarmName()));
                }
                db.commit();
            }
            catch (RuntimeException ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
                throw ex;
            }
            finally {
                if (db.isActive()) {
                    db.rollback();
                }
            }
        }
    }
}

