/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.domain.alarms;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.autoscaling.common.AutoScaling;
import com.eucalyptus.autoscaling.common.msgs.AutoScalingMessage;
import com.eucalyptus.autoscaling.common.msgs.ExecutePolicyType;
import com.eucalyptus.cloudwatch.backend.CloudWatchException;
import com.eucalyptus.cloudwatch.backend.ResourceNotFoundException;
import com.eucalyptus.cloudwatch.common.CloudWatchMetadata;
import com.eucalyptus.cloudwatch.common.CloudWatchResourceName;
import com.eucalyptus.cloudwatch.domain.DimensionEntity;
import com.eucalyptus.cloudwatch.domain.NextTokenUtils;
import com.eucalyptus.cloudwatch.domain.alarms.AlarmEntity;
import com.eucalyptus.cloudwatch.domain.alarms.AlarmHistory;
import com.eucalyptus.cloudwatch.domain.alarms.AlarmState;
import com.eucalyptus.cloudwatch.domain.alarms.AlarmUtils;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricEntity;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.ComputeMessage;
import com.eucalyptus.compute.common.backend.StopInstancesType;
import com.eucalyptus.compute.common.backend.TerminateInstancesType;
import com.eucalyptus.crypto.util.Timestamps;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.DispatchingClient;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityTransaction;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class AlarmManager {
    private static final Logger LOG = Logger.getLogger(AlarmManager.class);

    public static Long countMetricAlarms(String accountId) {
        EntityTransaction db = Entities.get(AlarmEntity.class);
        try {
            Criteria criteria = Entities.createCriteria(AlarmEntity.class);
            criteria = criteria.setProjection(Projections.rowCount());
            if (accountId != null) {
                criteria = criteria.add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
            }
            Long l = (Long)criteria.uniqueResult();
            return l;
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            db.rollback();
        }
    }

    public static void putMetricAlarm(String accountId, Boolean actionsEnabled, Collection<String> alarmActions, String alarmDescription, String alarmName, AlarmEntity.ComparisonOperator comparisonOperator, Map<String, String> dimensionMap, Integer evaluationPeriods, Collection<String> insufficientDataActions, String metricName, MetricEntity.MetricType metricType, String namespace, Collection<String> okActions, Integer period, AlarmEntity.Statistic statistic, Double threshold, MetricEntity.Units unit) {
        if (dimensionMap == null) {
            dimensionMap = Maps.newHashMap();
        } else if (dimensionMap.size() > 10) {
            throw new IllegalArgumentException("Too many dimensions for metric, " + dimensionMap.size());
        }
        AlarmEntity alarmEntity = new AlarmEntity();
        alarmEntity.setAccountId(accountId);
        alarmEntity.setAlarmName(alarmName);
        EntityTransaction db = Entities.get(AlarmEntity.class);
        boolean inDb = false;
        try {
            JSONObject historyDataDeletedAlarmJSON;
            JSONObject historyDataJSON;
            Criteria criteria = Entities.createCriteria(AlarmEntity.class).add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId)).add((Criterion)Restrictions.eq((String)"alarmName", (Object)alarmName));
            AlarmEntity inDbAlarm = (AlarmEntity)((Object)criteria.uniqueResult());
            if (inDbAlarm != null) {
                inDb = true;
                alarmEntity = inDbAlarm;
            }
            alarmEntity.setActionsEnabled(actionsEnabled);
            alarmEntity.setAlarmActions(alarmActions);
            alarmEntity.setAlarmDescription(alarmDescription);
            alarmEntity.setComparisonOperator(comparisonOperator);
            TreeSet dimensions = Sets.newTreeSet();
            for (Map.Entry entry : dimensionMap.entrySet()) {
                DimensionEntity d = new DimensionEntity();
                d.setName((String)entry.getKey());
                d.setValue((String)entry.getValue());
                dimensions.add(d);
            }
            alarmEntity.setDimensions(dimensions);
            alarmEntity.setEvaluationPeriods(evaluationPeriods);
            alarmEntity.setInsufficientDataActions(insufficientDataActions);
            alarmEntity.setMetricName(metricName);
            alarmEntity.setMetricType(metricType);
            alarmEntity.setNamespace(namespace);
            alarmEntity.setOkActions(okActions);
            alarmEntity.setPeriod(period);
            alarmEntity.setStatistic(statistic);
            alarmEntity.setThreshold(threshold);
            alarmEntity.setUnit(unit);
            Date now = new Date();
            alarmEntity.setAlarmConfigurationUpdatedTimestamp(now);
            if (!inDb) {
                alarmEntity.setStateValue(AlarmEntity.StateValue.INSUFFICIENT_DATA);
                alarmEntity.setStateReason("Unchecked: Initial alarm creation");
                alarmEntity.setStateUpdatedTimestamp(now);
                alarmEntity.setLastActionsUpdatedTimestamp(now);
                historyDataJSON = new JSONObject();
                historyDataJSON.element("version", (Object)"1.0");
                historyDataJSON.element("type", (Object)"Create");
                historyDataDeletedAlarmJSON = AlarmManager.getJSONObjectFromAlarmEntity(alarmEntity);
                historyDataJSON.element("createdAlarm", (Map)historyDataDeletedAlarmJSON);
                String historyData = historyDataJSON.toString();
                AlarmManager.addAlarmHistoryItem(accountId, alarmName, historyData, AlarmHistory.HistoryItemType.ConfigurationUpdate, "Alarm \"" + alarmName + "\" created", now);
                Entities.persist((Object)((Object)alarmEntity));
            } else {
                historyDataJSON = new JSONObject();
                historyDataJSON.element("version", (Object)"1.0");
                historyDataJSON.element("type", (Object)"Update");
                historyDataDeletedAlarmJSON = AlarmManager.getJSONObjectFromAlarmEntity(alarmEntity);
                historyDataJSON.element("updatedAlarm", (Map)historyDataDeletedAlarmJSON);
                String historyData = historyDataJSON.toString();
                AlarmManager.addAlarmHistoryItem(accountId, alarmName, historyData, AlarmHistory.HistoryItemType.ConfigurationUpdate, "Alarm \"" + alarmName + "\" updated", now);
            }
            db.commit();
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    static void addAlarmHistoryItem(String accountId, String alarmName, String historyData, AlarmHistory.HistoryItemType historyItemType, String historySummary, Date now) {
        if (now == null) {
            now = new Date();
        }
        EntityTransaction db = Entities.get(AlarmHistory.class);
        try {
            AlarmHistory alarmHistory = new AlarmHistory();
            alarmHistory.setAccountId(accountId);
            alarmHistory.setAlarmName(alarmName);
            alarmHistory.setHistoryData(historyData);
            alarmHistory.setHistoryItemType(historyItemType);
            alarmHistory.setHistorySummary(historySummary);
            alarmHistory.setTimestamp(now);
            Entities.persist((Object)((Object)alarmHistory));
            db.commit();
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    public static boolean deleteAlarms(String accountId, Collection<String> alarmNames, Predicate<CloudWatchMetadata.AlarmMetadata> filter) {
        return AlarmManager.modifySelectedAlarms(accountId, alarmNames, filter, new Predicate<AlarmEntity>(){
            private final Date now = new Date();

            public boolean apply(AlarmEntity alarmEntity) {
                String alarmName = alarmEntity.getAlarmName();
                JSONObject historyDataJSON = new JSONObject();
                historyDataJSON.element("version", (Object)"1.0");
                historyDataJSON.element("type", (Object)"Delete");
                JSONObject historyDataDeletedAlarmJSON = AlarmManager.getJSONObjectFromAlarmEntity(alarmEntity);
                historyDataJSON.element("deletedAlarm", (Map)historyDataDeletedAlarmJSON);
                String historyData = historyDataJSON.toString();
                AlarmManager.addAlarmHistoryItem(alarmEntity.getAccountId(), alarmName, historyData, AlarmHistory.HistoryItemType.ConfigurationUpdate, "Alarm \"" + alarmName + "\" deleted", this.now);
                Entities.delete((Object)((Object)alarmEntity));
                return true;
            }
        });
    }

    private static JSONObject getJSONObjectFromAlarmEntity(AlarmEntity alarmEntity) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.element("threshold", (Object)alarmEntity.getThreshold());
        jsonObject.element("namespace", (Object)alarmEntity.getNamespace());
        jsonObject.element("stateValue", (Object)alarmEntity.getStateValue().toString());
        ArrayList<JSONObject> dimensions = new ArrayList<JSONObject>();
        if (alarmEntity.getDimensions() != null) {
            for (DimensionEntity dimensionEntity : alarmEntity.getDimensions()) {
                JSONObject dimension = new JSONObject();
                dimension.element("name", (Object)dimensionEntity.getName());
                dimension.element("value", (Object)dimensionEntity.getValue());
                dimensions.add(dimension);
            }
        }
        jsonObject.element("dimensions", dimensions);
        jsonObject.element("okactions", alarmEntity.getOkActions() != null ? alarmEntity.getOkActions() : new ArrayList());
        jsonObject.element("alarmActions", alarmEntity.getAlarmActions() != null ? alarmEntity.getAlarmActions() : new ArrayList());
        jsonObject.element("evaluationPeriods", (Object)alarmEntity.getEvaluationPeriods());
        jsonObject.element("comparisonOperator", (Object)alarmEntity.getComparisonOperator().toString());
        jsonObject.element("metricName", (Object)alarmEntity.getMetricName());
        jsonObject.element("period", (Object)alarmEntity.getPeriod());
        jsonObject.element("alarmName", (Object)alarmEntity.getAlarmName());
        jsonObject.element("insufficientDataActions", alarmEntity.getInsufficientDataActions() != null ? alarmEntity.getInsufficientDataActions() : new ArrayList());
        jsonObject.element("actionsEnabled", (Object)alarmEntity.getActionsEnabled());
        jsonObject.element("alarmDescription", (Object)alarmEntity.getAlarmDescription());
        jsonObject.element("statistic", (Object)alarmEntity.getStatistic());
        jsonObject.element("alarmArn", (Object)alarmEntity.getResourceName());
        jsonObject.element("alarmConfigurationUpdatedTimestamp", (Object)Timestamps.formatIso8601UTCLongDateMillisTimezone((Date)alarmEntity.getAlarmConfigurationUpdatedTimestamp()));
        jsonObject.element("stateUpdatedTimestamp", (Object)Timestamps.formatIso8601UTCLongDateMillisTimezone((Date)alarmEntity.getStateUpdatedTimestamp()));
        return jsonObject;
    }

    public static boolean enableAlarmActions(String accountId, Collection<String> alarmNames, Predicate<CloudWatchMetadata.AlarmMetadata> filter) {
        return AlarmManager.modifySelectedAlarms(accountId, alarmNames, filter, new Predicate<AlarmEntity>(){
            private final Date now = new Date();

            public boolean apply(AlarmEntity alarmEntity) {
                String alarmName = alarmEntity.getAlarmName();
                if (!Boolean.TRUE.equals(alarmEntity.getActionsEnabled())) {
                    JSONObject historyDataJSON = new JSONObject();
                    historyDataJSON.element("version", (Object)"1.0");
                    historyDataJSON.element("type", (Object)"Update");
                    JSONObject historyDataDeletedAlarmJSON = AlarmManager.getJSONObjectFromAlarmEntity(alarmEntity);
                    historyDataJSON.element("updatedAlarm", (Map)historyDataDeletedAlarmJSON);
                    String historyData = historyDataJSON.toString();
                    AlarmManager.addAlarmHistoryItem(alarmEntity.getAccountId(), alarmName, historyData, AlarmHistory.HistoryItemType.ConfigurationUpdate, "Alarm \"" + alarmName + "\" updated", this.now);
                    alarmEntity.setActionsEnabled(Boolean.TRUE);
                }
                return true;
            }
        });
    }

    public static boolean disableAlarmActions(String accountId, Collection<String> alarmNames, Predicate<CloudWatchMetadata.AlarmMetadata> filter) {
        return AlarmManager.modifySelectedAlarms(accountId, alarmNames, filter, new Predicate<AlarmEntity>(){
            private final Date now = new Date();

            public boolean apply(AlarmEntity alarmEntity) {
                String alarmName = alarmEntity.getAlarmName();
                if (!Boolean.FALSE.equals(alarmEntity.getActionsEnabled())) {
                    JSONObject historyDataJSON = new JSONObject();
                    historyDataJSON.element("version", (Object)"1.0");
                    historyDataJSON.element("type", (Object)"Update");
                    JSONObject historyDataDeletedAlarmJSON = AlarmManager.getJSONObjectFromAlarmEntity(alarmEntity);
                    historyDataJSON.element("updatedAlarm", (Map)historyDataDeletedAlarmJSON);
                    String historyData = historyDataJSON.toString();
                    AlarmManager.addAlarmHistoryItem(alarmEntity.getAccountId(), alarmName, historyData, AlarmHistory.HistoryItemType.ConfigurationUpdate, "Alarm \"" + alarmName + "\" updated", this.now);
                    alarmEntity.setActionsEnabled(Boolean.FALSE);
                }
                return true;
            }
        });
    }

    private static boolean modifySelectedAlarms(String accountId, Collection<String> alarmNames, Predicate<CloudWatchMetadata.AlarmMetadata> filter, Predicate<AlarmEntity> update) {
        Map<String, Collection<String>> accountToNamesMap = AlarmManager.buildAccountIdToAlarmNamesMap(accountId, alarmNames);
        EntityTransaction db = Entities.get(AlarmEntity.class);
        try {
            Criteria criteria = Entities.createCriteria(AlarmEntity.class);
            Disjunction disjunction = Restrictions.disjunction();
            for (Map.Entry<String, Collection<String>> entry : accountToNamesMap.entrySet()) {
                Conjunction conjunction = Restrictions.conjunction();
                conjunction.add((Criterion)Restrictions.eq((String)"accountId", (Object)entry.getKey()));
                conjunction.add(Restrictions.in((String)"alarmName", entry.getValue()));
                disjunction.add((Criterion)conjunction);
            }
            criteria.add((Criterion)disjunction);
            criteria.addOrder(Order.asc((String)"creationTimestamp"));
            criteria.addOrder(Order.asc((String)"naturalId"));
            List alarmEntities = criteria.list();
            if (!Iterables.all((Iterable)alarmEntities, filter)) {
                boolean bl = false;
                return bl;
            }
            CollectionUtils.each((Iterable)alarmEntities, update);
            db.commit();
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    private static Map<String, Collection<String>> buildAccountIdToAlarmNamesMap(@Nullable String accountId, @Nullable Collection<String> alarmNames) {
        HashMultimap alarmNamesMultimap = HashMultimap.create();
        if (alarmNames != null) {
            if (accountId != null) {
                alarmNamesMultimap.putAll((Object)accountId, alarmNames);
            }
            CollectionUtils.putAll((Iterable)Optional.presentInstances((Iterable)Iterables.transform(alarmNames, (Function)CloudWatchResourceName.asArnOfType((CloudWatchResourceName.Type)CloudWatchResourceName.Type.alarm))), (Multimap)alarmNamesMultimap, (Function)CloudWatchResourceName.toNamespace(), (Function)CloudWatchResourceName.toName());
        }
        return alarmNamesMultimap.asMap();
    }

    public static void setAlarmState(String accountId, String alarmName, String stateReason, String stateReasonData, AlarmEntity.StateValue stateValue, Predicate<CloudWatchMetadata.AlarmMetadata> filter) throws CloudWatchException {
        EntityTransaction db = Entities.get(AlarmEntity.class);
        try {
            AlarmEntity alarmEntity = (AlarmEntity)((Object)Entities.createCriteria(AlarmEntity.class).add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId)).add((Criterion)Restrictions.eq((String)"alarmName", (Object)alarmName)).uniqueResult());
            if (alarmEntity == null && CloudWatchResourceName.isResourceName().apply((Object)alarmName)) {
                try {
                    CloudWatchResourceName arn = CloudWatchResourceName.parse((String)alarmName, (CloudWatchResourceName.Type)CloudWatchResourceName.Type.alarm);
                    alarmEntity = (AlarmEntity)((Object)Entities.createCriteria(AlarmEntity.class).add((Criterion)Restrictions.eq((String)"accountId", (Object)arn.getNamespace())).add((Criterion)Restrictions.eq((String)"alarmName", (Object)arn.getName())).uniqueResult());
                }
                catch (CloudWatchResourceName.InvalidResourceNameException arn) {
                    // empty catch block
                }
            }
            if (alarmEntity == null || !filter.apply((Object)alarmEntity)) {
                throw new ResourceNotFoundException("Could not find alarm with name '" + alarmName + "'");
            }
            AlarmEntity.StateValue oldStateValue = alarmEntity.getStateValue();
            if (stateValue != oldStateValue) {
                Date evaluationDate = new Date();
                AlarmState newState = AlarmManager.createAlarmState(stateValue, stateReason, stateReasonData);
                AlarmManager.changeAlarmState(alarmEntity, newState, evaluationDate);
                AlarmManager.executeActions(alarmEntity, newState, true, evaluationDate);
            }
            db.commit();
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    public static List<AlarmEntity> describeAlarms(@Nullable String accountId, @Nullable String actionPrefix, @Nullable String alarmNamePrefix, @Nullable Collection<String> alarmNames, @Nullable Integer maxRecords, @Nullable AlarmEntity.StateValue stateValue, @Nullable String nextToken, Predicate<? super CloudWatchMetadata.AlarmMetadata> filter) throws CloudWatchException {
        ArrayList results = Lists.newArrayList();
        EntityTransaction db = Entities.get(AlarmEntity.class);
        try {
            boolean first = true;
            String token = nextToken;
            while (token != null || first) {
                first = false;
                Date nextTokenCreatedTime = NextTokenUtils.getNextTokenCreatedTime(token, AlarmEntity.class, true);
                Criteria criteria = Entities.createCriteria(AlarmEntity.class);
                if (accountId != null) {
                    criteria.add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
                }
                if (actionPrefix != null) {
                    int i;
                    Disjunction actionsOf = Restrictions.disjunction();
                    for (i = 1; i <= 5; ++i) {
                        actionsOf.add((Criterion)Restrictions.like((String)("okAction" + i), (Object)(actionPrefix + "%")));
                    }
                    for (i = 1; i <= 5; ++i) {
                        actionsOf.add((Criterion)Restrictions.like((String)("alarmAction" + i), (Object)(actionPrefix + "%")));
                    }
                    for (i = 1; i <= 5; ++i) {
                        actionsOf.add((Criterion)Restrictions.like((String)("insufficientDataAction" + i), (Object)(actionPrefix + "%")));
                    }
                    criteria.add((Criterion)actionsOf);
                }
                if (alarmNamePrefix != null) {
                    criteria.add((Criterion)Restrictions.like((String)"alarmName", (Object)(alarmNamePrefix + "%")));
                }
                if (alarmNames != null && !alarmNames.isEmpty()) {
                    criteria.add(Restrictions.in((String)"alarmName", alarmNames));
                }
                if (stateValue != null) {
                    criteria.add((Criterion)Restrictions.eq((String)"stateValue", (Object)((Object)stateValue)));
                }
                NextTokenUtils.addNextTokenConstraints(maxRecords == null ? null : Integer.valueOf(maxRecords - results.size()), token, nextTokenCreatedTime, criteria);
                List alarmEntities = criteria.list();
                Iterables.addAll((Collection)results, (Iterable)Iterables.filter((Iterable)alarmEntities, filter));
                token = maxRecords == null || maxRecords != null && (results.size() >= maxRecords || alarmEntities.size() < maxRecords) ? null : ((AlarmEntity)((Object)alarmEntities.get(alarmEntities.size() - 1))).getNaturalId();
            }
            db.commit();
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
        return results;
    }

    public static Collection<AlarmEntity> describeAlarmsForMetric(@Nullable String accountId, @Nonnull Map<String, String> dimensionMap, @Nullable String metricName, @Nullable String namespace, @Nullable Integer period, @Nullable AlarmEntity.Statistic statistic, @Nullable MetricEntity.Units unit, @Nonnull Predicate<? super CloudWatchMetadata.AlarmMetadata> filter) {
        ArrayList results = Lists.newArrayList();
        EntityTransaction db = Entities.get(AlarmEntity.class);
        try {
            Criteria criteria = Entities.createCriteria(AlarmEntity.class);
            if (accountId != null) {
                criteria.add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
            }
            TreeSet dimensions = Sets.newTreeSet();
            for (Map.Entry<String, String> entry : dimensionMap.entrySet()) {
                DimensionEntity d = new DimensionEntity();
                d.setName(entry.getKey());
                d.setValue(entry.getValue());
                dimensions.add(d);
            }
            int dimIndex = 1;
            for (DimensionEntity d : dimensions) {
                criteria.add((Criterion)Restrictions.eq((String)("dim" + dimIndex + "Name"), (Object)d.getName()));
                criteria.add((Criterion)Restrictions.eq((String)("dim" + dimIndex + "Value"), (Object)d.getValue()));
                ++dimIndex;
            }
            while (dimIndex <= 10) {
                criteria.add(Restrictions.isNull((String)("dim" + dimIndex + "Name")));
                criteria.add(Restrictions.isNull((String)("dim" + dimIndex + "Value")));
                ++dimIndex;
            }
            if (metricName != null) {
                criteria.add((Criterion)Restrictions.eq((String)"metricName", (Object)metricName));
            }
            if (namespace != null) {
                criteria.add((Criterion)Restrictions.eq((String)"namespace", (Object)namespace));
            }
            if (period != null) {
                criteria.add((Criterion)Restrictions.eq((String)"period", (Object)period));
            }
            if (statistic != null) {
                criteria.add((Criterion)Restrictions.eq((String)"statistic", (Object)((Object)statistic)));
            }
            if (unit != null) {
                criteria.add((Criterion)Restrictions.eq((String)"unit", (Object)((Object)unit)));
            }
            List alarmEntities = criteria.list();
            Iterables.addAll((Collection)results, (Iterable)Iterables.filter((Iterable)alarmEntities, filter));
            db.commit();
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
        return results;
    }

    public static List<AlarmHistory> describeAlarmHistory(@Nullable String accountId, @Nullable String alarmName, @Nullable Date endDate, @Nullable AlarmHistory.HistoryItemType historyItemType, @Nullable Integer maxRecords, @Nullable Date startDate, @Nullable String nextToken, Predicate<AlarmHistory> filter) throws CloudWatchException {
        ArrayList results = Lists.newArrayList();
        EntityTransaction db = Entities.get(AlarmHistory.class);
        try {
            Map accountToNamesMap = alarmName == null ? Collections.emptyMap() : AlarmManager.buildAccountIdToAlarmNamesMap(accountId, Collections.singleton(alarmName));
            boolean first = true;
            String token = nextToken;
            while (token != null || first) {
                first = false;
                Date nextTokenCreatedTime = NextTokenUtils.getNextTokenCreatedTime(token, AlarmHistory.class, true);
                Criteria criteria = Entities.createCriteria(AlarmHistory.class);
                Disjunction disjunction = Restrictions.disjunction();
                for (Map.Entry entry : accountToNamesMap.entrySet()) {
                    Conjunction conjunction = Restrictions.conjunction();
                    conjunction.add((Criterion)Restrictions.eq((String)"accountId", entry.getKey()));
                    conjunction.add(Restrictions.in((String)"alarmName", (Collection)((Collection)entry.getValue())));
                    disjunction.add((Criterion)conjunction);
                }
                criteria.add((Criterion)disjunction);
                if (historyItemType != null) {
                    criteria.add((Criterion)Restrictions.eq((String)"historyItemType", (Object)((Object)historyItemType)));
                }
                if (startDate != null) {
                    criteria.add((Criterion)Restrictions.ge((String)"timestamp", (Object)startDate));
                }
                if (endDate != null) {
                    criteria.add((Criterion)Restrictions.le((String)"timestamp", (Object)endDate));
                }
                NextTokenUtils.addNextTokenConstraints(maxRecords == null ? null : Integer.valueOf(maxRecords - results.size()), token, nextTokenCreatedTime, criteria);
                List alarmHistoryEntities = criteria.list();
                Iterables.addAll((Collection)results, (Iterable)Iterables.filter((Iterable)alarmHistoryEntities, filter));
                token = maxRecords == null || maxRecords != null && (results.size() >= maxRecords || alarmHistoryEntities.size() < maxRecords) ? null : ((AlarmHistory)((Object)alarmHistoryEntities.get(alarmHistoryEntities.size() - 1))).getNaturalId();
            }
            db.commit();
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
        return results;
    }

    public static void deleteAlarmHistory(Date before) {
        EntityTransaction db = Entities.get(AlarmHistory.class);
        try {
            HashMap criteria = Maps.newHashMap();
            criteria.put("before", before);
            Entities.deleteAllMatching(AlarmHistory.class, (String)"WHERE timestamp < :before", (Map)criteria);
            db.commit();
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    static void changeAlarmState(AlarmEntity alarmEntity, AlarmState newState, Date now) {
        LOG.info((Object)("Updating alarm " + alarmEntity.getAlarmName() + " from " + (Object)((Object)alarmEntity.getStateValue()) + " to " + (Object)((Object)newState.getStateValue())));
        alarmEntity.setStateUpdatedTimestamp(now);
        JSONObject historyDataJSON = new JSONObject();
        historyDataJSON.element("version", (Object)"1.0");
        historyDataJSON.element("oldState", (Map)AlarmManager.getJSONObjectFromState(alarmEntity.getStateValue(), alarmEntity.getStateReason(), alarmEntity.getStateReasonData()));
        historyDataJSON.element("newState", (Map)AlarmManager.getJSONObjectFromState(newState.getStateValue(), newState.getStateReason(), newState.getStateReasonData()));
        String historyData = historyDataJSON.toString();
        AlarmManager.addAlarmHistoryItem(alarmEntity.getAccountId(), alarmEntity.getAlarmName(), historyData, AlarmHistory.HistoryItemType.StateUpdate, " Alarm updated from " + (Object)((Object)alarmEntity.getStateValue()) + " to " + (Object)((Object)newState.getStateValue()), now);
        alarmEntity.setStateReason(newState.getStateReason());
        alarmEntity.setStateReasonData(newState.getStateReasonData());
        alarmEntity.setStateValue(newState.getStateValue());
        alarmEntity.setStateUpdatedTimestamp(now);
    }

    private static JSONObject getJSONObjectFromState(AlarmEntity.StateValue stateValue, String stateReason, String stateReasonData) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.element("stateValue", (Object)stateValue.toString());
        jsonObject.element("stateReason", (Object)stateReason);
        if (stateReasonData != null) {
            jsonObject.element("stateReasonData", (Object)stateReasonData);
        }
        return jsonObject;
    }

    static void executeActions(AlarmEntity alarmEntity, AlarmState state, boolean stateJustChanged, Date now) {
        if (alarmEntity.getActionsEnabled().booleanValue()) {
            Collection<String> actions = AlarmUtils.getActionsByState(alarmEntity, state);
            for (String action : actions) {
                Action actionToExecute = ActionManager.getAction(action, alarmEntity.getDimensionMap());
                if (actionToExecute == null) {
                    LOG.warn((Object)("Unsupported action " + action));
                    continue;
                }
                if (!actionToExecute.alwaysExecute() && !stateJustChanged) continue;
                LOG.info((Object)("Executing alarm " + alarmEntity.getAlarmName() + " action " + action));
                actionToExecute.executeAction(action, alarmEntity.getDimensionMap(), alarmEntity, now);
            }
        }
        alarmEntity.setLastActionsUpdatedTimestamp(now);
    }

    private static String createStateReasonData(AlarmEntity.StateValue stateValue, List<Double> relevantDataPoints, List<Double> recentDataPoints, AlarmEntity.ComparisonOperator comparisonOperator, Double threshold, String stateReason, Integer period, Date queryDate, AlarmEntity.Statistic statistic) {
        JSONObject stateReasonDataJSON = new JSONObject();
        stateReasonDataJSON.element("version", (Object)"1.0");
        stateReasonDataJSON.element("queryDate", (Object)Timestamps.formatIso8601UTCLongDateMillisTimezone((Date)queryDate));
        stateReasonDataJSON.element("statistic", (Object)statistic.toString());
        stateReasonDataJSON.element("recentDatapoints", AlarmManager.pruneNullsAtBeginning(recentDataPoints));
        stateReasonDataJSON.element("period", (Object)period);
        stateReasonDataJSON.element("threshold", (Object)threshold);
        String stateReasonData = stateReasonDataJSON.toString();
        return stateReasonData;
    }

    private static List<Double> pruneNullsAtBeginning(List<Double> recentDataPoints) {
        ArrayList<Double> returnValue = new ArrayList<Double>();
        boolean foundNotNull = false;
        for (Double recentDataPoint : recentDataPoints) {
            if (recentDataPoint != null) {
                foundNotNull = true;
            }
            if (!foundNotNull) continue;
            returnValue.add(recentDataPoint);
        }
        return returnValue;
    }

    private static String createStateReason(AlarmEntity.StateValue stateValue, List<Double> relevantDataPoints, AlarmEntity.ComparisonOperator comparisonOperator, Double threshold) {
        String stateReason = null;
        stateReason = stateValue == AlarmEntity.StateValue.INSUFFICIENT_DATA ? "Insufficient Data: " + relevantDataPoints.size() + AlarmUtils.matchSingularPlural(relevantDataPoints.size(), " datapoint was ", " datapoints were ") + "unknown." : "Threshold Crossed: " + relevantDataPoints.size() + AlarmUtils.matchSingularPlural(relevantDataPoints.size(), " datapoint ", " datapoints ") + AlarmUtils.makeDoubleList(relevantDataPoints) + AlarmUtils.matchSingularPlural(relevantDataPoints.size(), " was ", " were ") + (stateValue == AlarmEntity.StateValue.OK ? " not " : "") + AlarmUtils.comparisonOperatorString(comparisonOperator) + " the threshold (" + threshold + ").";
        return stateReason;
    }

    static AlarmState createAlarmState(AlarmEntity.StateValue stateValue, List<Double> relevantDataPoints, List<Double> recentDataPoints, AlarmEntity.ComparisonOperator comparisonOperator, Double threshold, Integer period, Date queryDate, AlarmEntity.Statistic statistic) {
        String stateReason = AlarmManager.createStateReason(stateValue, relevantDataPoints, comparisonOperator, threshold);
        return AlarmManager.createAlarmState(stateValue, relevantDataPoints, recentDataPoints, comparisonOperator, threshold, stateReason, period, queryDate, statistic);
    }

    static AlarmState createAlarmState(AlarmEntity.StateValue stateValue, List<Double> relevantDataPoints, List<Double> recentDataPoints, AlarmEntity.ComparisonOperator comparisonOperator, Double threshold, String stateReason, Integer period, Date queryDate, AlarmEntity.Statistic statistic) {
        String stateReasonData = AlarmManager.createStateReasonData(stateValue, relevantDataPoints, recentDataPoints, comparisonOperator, threshold, stateReason, period, queryDate, statistic);
        return new AlarmState(stateValue, stateReason, stateReasonData);
    }

    private static AlarmState createAlarmState(AlarmEntity.StateValue stateValue, String stateReason, String stateReasonData) {
        return new AlarmState(stateValue, stateReason, stateReasonData);
    }

    public static class ActionManager {
        private static List<Action> actions = new ArrayList<Action>();

        public static Action getAction(String action, Map<String, String> dimensionMap) {
            for (Action actionFromList : actions) {
                if (!actionFromList.filter(action, dimensionMap)) continue;
                return actionFromList;
            }
            return null;
        }

        static {
            actions.add(new StopInstanceAction());
            actions.add(new TerminateInstanceAction());
            actions.add(new ExecuteAutoScalingPolicyAction());
        }
    }

    private static class StopInstanceAction
    extends Action {
        private StopInstanceAction() {
        }

        @Override
        public boolean filter(String action, Map<String, String> dimensionMap) {
            if (action == null) {
                return false;
            }
            if (!action.startsWith("arn:aws:automate:")) {
                return false;
            }
            if (!action.endsWith(":ec2:stop")) {
                return false;
            }
            if (dimensionMap == null) {
                return false;
            }
            return dimensionMap.containsKey("InstanceId");
        }

        @Override
        public void executeAction(final String action, Map<String, String> dimensionMap, final AlarmEntity alarmEntity, final Date now) {
            StopInstancesType stopInstances = new StopInstancesType();
            stopInstances.getInstancesSet().add(dimensionMap.get("InstanceId"));
            Callback.Checked<ComputeMessage> callback = new Callback.Checked<ComputeMessage>(){

                public void fire(ComputeMessage input) {
                    StopInstanceAction.this.success(action, alarmEntity, now);
                }

                public void fireException(Throwable t) {
                    StopInstanceAction.this.failure(action, alarmEntity, now, t);
                }
            };
            try {
                Account account = Accounts.getAccountProvider().lookupAccountById(alarmEntity.getAccountId());
                User user = account.lookupUserByName("admin");
                EucalyptusClient client = new EucalyptusClient(user.getUserId());
                client.init();
                client.dispatch((BaseMessage)stopInstances, (Callback.Checked)callback);
            }
            catch (Exception ex) {
                this.failure(action, alarmEntity, now, ex);
            }
        }

        @Override
        public boolean alwaysExecute() {
            return false;
        }
    }

    private static class TerminateInstanceAction
    extends Action {
        private TerminateInstanceAction() {
        }

        @Override
        public boolean filter(String action, Map<String, String> dimensionMap) {
            if (action == null) {
                return false;
            }
            if (!action.startsWith("arn:aws:automate:")) {
                return false;
            }
            if (!action.endsWith(":ec2:terminate")) {
                return false;
            }
            if (dimensionMap == null) {
                return false;
            }
            return dimensionMap.containsKey("InstanceId");
        }

        @Override
        public void executeAction(final String action, Map<String, String> dimensionMap, final AlarmEntity alarmEntity, final Date now) {
            TerminateInstancesType terminateInstances = new TerminateInstancesType();
            terminateInstances.getInstancesSet().add(dimensionMap.get("InstanceId"));
            Callback.Checked<ComputeMessage> callback = new Callback.Checked<ComputeMessage>(){

                public void fire(ComputeMessage input) {
                    TerminateInstanceAction.this.success(action, alarmEntity, now);
                }

                public void fireException(Throwable t) {
                    TerminateInstanceAction.this.failure(action, alarmEntity, now, t);
                }
            };
            try {
                Account account = Accounts.getAccountProvider().lookupAccountById(alarmEntity.getAccountId());
                User user = account.lookupUserByName("admin");
                EucalyptusClient client = new EucalyptusClient(user.getUserId());
                client.init();
                client.dispatch((BaseMessage)terminateInstances, (Callback.Checked)callback);
            }
            catch (Exception ex) {
                this.failure(action, alarmEntity, now, ex);
            }
        }

        @Override
        public boolean alwaysExecute() {
            return false;
        }
    }

    private static class ExecuteAutoScalingPolicyAction
    extends Action {
        private ExecuteAutoScalingPolicyAction() {
        }

        @Override
        public boolean filter(String action, Map<String, String> dimensionMap) {
            return action != null && action.startsWith("arn:aws:autoscaling:");
        }

        @Override
        public void executeAction(final String action, Map<String, String> dimensionMap, final AlarmEntity alarmEntity, final Date now) {
            ExecutePolicyType executePolicyType = new ExecutePolicyType();
            executePolicyType.setPolicyName(action);
            executePolicyType.setHonorCooldown(Boolean.valueOf(true));
            Callback.Checked<AutoScalingMessage> callback = new Callback.Checked<AutoScalingMessage>(){

                public void fire(AutoScalingMessage input) {
                    ExecuteAutoScalingPolicyAction.this.success(action, alarmEntity, now);
                }

                public void fireException(Throwable t) {
                    ExecuteAutoScalingPolicyAction.this.failure(action, alarmEntity, now, t);
                }
            };
            try {
                Account account = Accounts.getAccountProvider().lookupAccountById(alarmEntity.getAccountId());
                User user = account.lookupUserByName("admin");
                AutoScalingClient client = new AutoScalingClient(user.getUserId());
                client.init();
                client.dispatch((BaseMessage)executePolicyType, (Callback.Checked)callback);
            }
            catch (Exception ex) {
                this.failure(action, alarmEntity, now, ex);
            }
        }

        @Override
        public boolean alwaysExecute() {
            return true;
        }
    }

    private static abstract class Action {
        private Action() {
        }

        public abstract boolean filter(String var1, Map<String, String> var2);

        public abstract void executeAction(String var1, Map<String, String> var2, AlarmEntity var3, Date var4);

        public abstract boolean alwaysExecute();

        public void success(String actionARN, AlarmEntity alarmEntity, Date now) {
            JSONObject historyDataJSON = new JSONObject();
            historyDataJSON.element("actionState", (Object)"Succeeded");
            historyDataJSON.element("notificationResource", (Object)actionARN);
            historyDataJSON.element("stateUpdateTimestamp", (Object)Timestamps.formatIso8601UTCLongDateMillisTimezone((Date)alarmEntity.getStateUpdatedTimestamp()));
            String historyData = historyDataJSON.toString();
            AlarmManager.addAlarmHistoryItem(alarmEntity.getAccountId(), alarmEntity.getAlarmName(), historyData, AlarmHistory.HistoryItemType.Action, " Successfully executed action " + actionARN, now);
        }

        public void failure(String actionARN, AlarmEntity alarmEntity, Date now, Throwable cause) {
            JSONObject historyDataJSON = new JSONObject();
            historyDataJSON.element("actionState", (Object)"Failed");
            historyDataJSON.element("notificationResource", (Object)actionARN);
            historyDataJSON.element("stateUpdateTimestamp", (Object)Timestamps.formatIso8601UTCLongDateMillisTimezone((Date)alarmEntity.getStateUpdatedTimestamp()));
            historyDataJSON.element("error", (Object)(cause.getMessage() != null ? cause.getMessage() : cause.getClass().getName()));
            String historyData = historyDataJSON.toString();
            AlarmManager.addAlarmHistoryItem(alarmEntity.getAccountId(), alarmEntity.getAlarmName(), historyData, AlarmHistory.HistoryItemType.Action, " Failed to execute action " + actionARN, now);
        }
    }

    private static class EucalyptusClient
    extends DispatchingClient<ComputeMessage, Eucalyptus> {
        public EucalyptusClient(String userId) {
            super(userId, Eucalyptus.class);
        }
    }

    private static class AutoScalingClient
    extends DispatchingClient<AutoScalingMessage, AutoScaling> {
        public AutoScalingClient(String userId) {
            super(userId, AutoScaling.class);
        }
    }
}

