/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.domain.alarms;

import com.eucalyptus.component.annotation.RemotablePersistence;
import com.eucalyptus.entities.AbstractPersistent;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloudwatch_backend")
@RemotablePersistence
@Table(name="alarm_history")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class AlarmHistory
extends AbstractPersistent {
    private static final Logger LOG = Logger.getLogger(AlarmHistory.class);
    @Column(name="account_id", nullable=false)
    private String accountId;
    @Column(name="alarm_name", nullable=false)
    private String alarmName;
    @Column(name="history_data", length=4095)
    private String historyData;
    @Column(name="history_item_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private HistoryItemType historyItemType;
    @Column(name="history_summary", nullable=false)
    private String historySummary;
    @Column(name="timestamp", nullable=false)
    private Date timestamp;

    public String toString() {
        return "AlarmHistory [accountId=" + this.accountId + ", alarmName=" + this.alarmName + ", historyData=" + this.historyData + ", historyItemType=" + (Object)((Object)this.historyItemType) + ", historySummary=" + this.historySummary + ", timestamp=" + this.timestamp + "]";
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAlarmName() {
        return this.alarmName;
    }

    public void setAlarmName(String alarmName) {
        this.alarmName = alarmName;
    }

    public String getHistoryData() {
        return this.historyData;
    }

    public void setHistoryData(String historyData) {
        this.historyData = historyData;
    }

    public HistoryItemType getHistoryItemType() {
        return this.historyItemType;
    }

    public void setHistoryItemType(HistoryItemType historyItemType) {
        this.historyItemType = historyItemType;
    }

    public String getHistorySummary() {
        return this.historySummary;
    }

    public void setHistorySummary(String historySummary) {
        this.historySummary = historySummary;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public static Logger getLog() {
        return LOG;
    }

    public static enum HistoryItemType {
        ConfigurationUpdate,
        StateUpdate,
        Action;

    }
}

