/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.domain.absolute;

import com.eucalyptus.cloudwatch.domain.absolute.AbsoluteMetricHistory;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricDataQueue;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.records.Logs;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class AbsoluteMetricHelper {
    private static final Logger LOG = Logger.getLogger(AbsoluteMetricHelper.class);
    private static final long MAX_DIFFERENCE_DURATION_MS = TimeUnit.MINUTES.toMillis(15L);

    public static MetricDifferenceInfo calculateDifferenceSinceLastEvent(MetricDataQueue.AbsoluteMetricCache cache, String namespace, String metricName, String dimensionName, String dimensionValue, Date newTimestamp, Double newMetricValue) {
        LOG.trace((Object)("namespace=" + namespace + ",metricName=" + metricName + ",dimensionName=" + dimensionName + ",dimensionValue=" + dimensionValue + ",newTimestamp=" + newTimestamp + ",newMetricValue=" + newMetricValue));
        MetricDifferenceInfo returnValue = null;
        AbsoluteMetricHistory lastEntity = cache.lookup(namespace, metricName, dimensionName, dimensionValue);
        if (lastEntity == null) {
            LOG.trace((Object)"First entry");
            lastEntity = new AbsoluteMetricHistory();
            lastEntity.setNamespace(namespace);
            lastEntity.setMetricName(metricName);
            lastEntity.setDimensionName(dimensionName);
            lastEntity.setDimensionValue(dimensionValue);
            lastEntity.setTimestamp(newTimestamp);
            lastEntity.setLastMetricValue(newMetricValue);
            Entities.persist((Object)((Object)lastEntity));
            cache.put(namespace, metricName, dimensionName, dimensionValue, lastEntity);
            returnValue = null;
        } else {
            double TOLERANCE = 1.0E-7;
            long elapsedTimeInMillis = newTimestamp.getTime() - lastEntity.getTimestamp().getTime();
            LOG.trace((Object)("lastTimestamp=" + lastEntity.getTimestamp()));
            double valueDifference = newMetricValue - lastEntity.getLastMetricValue();
            if (elapsedTimeInMillis < 0L) {
                LOG.trace((Object)"earlier point, kicking out");
                return null;
            }
            if (elapsedTimeInMillis == 0L) {
                if (Math.abs(valueDifference) > TOLERANCE) {
                    LOG.warn((Object)("Getting different values " + newMetricValue + " and " + lastEntity.getLastMetricValue() + " for absolute metric " + metricName + " at the same timestamp " + newTimestamp + ", keeping the second value."));
                }
                return null;
            }
            if (elapsedTimeInMillis > MAX_DIFFERENCE_DURATION_MS) {
                LOG.trace((Object)("too much time has passed, (" + elapsedTimeInMillis + " ms), starting over"));
                lastEntity.setTimestamp(newTimestamp);
                lastEntity.setLastMetricValue(newMetricValue);
                returnValue = null;
            } else if (elapsedTimeInMillis > 0L) {
                lastEntity.setTimestamp(newTimestamp);
                lastEntity.setLastMetricValue(newMetricValue);
                if (valueDifference < -TOLERANCE) {
                    returnValue = null;
                } else {
                    if (Math.abs(valueDifference) < TOLERANCE) {
                        valueDifference = 0.0;
                    }
                    returnValue = new MetricDifferenceInfo(valueDifference, elapsedTimeInMillis);
                }
            }
            if (returnValue != null) {
                LOG.trace((Object)("new values=valueDifference=" + valueDifference + ",elapsedTimeInMillis=" + elapsedTimeInMillis));
            } else {
                LOG.trace((Object)"sending null value out");
            }
        }
        return returnValue;
    }

    public static MetricDifferenceInfo calculateDifferenceSinceLastEvent(String namespace, String metricName, String dimensionName, String dimensionValue, Date newTimestamp, Double newMetricValue) {
        LOG.trace((Object)("namespace=" + namespace + ",metricName=" + metricName + ",dimensionName=" + dimensionName + ",dimensionValue=" + dimensionValue + ",newTimestamp=" + newTimestamp + ",newMetricValue=" + newMetricValue));
        MetricDifferenceInfo returnValue = null;
        EntityTransaction db = Entities.get(AbsoluteMetricHistory.class);
        try {
            Criteria criteria = Entities.createCriteria(AbsoluteMetricHistory.class).add((Criterion)Restrictions.eq((String)"namespace", (Object)namespace)).add((Criterion)Restrictions.eq((String)"metricName", (Object)metricName)).add((Criterion)Restrictions.eq((String)"dimensionName", (Object)dimensionName)).add((Criterion)Restrictions.eq((String)"dimensionValue", (Object)dimensionValue));
            AbsoluteMetricHistory lastEntity = (AbsoluteMetricHistory)((Object)criteria.uniqueResult());
            if (lastEntity == null) {
                LOG.trace((Object)"First entry");
                lastEntity = new AbsoluteMetricHistory();
                lastEntity.setNamespace(namespace);
                lastEntity.setMetricName(metricName);
                lastEntity.setDimensionName(dimensionName);
                lastEntity.setDimensionValue(dimensionValue);
                lastEntity.setTimestamp(newTimestamp);
                lastEntity.setLastMetricValue(newMetricValue);
                Entities.persist((Object)((Object)lastEntity));
                returnValue = null;
            } else {
                double TOLERANCE = 1.0E-7;
                long elapsedTimeInMillis = newTimestamp.getTime() - lastEntity.getTimestamp().getTime();
                LOG.trace((Object)("lastTimestamp=" + lastEntity.getTimestamp()));
                double valueDifference = newMetricValue - lastEntity.getLastMetricValue();
                if (elapsedTimeInMillis < 0L) {
                    LOG.trace((Object)"earlier point, kicking out");
                    returnValue = null;
                } else if (elapsedTimeInMillis == 0L) {
                    if (Math.abs(valueDifference) > TOLERANCE) {
                        LOG.warn((Object)("Getting different values " + newMetricValue + " and " + lastEntity.getLastMetricValue() + " for absolute metric " + metricName + " at the same timestamp " + newTimestamp + ", keeping the second value."));
                    }
                    returnValue = null;
                } else if (elapsedTimeInMillis > MAX_DIFFERENCE_DURATION_MS) {
                    LOG.trace((Object)("too much time has passed, (" + elapsedTimeInMillis + " ms), starting over"));
                    lastEntity.setTimestamp(newTimestamp);
                    lastEntity.setLastMetricValue(newMetricValue);
                    returnValue = null;
                } else if (elapsedTimeInMillis > 0L) {
                    lastEntity.setTimestamp(newTimestamp);
                    lastEntity.setLastMetricValue(newMetricValue);
                    if (valueDifference < -TOLERANCE) {
                        returnValue = null;
                    } else {
                        if (Math.abs(valueDifference) < TOLERANCE) {
                            valueDifference = 0.0;
                        }
                        returnValue = new MetricDifferenceInfo(valueDifference, elapsedTimeInMillis);
                    }
                }
                if (returnValue != null) {
                    LOG.trace((Object)("new values=valueDifference=" + valueDifference + ",elapsedTimeInMillis=" + elapsedTimeInMillis));
                } else {
                    LOG.trace((Object)"sending null value out");
                }
            }
            db.commit();
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
        return returnValue;
    }

    public static void deleteAbsoluteMetricHistory(Date before) {
        EntityTransaction db = Entities.get(AbsoluteMetricHistory.class);
        try {
            HashMap<String, Date> criteria = new HashMap<String, Date>();
            criteria.put("before", before);
            Entities.deleteAllMatching(AbsoluteMetricHistory.class, (String)"WHERE timestamp < :before", criteria);
            db.commit();
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    public static class MetricDifferenceInfo {
        private Double valueDifference;
        private Long elapsedTimeInMillis;

        public Double getValueDifference() {
            return this.valueDifference;
        }

        public Long getElapsedTimeInMillis() {
            return this.elapsedTimeInMillis;
        }

        public MetricDifferenceInfo(Double valueDifference, Long elapsedTimeInMillis) {
            this.valueDifference = valueDifference;
            this.elapsedTimeInMillis = elapsedTimeInMillis;
        }
    }
}

